/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.core.util;

public class BoundUtils {
    public static final float[] NORMALIZED_CLAMP = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};

    private BoundUtils() {
    }

    public static float[] clampBounds(float[] target, float[] clamp) {
        assert (target.length == 6);
        if (target[0] < clamp[0]) {
            target[0] = clamp[0];
        }
        if (target[1] < clamp[1]) {
            target[1] = clamp[1];
        }
        if (target[2] < clamp[2]) {
            target[2] = clamp[2];
        }
        if (target[3] > clamp[3]) {
            target[3] = clamp[3];
        }
        if (target[4] > clamp[4]) {
            target[4] = clamp[4];
        }
        if (target[5] > clamp[5]) {
            target[5] = clamp[5];
        }
        return target;
    }

    public static float[] clampBounds(float[] target) {
        return BoundUtils.clampBounds(target, NORMALIZED_CLAMP);
    }

    public static float[] addBounds(float[] target, float[] expander) {
        assert (target.length == 6);
        target[0] = target[0] + expander[0];
        target[1] = target[1] + expander[1];
        target[2] = target[2] + expander[2];
        target[3] = target[3] + expander[3];
        target[4] = target[4] + expander[4];
        target[5] = target[5] + expander[5];
        return target;
    }

    public static float[] subBounds(float[] target, float[] contractor) {
        assert (target.length == 6);
        target[0] = target[0] - contractor[0];
        target[1] = target[1] - contractor[1];
        target[2] = target[2] - contractor[2];
        target[3] = target[3] - contractor[3];
        target[4] = target[4] - contractor[4];
        target[5] = target[5] - contractor[5];
        return target;
    }

    public static float[] newBoundsArray() {
        return new float[6];
    }

    public static float[] translateBounds(float[] target, float x, float y, float z, float[] src) {
        assert (target.length == 6);
        target[0] = src[0] + x;
        target[1] = src[1] + y;
        target[2] = src[2] + z;
        target[3] = src[3] + x;
        target[4] = src[4] + y;
        target[5] = src[5] + z;
        return target;
    }

    public static float[] scaleBounds(float[] target, float scale, float x, float y, float z, float x2, float y2, float z2) {
        assert (target.length == 6);
        target[0] = x * scale;
        target[1] = y * scale;
        target[2] = z * scale;
        target[3] = x2 * scale;
        target[4] = y2 * scale;
        target[5] = z2 * scale;
        return target;
    }

    public static float[] scaleBounds(float[] target, float scale, float[] src) {
        assert (src.length == 6);
        return BoundUtils.scaleBounds(target, scale, src[0], src[1], src[2], src[3], src[4], src[5]);
    }

    public static float[] newScaledBounds(float scale, float x, float y, float z, float x2, float y2, float z2) {
        float[] result = BoundUtils.newBoundsArray();
        return BoundUtils.scaleBounds(result, scale, x, y, z, x2, y2, z2);
    }

    public static float[] cubeToBounds(float[] target, float x, float y, float z, float w, float d, float h) {
        assert (target.length == 6);
        target[0] = x;
        target[1] = y;
        target[2] = z;
        target[3] = x + w;
        target[4] = y + d;
        target[5] = z + h;
        return target;
    }

    public static float[] cubeToBounds(float[] target, float[] src) {
        assert (src.length == 6);
        return BoundUtils.cubeToBounds(target, src[0], src[1], src[2], src[3], src[4], src[5]);
    }

    public static float[] newCubeToBounds(float x, float y, float z, float w, float d, float h) {
        float[] result = BoundUtils.newBoundsArray();
        return BoundUtils.cubeToBounds(result, x, y, z, w, d, h);
    }

    public static float[] centeredCubeBounds(float[] target, float w, float d, float h) {
        float x = (1.0f - w) / 2.0f;
        float y = (1.0f - d) / 2.0f;
        float z = (1.0f - h) / 2.0f;
        return BoundUtils.cubeToBounds(target, x, y, z, w, d, h);
    }

    public static float[] newCenteredCubeBounds(float w, float d, float h) {
        return BoundUtils.centeredCubeBounds(BoundUtils.newBoundsArray(), w, d, h);
    }
}

