/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.core.schema;

import growthcraft.api.core.definition.IItemStackListProvider;
import growthcraft.api.core.definition.IMultiItemStacks;
import growthcraft.api.core.item.OreItemStacks;
import growthcraft.api.core.schema.IValidatable;
import growthcraft.api.core.schema.ItemStackSchema;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class ItemKeySchema
extends ItemStackSchema
implements IItemStackListProvider,
IValidatable {
    public String ore;

    public ItemKeySchema(@Nonnull String mid, @Nonnull String name, int amt, int mt) {
        super(mid, name, amt, mt);
    }

    public ItemKeySchema(@Nonnull String o, int amt) {
        this.ore = o;
        this.amount = amt;
    }

    public ItemKeySchema(@Nonnull ItemStack stack) {
        super(stack);
    }

    public ItemKeySchema() {
    }

    public List<ItemStack> getOres() {
        if (this.ore != null) {
            return OreDictionary.getOres((String)this.ore);
        }
        return null;
    }

    @Override
    public List<ItemStack> getItemStacks() {
        List<ItemStack> result = super.getItemStacks();
        List<ItemStack> ores = this.getOres();
        if (ores != null) {
            for (ItemStack item : ores) {
                ItemStack stack = item.func_77946_l();
                stack.field_77994_a = this.amount;
                result.add(stack);
            }
        }
        return result;
    }

    @Override
    public List<IMultiItemStacks> getMultiItemStacks() {
        List<IMultiItemStacks> result = super.getMultiItemStacks();
        if (this.ore != null) {
            result.add(new OreItemStacks(this.ore, this.amount));
        }
        return result;
    }

    @Override
    public String toString() {
        String result = String.format("Schema<ItemKey>(comment: '%s', amount: %d)", this.comment, this.amount);
        if (this.mod_id != null && this.name != null) {
            result = result + String.format("~(mod_id: '%s', name: '%s', meta: %d)", this.mod_id, this.name, this.meta);
        }
        if (this.ore != null) {
            result = result + String.format("~(ore: '%s')", this.ore);
        }
        return result;
    }

    @Override
    public boolean isValid() {
        return this.getItemStacks().size() > 0 || this.ore != null;
    }

    @Override
    public boolean isInvalid() {
        return !this.isValid();
    }

    public static List<ItemKeySchema> createMulti(Object obj) {
        ArrayList<ItemKeySchema> result = new ArrayList<ItemKeySchema>();
        if (obj instanceof OreItemStacks) {
            OreItemStacks oreItemStack = (OreItemStacks)obj;
            result.add(new ItemKeySchema(oreItemStack.getName(), oreItemStack.getStackSize()));
        } else if (obj instanceof IMultiItemStacks) {
            IMultiItemStacks multiStack = (IMultiItemStacks)obj;
            for (ItemStack stack : multiStack.getItemStacks()) {
                result.add(new ItemKeySchema(stack));
            }
        } else if (obj instanceof ItemStack) {
            result.add(new ItemKeySchema((ItemStack)obj));
        } else {
            throw new IllegalArgumentException("Wrong type, expected a ItemStack or OreItemStacks, or IMultiItemStacks");
        }
        return result;
    }
}

