/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.core.fluids;

import growthcraft.api.core.definition.IMultiFluidStacks;
import growthcraft.api.core.fluids.FluidTest;
import growthcraft.api.core.fluids.FluidUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class MultiFluidStacks
implements IMultiFluidStacks {
    private List<FluidStack> fluidStacks;
    private transient List<ItemStack> fluidContainers;

    public MultiFluidStacks(@Nonnull List<FluidStack> stacks) {
        this.fluidStacks = stacks;
    }

    public MultiFluidStacks(FluidStack ... stacks) {
        this(Arrays.asList(stacks));
    }

    public List<String> getNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (FluidStack stack : this.fluidStacks) {
            Fluid fluid = stack.getFluid();
            if (fluid == null) continue;
            result.add(fluid.getName());
        }
        return result;
    }

    @Override
    public int getAmount() {
        Iterator<FluidStack> i$ = this.fluidStacks.iterator();
        if (i$.hasNext()) {
            FluidStack stack = i$.next();
            return stack.amount;
        }
        return 0;
    }

    @Override
    public List<FluidStack> getFluidStacks() {
        return this.fluidStacks;
    }

    @Override
    public boolean containsFluid(@Nullable Fluid expectedFluid) {
        if (FluidTest.isValid(expectedFluid)) {
            for (FluidStack content : this.getFluidStacks()) {
                if (content.getFluid() != expectedFluid) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsFluidStack(@Nullable FluidStack stack) {
        if (!FluidTest.isValid(stack)) {
            return false;
        }
        for (FluidStack content : this.getFluidStacks()) {
            if (!content.isFluidEqual(stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<ItemStack> getItemStacks() {
        if (this.fluidContainers == null) {
            this.fluidContainers = FluidUtils.getFluidContainers(this.getFluidStacks());
        }
        return this.fluidContainers;
    }
}

