/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.core.effect;

import growthcraft.api.core.effect.AbstractEffect;
import growthcraft.api.core.i18n.GrcI18n;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class EffectRemovePotionEffect
extends AbstractEffect {
    private int potionId;

    public EffectRemovePotionEffect(int potnId) {
        this.potionId = potnId;
    }

    public EffectRemovePotionEffect() {
    }

    public EffectRemovePotionEffect setPotionID(int id) {
        this.potionId = id;
        return this;
    }

    public int getPotionID() {
        return this.potionId;
    }

    @Override
    public void apply(World world, Entity entity, Random random, Object data) {
        if (this.potionId > 0 && entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).func_82170_o(this.potionId);
        }
    }

    @Override
    protected void getActualDescription(List<String> list) {
        PotionEffect pe = new PotionEffect(this.getPotionID(), 1000, 0);
        String potionName = GrcI18n.translate(pe.func_76453_d()).trim();
        list.add(GrcI18n.translate("grc.effect.remove_potion_effect.format", potionName));
    }

    @Override
    protected void readFromNBT(NBTTagCompound data) {
        this.potionId = data.func_74762_e("potion_id");
    }

    @Override
    protected void writeToNBT(NBTTagCompound data) {
        data.func_74768_a("potion_id", this.potionId);
    }
}

