/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.cellar.pressing;

import growthcraft.api.cellar.common.Residue;
import growthcraft.api.cellar.pressing.IPressingRegistry;
import growthcraft.api.cellar.pressing.PressingRecipe;
import growthcraft.api.core.log.ILogger;
import growthcraft.api.core.log.NullLogger;
import growthcraft.api.core.util.MultiStacksUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class PressingRegistry
implements IPressingRegistry {
    private ILogger logger = NullLogger.INSTANCE;
    private List<PressingRecipe> recipes = new ArrayList<PressingRecipe>();

    @Override
    public void setLogger(@Nonnull ILogger l) {
        this.logger = l;
    }

    @Override
    public void addRecipe(@Nonnull PressingRecipe recipe) {
        this.recipes.add(recipe);
        this.logger.debug("Added new Pressing Recipe recipe={%s}", recipe);
    }

    @Override
    public void addRecipe(@Nonnull Object inputStack, @Nonnull FluidStack resultFluid, int time, @Nullable Residue residue) {
        this.addRecipe(new PressingRecipe(MultiStacksUtil.toMultiItemStacks(inputStack), resultFluid, time, residue));
    }

    @Override
    public PressingRecipe getPressingRecipe(ItemStack itemstack) {
        if (itemstack == null) {
            return null;
        }
        for (PressingRecipe recipe : this.recipes) {
            if (!recipe.matchesRecipe(itemstack)) continue;
            return recipe;
        }
        return null;
    }

    @Override
    public boolean hasPressingRecipe(ItemStack itemstack) {
        return this.getPressingRecipe(itemstack) != null;
    }
}

