/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.cellar.fermenting.user;

import growthcraft.api.cellar.CellarRegistry;
import growthcraft.api.cellar.fermenting.user.UserFermentingRecipe;
import growthcraft.api.cellar.fermenting.user.UserFermentingRecipes;
import growthcraft.api.core.definition.IMultiFluidStacks;
import growthcraft.api.core.definition.IMultiItemStacks;
import growthcraft.api.core.schema.FluidStackSchema;
import growthcraft.api.core.schema.ItemKeySchema;
import growthcraft.api.core.schema.MultiFluidStackSchema;
import growthcraft.api.core.user.AbstractUserJSONConfig;
import growthcraft.api.core.util.MultiStacksUtil;
import java.io.BufferedReader;
import java.io.Reader;
import javax.annotation.Nonnull;
import net.minecraftforge.fluids.FluidStack;

public class UserFermentingRecipesConfig
extends AbstractUserJSONConfig {
    protected UserFermentingRecipes defaultRecipes = new UserFermentingRecipes();
    protected UserFermentingRecipes recipes;

    public void addDefaultSchemas(@Nonnull ItemKeySchema item, @Nonnull MultiFluidStackSchema inputFluid, @Nonnull FluidStackSchema outputFluid, int time) {
        this.addDefault(new UserFermentingRecipe(item, inputFluid, outputFluid, time));
    }

    public void addDefault(@Nonnull UserFermentingRecipe recipe) {
        if (recipe == null) {
            this.logger.error("We have a problem here, someone tossed a null user recipe at us!", new Object[0]);
            throw new IllegalArgumentException("Oh no you didn't, FIX DAT.");
        }
        this.defaultRecipes.data.add(recipe);
        this.logger.debug("Adding default user fermenting recipe {%s}", recipe);
    }

    public void addDefault(@Nonnull Object stack, @Nonnull Object inputFluid, @Nonnull FluidStack outputFluid, int time) {
        for (ItemKeySchema itemKey : ItemKeySchema.createMulti(stack)) {
            this.addDefaultSchemas(itemKey, new MultiFluidStackSchema(MultiStacksUtil.toMultiFluidStacks(inputFluid)), new FluidStackSchema(outputFluid), time);
        }
    }

    @Override
    protected String getDefault() {
        return this.gson.toJson((Object)this.defaultRecipes);
    }

    @Override
    protected void loadFromBuffer(BufferedReader reader) throws IllegalStateException {
        this.recipes = (UserFermentingRecipes)this.gson.fromJson((Reader)reader, UserFermentingRecipes.class);
    }

    private void addRecipe(UserFermentingRecipe recipe) {
        if (recipe == null) {
            this.logger.error("Recipe is invalid!", new Object[0]);
            return;
        }
        if (recipe.item == null || !recipe.item.isValid()) {
            this.logger.error("Recipe item is invalid! {%s}", recipe);
            return;
        }
        if (recipe.input_fluid == null || !recipe.input_fluid.isValid()) {
            this.logger.error("Recipe input_fluid is invalid! {%s}", recipe);
            return;
        }
        if (recipe.output_fluid == null || !recipe.output_fluid.isValid()) {
            this.logger.error("Recipe output_fluid is invalid! {%s}", recipe);
            return;
        }
        this.logger.debug("Adding Fermenting Recipe {%s}", recipe);
        for (IMultiItemStacks item : recipe.item.getMultiItemStacks()) {
            for (IMultiFluidStacks inputFluid : recipe.input_fluid.getMultiFluidStacks()) {
                CellarRegistry.instance().fermenting().addRecipe(recipe.output_fluid.asFluidStack(), inputFluid, item, recipe.time);
            }
        }
    }

    @Override
    public void postInit() {
        if (this.recipes != null) {
            if (this.recipes.data != null) {
                this.logger.debug("Registering %d fermenting recipes.", this.recipes.data.size());
                for (UserFermentingRecipe recipe : this.recipes.data) {
                    this.addRecipe(recipe);
                }
            } else {
                this.logger.error("Fermenting Recipes data is invalid!", new Object[0]);
            }
        }
    }
}

