/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.bees.user;

import growthcraft.api.bees.BeesRegistry;
import growthcraft.api.bees.ForcedFlowerBlockEntry;
import growthcraft.api.bees.user.UserFlowerEntry;
import growthcraft.api.bees.user.UserFlowersEntries;
import growthcraft.api.core.user.AbstractUserJSONConfig;
import java.io.BufferedReader;
import java.io.Reader;
import net.minecraft.block.Block;

public class UserFlowersConfig
extends AbstractUserJSONConfig {
    private final UserFlowersEntries defaultEntries = new UserFlowersEntries();
    private UserFlowersEntries entries;

    public UserFlowerEntry addDefault(UserFlowerEntry entry) {
        this.defaultEntries.data.add(entry);
        return entry;
    }

    public UserFlowerEntry addDefault(Block flower, int meta) {
        return this.addDefault(new UserFlowerEntry(flower, meta));
    }

    public UserFlowerEntry addDefault(Block flower) {
        return this.addDefault(flower, Short.MAX_VALUE);
    }

    @Override
    protected String getDefault() {
        return this.gson.toJson((Object)this.defaultEntries);
    }

    @Override
    protected void loadFromBuffer(BufferedReader buff) throws IllegalStateException {
        this.entries = (UserFlowersEntries)this.gson.fromJson((Reader)buff, UserFlowersEntries.class);
    }

    private void addFlowerEntry(UserFlowerEntry entry) {
        if (entry == null) {
            this.logger.error("Invalid Entry", new Object[0]);
            return;
        }
        if (entry.block == null || entry.block.isInvalid()) {
            this.logger.error("Invalid block for entry {%s}", entry);
            return;
        }
        switch (entry.entry_type) {
            case "generic": {
                BeesRegistry.instance().addFlower(entry.block.getBlock(), entry.block.meta);
                break;
            }
            case "forced": {
                BeesRegistry.instance().addFlower(new ForcedFlowerBlockEntry(entry.block.getBlock(), entry.block.meta));
                break;
            }
            default: {
                this.logger.error("Invalid entry_type '%s' for entry {%s}", entry.entry_type, entry);
            }
        }
    }

    @Override
    public void postInit() {
        if (this.entries != null) {
            if (this.entries.data != null) {
                this.logger.debug("Adding %d user flower entries.", this.entries.data.size());
                for (UserFlowerEntry entry : this.entries.data) {
                    this.addFlowerEntry(entry);
                }
            } else {
                this.logger.error("Config contains invalid data.", new Object[0]);
            }
        }
    }
}

