/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import org.apache.commons.lang3.tuple.MutablePair;

public class ExtendedPropertiesPlayer
implements IExtendedEntityProperties {
    public World world;
    public EntityPlayer player;
    public MutablePair<Double, Double> lastMotions = null;
    public Float prevStep = null;
    public boolean isRangeExtended;
    public int tickCache;

    public void saveNBTData(NBTTagCompound compound) {
        if (this.lastMotions != null) {
            NBTTagCompound motionList = new NBTTagCompound();
            motionList.func_74780_a("left", ((Double)this.lastMotions.left).doubleValue());
            motionList.func_74780_a("right", ((Double)this.lastMotions.right).doubleValue());
            compound.func_74782_a("lastMotions", (NBTBase)motionList);
        }
        compound.func_74768_a("tickCache", this.tickCache);
        if (this.prevStep != null) {
            compound.func_74776_a("prevStep", this.prevStep.floatValue());
        }
        compound.func_74757_a("isRangeExtended", this.isRangeExtended);
    }

    public void loadNBTData(NBTTagCompound compound) {
        if (compound.func_74764_b("lastMotions")) {
            NBTTagCompound motionList = compound.func_74775_l("lastMotions");
            this.lastMotions.left = motionList.func_74769_h("left");
            this.lastMotions.right = motionList.func_74769_h("right");
        }
        if (compound.func_74764_b("prevStep")) {
            this.prevStep = Float.valueOf(compound.func_74760_g("prevStep"));
        }
        this.isRangeExtended = compound.func_74767_n("isRangeExtended");
        this.tickCache = compound.func_74762_e("tickCache");
    }

    public void init(Entity entity, World world) {
        this.world = world;
        this.player = (EntityPlayer)entity;
        this.isRangeExtended = false;
        this.tickCache = -1;
        if (this.lastMotions == null) {
            this.lastMotions = MutablePair.of((Object)this.player.field_70165_t, (Object)this.player.field_70161_v);
        }
    }
}

