/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft.api;

import flaxbeard.steamcraft.item.tool.steam.ItemDrillHeadUpgrade;
import flaxbeard.steamcraft.misc.DrillHeadMaterial;
import flaxbeard.steamcraft.misc.OreDictHelper;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.apache.commons.lang3.tuple.MutablePair;

public class DrillHeadRecipe
extends ShapedOreRecipe {
    public DrillHeadRecipe(Item result, Object ... recipe) {
        super(result, recipe);
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        ItemStack result = super.func_77572_b(inv);
        ItemDrillHeadUpgrade upgrade = (ItemDrillHeadUpgrade)result.func_77973_b();
        int numIronPlates = 0;
        int numNuggets = 0;
        int numIngots = 0;
        int numOthers = 0;
        ArrayList<String> materialSafetyNet = new ArrayList<String>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            String material;
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null || stack.func_77973_b() == null) continue;
            Item item = stack.func_77973_b();
            int meta = stack.func_77960_j();
            if (OreDictHelper.plateSteamcraftIrons.contains(MutablePair.of((Object)stack.func_77973_b(), (Object)stack.func_77960_j()))) {
                ++numIronPlates;
                continue;
            }
            for (Map.Entry<String, MutablePair<ArrayList<ItemStack>, ArrayList<ItemStack>>> entry : DrillHeadMaterial.materialOres.entrySet()) {
                material = entry.getKey();
                ArrayList ingots = (ArrayList)entry.getValue().left;
                ArrayList nuggets = (ArrayList)entry.getValue().right;
                for (ItemStack ingot : ingots) {
                    if (ingot.func_77973_b() != item || ingot.func_77960_j() != meta) continue;
                    ++numIngots;
                    materialSafetyNet.add(material);
                }
                for (ItemStack nugget : nuggets) {
                    if (nugget.func_77973_b() != item || nugget.func_77960_j() != meta) continue;
                    ++numNuggets;
                    materialSafetyNet.add(material);
                }
            }
            for (Map.Entry<String, Object> entry : DrillHeadMaterial.nonStandardMaterials.entrySet()) {
                material = entry.getKey();
                ArrayList list = (ArrayList)entry.getValue();
                for (ItemStack other : list) {
                    if (other.func_77973_b() != item || other.func_77960_j() != meta) continue;
                    ++numOthers;
                    materialSafetyNet.add(material);
                }
            }
        }
        if (!this.isNetSafe(materialSafetyNet) || numIronPlates != 3) {
            return null;
        }
        String mat = materialSafetyNet.get(0);
        if (numOthers == 4 && numNuggets == 0 && numIngots == 0 || numOthers == 0 && numNuggets == 1 && numIngots == 3) {
            upgrade.setMyMaterial(result, mat);
            return result;
        }
        return null;
    }

    private boolean isNetSafe(ArrayList<String> ary) {
        for (String s : ary) {
            if (s.equals(ary.get(0))) continue;
            return false;
        }
        return true;
    }
}

