/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.steamcraft;

import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import flaxbeard.steamcraft.Config;
import flaxbeard.steamcraft.SteamcraftBlocks;
import flaxbeard.steamcraft.SteamcraftBook;
import flaxbeard.steamcraft.SteamcraftItems;
import flaxbeard.steamcraft.SteamcraftRecipes;
import flaxbeard.steamcraft.api.util.SPLog;
import flaxbeard.steamcraft.block.TileEntityDummyBlock;
import flaxbeard.steamcraft.client.render.model.exosuit.ExosuitModelCache;
import flaxbeard.steamcraft.common.CommonProxy;
import flaxbeard.steamcraft.entity.EntityCanisterItem;
import flaxbeard.steamcraft.entity.EntityFloatingItem;
import flaxbeard.steamcraft.entity.EntityMortarItem;
import flaxbeard.steamcraft.entity.EntityRocket;
import flaxbeard.steamcraft.gui.SteamcraftGuiHandler;
import flaxbeard.steamcraft.handler.PhobicCoatingHandler;
import flaxbeard.steamcraft.handler.SteamcraftEventHandler;
import flaxbeard.steamcraft.handler.SteamcraftTickHandler;
import flaxbeard.steamcraft.integration.CrossMod;
import flaxbeard.steamcraft.item.ItemSmashedOre;
import flaxbeard.steamcraft.misc.DrillHeadMaterial;
import flaxbeard.steamcraft.misc.OreDictHelper;
import flaxbeard.steamcraft.network.CamoPacket;
import flaxbeard.steamcraft.network.CamoPacketHandler;
import flaxbeard.steamcraft.network.ConnectPacket;
import flaxbeard.steamcraft.network.ConnectPacketHandler;
import flaxbeard.steamcraft.network.ItemNamePacket;
import flaxbeard.steamcraft.network.ItemNamePacketHandler;
import flaxbeard.steamcraft.tile.TileEntityBoiler;
import flaxbeard.steamcraft.tile.TileEntityChargingPad;
import flaxbeard.steamcraft.tile.TileEntityCreativeTank;
import flaxbeard.steamcraft.tile.TileEntityCrucible;
import flaxbeard.steamcraft.tile.TileEntityCustomCraftingTable;
import flaxbeard.steamcraft.tile.TileEntityCustomFurnace;
import flaxbeard.steamcraft.tile.TileEntityEngineeringTable;
import flaxbeard.steamcraft.tile.TileEntityFan;
import flaxbeard.steamcraft.tile.TileEntityFlashBoiler;
import flaxbeard.steamcraft.tile.TileEntityFluidSteamConverter;
import flaxbeard.steamcraft.tile.TileEntityItemMortar;
import flaxbeard.steamcraft.tile.TileEntityMold;
import flaxbeard.steamcraft.tile.TileEntityPump;
import flaxbeard.steamcraft.tile.TileEntityRuptureDisc;
import flaxbeard.steamcraft.tile.TileEntitySmasher;
import flaxbeard.steamcraft.tile.TileEntitySteamCharger;
import flaxbeard.steamcraft.tile.TileEntitySteamFurnace;
import flaxbeard.steamcraft.tile.TileEntitySteamGauge;
import flaxbeard.steamcraft.tile.TileEntitySteamHammer;
import flaxbeard.steamcraft.tile.TileEntitySteamHeater;
import flaxbeard.steamcraft.tile.TileEntitySteamPipe;
import flaxbeard.steamcraft.tile.TileEntitySteamPiston;
import flaxbeard.steamcraft.tile.TileEntitySteamTank;
import flaxbeard.steamcraft.tile.TileEntityThumper;
import flaxbeard.steamcraft.tile.TileEntityVacuum;
import flaxbeard.steamcraft.tile.TileEntityValvePipe;
import flaxbeard.steamcraft.tile.TileEntityWhistle;
import flaxbeard.steamcraft.world.ComponentSteamWorkshop;
import flaxbeard.steamcraft.world.SteamWorkshopCreationHandler;
import flaxbeard.steamcraft.world.SteamcraftOreGen;
import flaxbeard.steamcraft.world.SteampunkVillagerTradeHandler;
import java.util.ArrayList;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.oredict.OreDictionary;

@Mod(modid="Steamcraft", name="Flaxbeard's Steam Power", version="0.29.3")
public class Steamcraft {
    @Mod.Instance(value="Steamcraft")
    public static Steamcraft instance;
    public static SPLog log;
    public static SimpleNetworkWrapper channel;
    public static EnumRarity upgrade;
    public static CreativeTabs tab;
    public static CreativeTabs tabTools;
    public static int tubeRenderID;
    public static int heaterRenderID;
    public static int chargerRenderID;
    public static int genocideRenderID;
    public static int gaugeRenderID;
    public static int ruptureDiscRenderID;
    public static int whistleRenderID;
    public static int boilerRenderID;
    public static int customCraftingTableRenderID;
    public static int furnaceRenderID;
    public static int sawRenderID;
    public static int bloodBoilerRenderID;
    public static boolean steamRegistered;
    public static Potion semiInvisible;
    public static String PLAYER_PROPERTY_ID;
    public static String VILLAGER_PROPERTY_ID;
    public static String MERCHANT_PROPERTY_ID;
    public static String CONFIG_DIR;
    @SidedProxy(clientSide="flaxbeard.steamcraft.client.ClientProxy", serverSide="flaxbeard.steamcraft.common.CommonProxy")
    public static CommonProxy proxy;

    private static void registerTileEntity(Class<? extends TileEntity> clazz, String key) {
        GameRegistry.registerTileEntityWithAlternatives(clazz, (String)("steamcraft:" + key), (String[])new String[0]);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Config.load(event);
        CONFIG_DIR = event.getModConfigurationDirectory().toString();
        tab = new SCTab(CreativeTabs.getNextID(), "steamcraft", false).func_78025_a("item_search.png");
        tabTools = new SCTab(CreativeTabs.getNextID(), "steamcraftTools", true);
        upgrade = EnumHelper.addRarity((String)"UPGRADE", (EnumChatFormatting)EnumChatFormatting.RED, (String)"Upgrade");
        SteamcraftBlocks.registerBlocks();
        SteamcraftItems.registerItems();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new SteamcraftOreGen(), (int)1);
        channel = NetworkRegistry.INSTANCE.newSimpleChannel("fspChannel");
        channel.registerMessage(CamoPacketHandler.class, CamoPacket.class, 0, Side.SERVER);
        channel.registerMessage(ItemNamePacketHandler.class, ItemNamePacket.class, 1, Side.SERVER);
        channel.registerMessage(ConnectPacketHandler.class, ConnectPacket.class, 2, Side.SERVER);
        int id = Config.villagerId;
        VillagerRegistry.instance().registerVillagerId(id);
        VillagerRegistry.instance().registerVillageTradeHandler(id, (VillagerRegistry.IVillageTradeHandler)new SteampunkVillagerTradeHandler());
        VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new SteamWorkshopCreationHandler());
        MapGenStructureIO.func_143031_a(ComponentSteamWorkshop.class, (String)"steamcraft:workshop");
        EntityRegistry.registerModEntity(EntityFloatingItem.class, (String)"FloatingItem", (int)0, (Object)instance, (int)64, (int)20, (boolean)true);
        EntityRegistry.registerModEntity(EntityMortarItem.class, (String)"MortarItem", (int)1, (Object)instance, (int)64, (int)20, (boolean)true);
        EntityRegistry.registerModEntity(EntityCanisterItem.class, (String)"CanisterItem", (int)2, (Object)instance, (int)64, (int)20, (boolean)true);
        EntityRegistry.registerModEntity(EntityRocket.class, (String)"Rocket", (int)3, (Object)instance, (int)64, (int)20, (boolean)true);
        Steamcraft.registerTileEntity(TileEntityCrucible.class, "steamcraftCrucible");
        Steamcraft.registerTileEntity(TileEntityMold.class, "mold");
        Steamcraft.registerTileEntity(TileEntityBoiler.class, "boiler");
        Steamcraft.registerTileEntity(TileEntitySteamPipe.class, "pipe");
        Steamcraft.registerTileEntity(TileEntityValvePipe.class, "valvePipe");
        Steamcraft.registerTileEntity(TileEntitySteamPiston.class, "steamPiston");
        Steamcraft.registerTileEntity(TileEntitySteamHeater.class, "heater");
        Steamcraft.registerTileEntity(TileEntityEngineeringTable.class, "engineeringTable");
        Steamcraft.registerTileEntity(TileEntitySteamCharger.class, "steamCharger");
        Steamcraft.registerTileEntity(TileEntitySteamTank.class, "steamTank");
        Steamcraft.registerTileEntity(TileEntitySteamGauge.class, "steamGauge");
        Steamcraft.registerTileEntity(TileEntityRuptureDisc.class, "ruptureDisc");
        Steamcraft.registerTileEntity(TileEntityCreativeTank.class, "creativeSteamTank");
        Steamcraft.registerTileEntity(TileEntitySteamHammer.class, "steamHammer");
        Steamcraft.registerTileEntity(TileEntityItemMortar.class, "itemMortar");
        Steamcraft.registerTileEntity(TileEntitySteamFurnace.class, "steamFurnace");
        Steamcraft.registerTileEntity(TileEntityPump.class, "pump");
        Steamcraft.registerTileEntity(TileEntityThumper.class, "thumper");
        Steamcraft.registerTileEntity(TileEntitySmasher.class, "smasher");
        Steamcraft.registerTileEntity(TileEntityDummyBlock.class, "dummy");
        Steamcraft.registerTileEntity(TileEntityFlashBoiler.class, "flashBoiler");
        Steamcraft.registerTileEntity(TileEntityFan.class, "fan");
        Steamcraft.registerTileEntity(TileEntityVacuum.class, "vacuum");
        Steamcraft.registerTileEntity(TileEntityFluidSteamConverter.class, "fluidSteamConverter");
        Steamcraft.registerTileEntity(TileEntityWhistle.class, "whistle");
        Steamcraft.registerTileEntity(TileEntityChargingPad.class, "chargingPad");
        Steamcraft.registerTileEntity(TileEntityCustomCraftingTable.class, "customCraftingTable");
        Steamcraft.registerTileEntity(TileEntityCustomFurnace.class, "customFurnace");
        CrossMod.preInit(event);
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new SteamcraftGuiHandler());
        MinecraftForge.EVENT_BUS.register((Object)new SteamcraftEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PhobicCoatingHandler());
        FMLCommonHandler.instance().bus().register((Object)new SteamcraftTickHandler());
        FMLCommonHandler.instance().bus().register((Object)new PhobicCoatingHandler());
        if (event.getSide() == Side.CLIENT) {
            FMLCommonHandler.instance().bus().register((Object)new ExosuitModelCache());
        }
        tubeRenderID = RenderingRegistry.getNextAvailableRenderId();
        heaterRenderID = RenderingRegistry.getNextAvailableRenderId();
        chargerRenderID = RenderingRegistry.getNextAvailableRenderId();
        genocideRenderID = RenderingRegistry.getNextAvailableRenderId();
        gaugeRenderID = RenderingRegistry.getNextAvailableRenderId();
        ruptureDiscRenderID = RenderingRegistry.getNextAvailableRenderId();
        whistleRenderID = RenderingRegistry.getNextAvailableRenderId();
        boilerRenderID = RenderingRegistry.getNextAvailableRenderId();
        customCraftingTableRenderID = RenderingRegistry.getNextAvailableRenderId();
        furnaceRenderID = RenderingRegistry.getNextAvailableRenderId();
        proxy.registerRenderers();
        proxy.registerHotkeys();
        SteamcraftRecipes.registerRecipes();
        CrossMod.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        String[] ores;
        SteamcraftRecipes.registerCasting();
        if (Config.enablePipe) {
            MinecraftForge.EVENT_BUS.register((Object)SteamcraftBlocks.pipe);
        }
        ItemSmashedOre iso = (ItemSmashedOre)SteamcraftItems.smashedOre;
        iso.registerDusts();
        iso.addSmelting();
        iso.registerDusts();
        SteamcraftItems.reregisterPlates();
        SteamcraftRecipes.registerDustLiquids();
        CrossMod.postInit(event);
        SteamcraftBook.registerBookResearch();
        long start = System.currentTimeMillis();
        for (String s : ores = OreDictionary.getOreNames()) {
            ArrayList stacks = OreDictionary.getOres((String)s);
            for (ItemStack stack : stacks) {
                OreDictHelper.initializeOreDicts(s, stack);
            }
        }
        long end = System.currentTimeMillis();
        int time = (int)(end - start);
        FMLLog.info((String)"Finished initializing Flaxbeard's Steam Power OreDictHelper in %s ms", (Object[])new Object[]{time});
        DrillHeadMaterial.registerDefaults();
        SteamcraftRecipes.registerSteamToolUpgrades();
        SteamcraftBook.registerSteamTools();
    }

    static {
        log = SPLog.getInstance().setLogLevel(0);
        PLAYER_PROPERTY_ID = "FSPPlayerProperties";
        VILLAGER_PROPERTY_ID = "FSPVillagerProperties";
        MERCHANT_PROPERTY_ID = "FSPMerchantProperties";
    }

    private class SCTab
    extends CreativeTabs {
        boolean isToolTab;

        public SCTab(int par1, String par2Str, boolean toolTab) {
            super(par1, par2Str);
            this.isToolTab = toolTab;
        }

        @SideOnly(value=Side.CLIENT)
        public Item func_78016_d() {
            if (this.isToolTab) {
                return SteamcraftItems.pick("Brass");
            }
            return SteamcraftItems.book;
        }

        public boolean hasSearchBar() {
            return !this.isToolTab;
        }
    }
}

