/*
 * Decompiled with CFR 0.152.
 */
package techguns.worldgen.structures;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import techguns.TGBlocks;
import techguns.util.BlockUtils;
import techguns.util.MBlock;
import techguns.worldgen.structures.Structure;

public class Tent
extends Structure {
    int type;
    MBlock roofBlock = new MBlock(TGBlocks.camoNetRoof, 0);
    MBlock wallBlock = new MBlock((Block)TGBlocks.camoNetPane, 0);
    MBlock groundBlock = new MBlock(Blocks.field_150351_n, 0);

    public Tent(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, int type) {
        super(minX, minY, minZ, maxX, maxY, maxZ);
        this.type = type;
    }

    @Override
    public void setBlocks(World world, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ, int direction, BlockUtils.BiomeColorType colorType) {
        int camoMeta;
        if (this.type == 0) {
            ++posX;
            ++posZ;
            sizeX -= 2;
            sizeZ -= 2;
        }
        switch (colorType) {
            case DESERT: {
                camoMeta = 2;
                break;
            }
            case SNOW: {
                camoMeta = 1;
                break;
            }
            default: {
                camoMeta = 0;
            }
        }
        for (int i = 0; i < sizeX; ++i) {
            for (int j = 0; j < sizeZ; ++j) {
                for (int k = 0; k < sizeY; ++k) {
                    if (k == 0) {
                        world.func_147465_d(posX + i, posY + k, posZ + j, this.groundBlock.block, this.groundBlock.meta, 2);
                        continue;
                    }
                    if (k < sizeY - 1) {
                        if (j != 0 && j != sizeZ - 1 && i != 0 && i != sizeX - 1) continue;
                        world.func_147465_d(posX + i, posY + k, posZ + j, this.wallBlock.block, camoMeta, 2);
                        continue;
                    }
                    world.func_147465_d(posX + i, posY + k, posZ + j, this.roofBlock.block, camoMeta, 2);
                }
            }
        }
        if (this.type == 0 || this.type == 1) {
            switch (direction) {
                case 0: {
                    world.func_147449_b(posX, posY + 1, posZ + sizeZ / 2, Blocks.field_150350_a);
                    world.func_147449_b(posX, posY + 2, posZ + sizeZ / 2, Blocks.field_150350_a);
                    if (this.type != 0) break;
                    world.func_147465_d(posX - 1, posY, posZ + sizeZ / 2, this.groundBlock.block, this.groundBlock.meta, 2);
                    break;
                }
                case 1: {
                    world.func_147449_b(posX + sizeX / 2, posY + 1, posZ, Blocks.field_150350_a);
                    world.func_147449_b(posX + sizeX / 2, posY + 2, posZ, Blocks.field_150350_a);
                    if (this.type != 0) break;
                    world.func_147465_d(posX + sizeX / 2, posY, posZ - 1, this.groundBlock.block, this.groundBlock.meta, 2);
                    break;
                }
                case 2: {
                    world.func_147449_b(posX + sizeX - 1, posY + 1, posZ + sizeZ / 2, Blocks.field_150350_a);
                    world.func_147449_b(posX + sizeX - 1, posY + 2, posZ + sizeZ / 2, Blocks.field_150350_a);
                    if (this.type != 0) break;
                    world.func_147465_d(posX + sizeX, posY, posZ + sizeZ / 2, this.groundBlock.block, this.groundBlock.meta, 2);
                    break;
                }
                case 3: {
                    world.func_147449_b(posX + sizeX / 2, posY + 1, posZ + sizeZ - 1, Blocks.field_150350_a);
                    world.func_147449_b(posX + sizeX / 2, posY + 2, posZ + sizeZ - 1, Blocks.field_150350_a);
                    if (this.type != 0) break;
                    world.func_147465_d(posX + sizeX / 2, posY, posZ + sizeZ, this.groundBlock.block, this.groundBlock.meta, 2);
                }
            }
        }
        if (this.type == 2) {
            for (int y = 1; y < sizeY - 1; ++y) {
                if (direction == 0 || direction == 2) {
                    for (int z = 1; z < sizeZ - 1; ++z) {
                        if (z % 3 == 0) continue;
                        int x = direction == 0 ? 0 : sizeX - 1;
                        world.func_147468_f(posX + x, posY + y, posZ + z);
                    }
                    continue;
                }
                for (int x = 1; x < sizeX - 1; ++x) {
                    if (x % 3 == 1) continue;
                    int z = direction == 1 ? 0 : sizeZ - 1;
                    world.func_147468_f(posX + x, posY + y, posZ + z);
                }
            }
        }
    }
}

