/*
 * Decompiled with CFR 0.152.
 */
package techguns.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import techguns.Techguns;
import techguns.damagesystem.DamageSystem;
import techguns.damagesystem.TGDamageSource;
import techguns.util.EntityDeathUtils;

public class ProjectileExplosion {
    public Explosion explosion;
    public int entityDamage;
    public float dmgRadius1;
    public float dmgRadius2;
    public boolean isFlaming;
    public TGDamageSource damageSource = null;
    public String explosionSound = "random.explode";
    private int field_77289_h = 16;
    private Random explosionRNG = new Random();
    private World worldObj;
    public double explosionX;
    public double explosionY;
    public double explosionZ;
    public Entity exploder;
    public float explosionSize;
    public List affectedBlockPositions = new ArrayList();
    private Map hashmap = new HashMap();

    public ProjectileExplosion(World worldObj, double explosionX, double explosionY, double explosionZ, Entity exploder, float explosionSize, int entityDamage, float dmgRadius1, float dmgRadius2) {
        this.explosion = new Explosion(worldObj, exploder, explosionX, explosionY, explosionZ, explosionSize);
        this.entityDamage = entityDamage;
        this.dmgRadius1 = dmgRadius1;
        this.dmgRadius2 = dmgRadius2;
        this.worldObj = worldObj;
        this.explosionX = explosionX;
        this.explosionY = explosionY;
        this.explosionZ = explosionZ;
        this.explosionSize = explosionSize;
    }

    public void doExplosion(boolean blockDamage, EntityLivingBase attacker) {
        this.doExplosionA(blockDamage, attacker);
        this.doExplosionB(blockDamage);
    }

    public ProjectileExplosion setDamageSource(TGDamageSource dmgSrc) {
        this.damageSource = dmgSrc;
        return this;
    }

    public ProjectileExplosion setExplosionSound(String soundName) {
        this.explosionSound = soundName;
        return this;
    }

    public void doExplosionA(boolean blockDamage, EntityLivingBase attacker) {
        double d7;
        double d6;
        double d5;
        int k;
        int j;
        int i;
        float f = this.explosionSize;
        HashSet<ChunkPosition> hashset = new HashSet<ChunkPosition>();
        for (i = 0; i < this.field_77289_h; ++i) {
            for (j = 0; j < this.field_77289_h; ++j) {
                for (k = 0; k < this.field_77289_h; ++k) {
                    if (i != 0 && i != this.field_77289_h - 1 && j != 0 && j != this.field_77289_h - 1 && k != 0 && k != this.field_77289_h - 1) continue;
                    double d0 = (float)i / ((float)this.field_77289_h - 1.0f) * 2.0f - 1.0f;
                    double d1 = (float)j / ((float)this.field_77289_h - 1.0f) * 2.0f - 1.0f;
                    double d2 = (float)k / ((float)this.field_77289_h - 1.0f) * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    d5 = this.explosionX;
                    d6 = this.explosionY;
                    d7 = this.explosionZ;
                    float f2 = 0.3f;
                    for (float f1 = this.explosionSize * (0.7f + this.worldObj.field_73012_v.nextFloat() * 0.6f); f1 > 0.0f; f1 -= f2 * 0.75f) {
                        int l1;
                        int k1;
                        int j1 = MathHelper.func_76128_c((double)d5);
                        Block block = this.worldObj.func_147439_a(j1, k1 = MathHelper.func_76128_c((double)d6), l1 = MathHelper.func_76128_c((double)d7));
                        if (block.func_149688_o() != Material.field_151579_a) {
                            float f3 = this.exploder != null ? this.exploder.func_145772_a(this.explosion, this.worldObj, j1, k1, l1, block) : block.getExplosionResistance(this.exploder, this.worldObj, j1, k1, l1, this.explosionX, this.explosionY, this.explosionZ);
                            f1 -= (f3 + 0.3f) * f2;
                        }
                        if (f1 > 0.0f && (this.exploder == null || this.exploder.func_145774_a(this.explosion, this.worldObj, j1, k1, l1, block, f1))) {
                            hashset.add(new ChunkPosition(j1, k1, l1));
                        }
                        d5 += d0 * (double)f2;
                        d6 += d1 * (double)f2;
                        d7 += d2 * (double)f2;
                    }
                }
            }
        }
        this.affectedBlockPositions.addAll(hashset);
        this.explosionSize *= 2.0f;
        i = MathHelper.func_76128_c((double)(this.explosionX - (double)this.dmgRadius2 - 1.0));
        j = MathHelper.func_76128_c((double)(this.explosionX + (double)this.dmgRadius2 + 1.0));
        k = MathHelper.func_76128_c((double)(this.explosionY - (double)this.dmgRadius2 - 1.0));
        int i2 = MathHelper.func_76128_c((double)(this.explosionY + (double)this.dmgRadius2 + 1.0));
        int l = MathHelper.func_76128_c((double)(this.explosionZ - (double)this.dmgRadius2 - 1.0));
        int j2 = MathHelper.func_76128_c((double)(this.explosionZ + (double)this.dmgRadius2 + 1.0));
        List list = this.worldObj.func_72839_b(this.exploder, AxisAlignedBB.func_72330_a((double)i, (double)k, (double)l, (double)j, (double)i2, (double)j2));
        Vec3 vec3 = Vec3.func_72443_a((double)this.explosionX, (double)this.explosionY, (double)this.explosionZ);
        for (int i1 = 0; i1 < list.size(); ++i1) {
            double d9;
            Entity entity = (Entity)list.get(i1);
            double distance = entity.func_70011_f(this.explosionX, this.explosionY, this.explosionZ);
            double d4 = distance / (double)this.explosionSize;
            if (!(distance <= (double)this.dmgRadius2) || (d9 = (double)MathHelper.func_76133_a((double)((d5 = entity.field_70165_t - this.explosionX) * d5 + (d6 = entity.field_70163_u + (double)entity.func_70047_e() - this.explosionY) * d6 + (d7 = entity.field_70161_v - this.explosionZ) * d7))) == 0.0) continue;
            d5 /= d9;
            d6 /= d9;
            d7 /= d9;
            float density = this.worldObj.func_72842_a(vec3, entity.field_70121_D);
            double dmg = (double)this.entityDamage * Math.min(1.0, 1.0 - (distance - (double)this.dmgRadius1) / (double)(this.dmgRadius2 - this.dmgRadius1));
            double d11 = (1.0 - d4) * (double)density;
            float damage = (float)dmg;
            if (attacker != null && attacker instanceof EntityLivingBase && entity instanceof EntityLivingBase) {
                damage *= DamageSystem.getDamageFactor(attacker, (EntityLivingBase)entity);
            }
            if (this.damageSource == null) {
                TGDamageSource dmgsrc = TGDamageSource.causeExplosionDamage(this.exploder, null, EntityDeathUtils.DeathType.GORE);
                dmgsrc.goreChance = 0.35f;
                entity.func_70097_a((DamageSource)dmgsrc, damage);
            } else {
                entity.func_70097_a((DamageSource)this.damageSource, damage);
            }
            double d8 = EnchantmentProtection.func_92092_a((Entity)entity, (double)d11);
            entity.field_70159_w += d5 * d8;
            entity.field_70181_x += d6 * d8;
            entity.field_70179_y += d7 * d8;
            if (!(entity instanceof EntityPlayer)) continue;
            this.hashmap.put((EntityPlayer)entity, Vec3.func_72443_a((double)(d5 * d11), (double)(d6 * d11), (double)(d7 * d11)));
        }
        this.explosionSize = f;
    }

    public void doExplosionB(boolean blockDamage) {
        Block block;
        int k;
        int j;
        int i;
        this.worldObj.func_72908_a(this.explosionX, this.explosionY, this.explosionZ, this.explosionSound, 4.0f, (1.0f + (this.worldObj.field_73012_v.nextFloat() - this.worldObj.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        for (ChunkPosition chunkposition : this.affectedBlockPositions) {
            i = chunkposition.field_151329_a;
            j = chunkposition.field_151327_b;
            k = chunkposition.field_151328_c;
            block = this.worldObj.func_147439_a(i, j, k);
            double d0 = (float)i + this.worldObj.field_73012_v.nextFloat();
            double d1 = (float)j + this.worldObj.field_73012_v.nextFloat();
            double d2 = (float)k + this.worldObj.field_73012_v.nextFloat();
            double d3 = d0 - this.explosionX;
            double d4 = d1 - this.explosionY;
            double d5 = d2 - this.explosionZ;
            double d6 = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
            d3 /= d6;
            d4 /= d6;
            d5 /= d6;
            double d7 = 0.5 / (d6 / (double)this.explosionSize + 0.1);
            d3 *= (d7 *= (double)(this.worldObj.field_73012_v.nextFloat() * this.worldObj.field_73012_v.nextFloat() + 0.3f));
            d4 *= d7;
            d5 *= d7;
            if (!blockDamage || block.func_149688_o() == Material.field_151579_a) continue;
            if (block.func_149659_a(this.explosion)) {
                block.func_149690_a(this.worldObj, i, j, k, this.worldObj.func_72805_g(i, j, k), 1.0f / this.explosionSize, 0);
            }
            block.onBlockExploded(this.worldObj, i, j, k, this.explosion);
        }
        if (this.isFlaming) {
            for (ChunkPosition chunkposition : this.affectedBlockPositions) {
                i = chunkposition.field_151329_a;
                j = chunkposition.field_151327_b;
                k = chunkposition.field_151328_c;
                block = this.worldObj.func_147439_a(i, j, k);
                Block block1 = this.worldObj.func_147439_a(i, j - 1, k);
                if (block.func_149688_o() != Material.field_151579_a || !block1.func_149730_j() || this.explosionRNG.nextInt(3) != 0) continue;
                this.worldObj.func_147449_b(i, j, k, (Block)Blocks.field_150480_ab);
            }
        }
    }

    private void createExplosionEffect() {
        if ((double)this.dmgRadius2 < 1.5) {
            Techguns.proxy.spawnParticle("Explosion", this.worldObj, this.explosionX, this.explosionY, this.explosionZ, 0.0, 0.025f, 0.0);
            Techguns.proxy.spawnParticle("LargeSmoke", this.worldObj, this.explosionX, this.explosionY, this.explosionZ, 0.0, 0.045f, 0.0);
        } else {
            int i;
            int count = Math.round(this.dmgRadius2 * 3.0f);
            for (int i2 = 0; i2 < count; ++i2) {
                Techguns.proxy.spawnParticle("Explosion", this.worldObj, this.explosionX + (double)((1.0f - this.explosionRNG.nextFloat() * 2.0f) * this.dmgRadius2 * 0.33f), this.explosionY + (double)((1.0f - this.explosionRNG.nextFloat() * 2.0f) * this.dmgRadius2 * 0.33f), this.explosionZ + (double)((1.0f - this.explosionRNG.nextFloat() * 2.0f) * this.dmgRadius2 * 0.33f), 0.05f * (1.0f - this.explosionRNG.nextFloat() * 2.0f), 0.05f * this.explosionRNG.nextFloat(), 0.05f * (1.0f - this.explosionRNG.nextFloat() * 2.0f));
            }
            count = Math.round(this.dmgRadius2 * 8.0f);
            float r = this.dmgRadius2 * 0.15f;
            float angle = (float)Math.PI * 2 / (float)count;
            float v = 0.21f;
            for (i = 0; i < count; ++i) {
                float x = (float)Math.cos(angle * (float)i);
                float z = (float)Math.sin(angle * (float)i);
                float rand = 0.5f + this.explosionRNG.nextFloat() * 0.5f;
                Techguns.proxy.spawnParticle("Fireblast", this.worldObj, this.explosionX + (double)x, this.explosionY, this.explosionZ + (double)z, x * v * rand, 0.0, z * v * rand);
            }
            count = Math.round(this.dmgRadius2 * 2.0f);
            for (i = 0; i < count; ++i) {
                Techguns.proxy.spawnParticle("LargeSmoke", this.worldObj, this.explosionX + (double)((1.0f - this.explosionRNG.nextFloat() * 2.0f) * this.dmgRadius2 * 0.22f), this.explosionY + (double)(this.explosionRNG.nextFloat() * this.dmgRadius2 * 0.16f), this.explosionZ + (double)((1.0f - this.explosionRNG.nextFloat() * 2.0f) * this.dmgRadius2 * 0.22f), 0.025f * (1.0f - this.explosionRNG.nextFloat() * 2.0f), 0.01f * this.explosionRNG.nextFloat(), 0.025f * (1.0f - this.explosionRNG.nextFloat() * 2.0f));
            }
        }
    }

    public Map func_77277_b() {
        return this.hashmap;
    }
}

