/*
 * Decompiled with CFR 0.152.
 */
package techguns.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import cpw.mods.fml.common.Optional;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import techguns.TGItems;
import techguns.gui.GuiAmmoPress;
import techguns.inventory.AmmoPressBuildPlans;
import techguns.util.TextUtil;

@Optional.Interface(iface="codechicken.nei.api.API", modid="NotEnoughItems")
public class TechgunsAmmoPressNEIRecipeHandler
extends TemplateRecipeHandler {
    private static final String ID = "Techguns:AmmoPress";
    public static final int ICON_OFFSET_X = -5;
    public static final int ICON_OFFSET_Y = -11;

    @Optional.Method(modid="NotEnoughItems")
    public String getRecipeName() {
        return TextUtil.trans("techguns.container.ammopress");
    }

    @Optional.Method(modid="NotEnoughItems")
    public String getGuiTexture() {
        return GuiAmmoPress.texture.toString();
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiAmmoPress.class;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(-5 + 123 - 1, -11 + 36 - 1, 12, 23), TechgunsAmmoPressNEIRecipeHandler.getIDString(), new Object[0]));
    }

    public static String getIDString() {
        return ID;
    }

    public void drawExtras(int recipe) {
        int color = -1;
        this.drawProgressBar(3, 6, 251, 1, 4, 48, 100, 7);
        this.drawProgressBar(118, 25, 180, 0, 10, 21, 100, 1);
        int power = AmmoPressBuildPlans.getTotalPower(recipe);
        int time = 100;
        GuiDraw.gui.func_73732_a(GuiDraw.fontRenderer, power + " RF", 52, 14, color);
        GuiDraw.gui.func_73732_a(GuiDraw.fontRenderer, time + " ticks", 52, 24, color);
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(ID)) {
            this.loadAllRecipes();
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadAllRecipes() {
        for (ItemStack result : AmmoPressBuildPlans.getPossibleResults()) {
            this.arecipes.add(new CachedAmmoPressRecipe(new AmmoPressRecipe(AmmoPressBuildPlans.metal1, AmmoPressBuildPlans.metal2, AmmoPressBuildPlans.powder, result)));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        block4: {
            ArrayList<ItemStack> ingr;
            block5: {
                block3: {
                    ingr = new ArrayList<ItemStack>();
                    if (!AmmoPressBuildPlans.isInList(ingredient, AmmoPressBuildPlans.metal1)) break block3;
                    for (ItemStack result : AmmoPressBuildPlans.getPossibleResults()) {
                        ingr.add(ingredient);
                        this.arecipes.add(new CachedAmmoPressRecipe(new AmmoPressRecipe(ingr, AmmoPressBuildPlans.metal2, AmmoPressBuildPlans.powder, result)));
                    }
                    break block4;
                }
                if (!AmmoPressBuildPlans.isInList(ingredient, AmmoPressBuildPlans.metal2)) break block5;
                ItemStack ingr2 = ingredient.func_77946_l();
                ingr2.field_77994_a = 2;
                for (ItemStack result : AmmoPressBuildPlans.getPossibleResults()) {
                    ingr.add(ingr2);
                    this.arecipes.add(new CachedAmmoPressRecipe(new AmmoPressRecipe(AmmoPressBuildPlans.metal1, ingr, AmmoPressBuildPlans.powder, result)));
                }
                break block4;
            }
            if (!AmmoPressBuildPlans.isInList(ingredient, AmmoPressBuildPlans.powder)) break block4;
            for (ItemStack result : AmmoPressBuildPlans.getPossibleResults()) {
                ingr.add(ingredient);
                this.arecipes.add(new CachedAmmoPressRecipe(new AmmoPressRecipe(AmmoPressBuildPlans.metal1, AmmoPressBuildPlans.metal2, ingr, result)));
            }
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (result.func_77973_b() != TGItems.sharedItem) {
            return;
        }
        int damage = result.func_77960_j();
        if (damage != TGItems.bullets9mm.func_77960_j() && damage != TGItems.shotgunShell.func_77960_j() && damage != TGItems.rifleBullets.func_77960_j() && damage != TGItems.highCalibreBullets.func_77960_j()) {
            return;
        }
        ItemStack ammo = TGItems.newStack(result, AmmoPressBuildPlans.getAmountForRecipe(result.func_77960_j()));
        this.arecipes.add(new CachedAmmoPressRecipe(new AmmoPressRecipe(AmmoPressBuildPlans.metal1, AmmoPressBuildPlans.metal2, AmmoPressBuildPlans.powder, ammo)));
    }

    public class CachedAmmoPressRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public AmmoPressRecipe recipe;

        public CachedAmmoPressRecipe(AmmoPressRecipe recipe) {
            super((TemplateRecipeHandler)TechgunsAmmoPressNEIRecipeHandler.this);
            this.recipe = recipe;
        }

        public PositionedStack getResult() {
            return this.recipe.ammo;
        }

        public ArrayList<PositionedStack> getIngredients() {
            ArrayList<PositionedStack> recipestacks = new ArrayList<PositionedStack>();
            recipestacks.add(this.recipe.metal1);
            recipestacks.add(this.recipe.metal2);
            recipestacks.add(this.recipe.gunpowder);
            return (ArrayList)this.getCycledIngredients(TechgunsAmmoPressNEIRecipeHandler.this.cycleticks / 24, recipestacks);
        }
    }

    public static class AmmoPressRecipe {
        public PositionedStack metal1;
        public PositionedStack metal2;
        public PositionedStack gunpowder;
        public PositionedStack ammo;

        public AmmoPressRecipe(List<ItemStack> metal1, List<ItemStack> metal2, List<ItemStack> gunpowder, ItemStack ammo) {
            this.metal1 = new PositionedStack(metal1, 95, 6);
            this.metal2 = new PositionedStack(metal2, 115, 6);
            this.gunpowder = new PositionedStack(gunpowder, 135, 6);
            this.ammo = new PositionedStack((Object)ammo, 115, 49);
        }
    }
}

