/*
 * Decompiled with CFR 0.152.
 */
package techguns.inventory;

import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import techguns.util.ItemUtil;

public class ItemStackOreDict {
    public String oreDictName;
    public int stackSize;
    public ItemStack item;
    public boolean strict = true;

    public ItemStackOreDict(String oreDictName, int stackSize) {
        this.oreDictName = oreDictName;
        this.stackSize = stackSize;
        this.item = null;
    }

    public ItemStackOreDict(String oreDictName) {
        this.oreDictName = oreDictName;
        this.stackSize = 1;
        this.item = null;
    }

    public ItemStackOreDict(ItemStack item, int stackSize) {
        this.stackSize = stackSize;
        this.item = item;
        this.oreDictName = null;
    }

    public ItemStackOreDict(ItemStack item) {
        if (item != null) {
            this.stackSize = item.field_77994_a;
            this.item = item;
            this.oreDictName = null;
        } else {
            this.stackSize = 0;
            this.item = null;
            this.oreDictName = null;
        }
    }

    public ItemStackOreDict setNoStrictMode() {
        this.strict = false;
        return this;
    }

    public boolean isNullStack() {
        return this.oreDictName == null && this.item == null;
    }

    public boolean isEqualWithOreDict(ItemStack other) {
        if (this.oreDictName == null) {
            return ItemUtil.isItemEqual(this.item, other, this.strict);
        }
        ArrayList<ItemStack> items = this.getItemStacks();
        for (int i = 0; i < items.size(); ++i) {
            if (!ItemUtil.isItemEqual(items.get(i), other, this.strict)) continue;
            return true;
        }
        return false;
    }

    public ArrayList<ItemStack> getItemStacks() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (this.oreDictName == null) {
            if (this.item != null) {
                list.add(new ItemStack(this.item.func_77973_b(), this.stackSize, this.item.func_77960_j()));
            }
        } else {
            list.addAll(OreDictionary.getOres((String)this.oreDictName));
            ItemUtil.setStackSizes(list, this.stackSize);
        }
        return list;
    }

    public ArrayList<ItemStack> getItemStacks(int amountOverride) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (this.oreDictName == null) {
            if (this.item != null) {
                list.add(new ItemStack(this.item.func_77973_b(), amountOverride, this.item.func_77960_j()));
            }
        } else {
            ArrayList oreDictItems = OreDictionary.getOres((String)this.oreDictName);
            for (int i = 0; i < oreDictItems.size(); ++i) {
                list.add(new ItemStack(((ItemStack)oreDictItems.get(i)).func_77973_b(), amountOverride, ((ItemStack)oreDictItems.get(i)).func_77960_j()));
            }
        }
        return list;
    }
}

