/*
 * Decompiled with CFR 0.152.
 */
package techguns.entities.projectiles;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import techguns.damagesystem.DamageSystem;
import techguns.damagesystem.TGDamageSource;
import techguns.entities.projectiles.GenericProjectile;
import techguns.entities.projectiles.LaserBeam2;
import techguns.util.EntityDeathUtils;

public class LaserProjectile
extends GenericProjectile {
    public LaserProjectile(World par1World) {
        super(par1World);
        this.speed = 5.0f;
        this.ticksToLive = 5;
        this.lifetime = 5;
    }

    public LaserProjectile(World par2World, EntityLivingBase par3Player, float damage, float speed, int TTL, float spread, int dmgDropStart, int dmgDropEnd, float dmgMin, float penetration, boolean blockdamage) {
        super(par2World, par3Player, damage, speed, TTL, spread, dmgDropStart, dmgDropEnd, dmgMin, penetration, blockdamage);
        this.speed = 5.0f;
        this.ticksToLive = 5;
        this.lifetime = 5;
        this.spawnBeamProjectile(par2World, par3Player);
    }

    private void spawnBeamProjectile(World world, EntityLivingBase player) {
        LaserBeam2 beam = new LaserBeam2(world, player, this);
        world.func_72838_d((Entity)beam);
    }

    @Override
    protected void onImpact(MovingObjectPosition par1MovingObjectPosition) {
        if (par1MovingObjectPosition.field_72308_g != null) {
            if (par1MovingObjectPosition.field_72308_g instanceof EntityLivingBase) {
                EntityLivingBase ent = (EntityLivingBase)par1MovingObjectPosition.field_72308_g;
                float dmg = DamageSystem.getDamageFactor(this.shooter, ent);
                if (dmg > 0.0f) {
                    ent.func_70097_a((DamageSource)this.getProjectileDamageSource(), this.getDamage() * dmg);
                }
            } else {
                par1MovingObjectPosition.field_72308_g.func_70097_a((DamageSource)this.getProjectileDamageSource(), this.getDamage());
            }
        }
        if (par1MovingObjectPosition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            // empty if block
        }
        this.func_70106_y();
    }

    @Override
    protected TGDamageSource getProjectileDamageSource() {
        TGDamageSource src = TGDamageSource.causeEnergyDamage(this, (Entity)this.shooter, EntityDeathUtils.DeathType.LASER);
        src.armorPenetration = this.penetration;
        src.setNoKnockback();
        src.goreChance = 0.35f;
        return src;
    }
}

