/*
 * Decompiled with CFR 0.152.
 */
package techguns.client.renderer.block;

import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;
import techguns.blocks.BlockTGLamp;
import techguns.client.renderer.block.RenderGenericBlock;
import techguns.client.renderer.block.TessellatorCubeProper;

public class RenderLamp
extends RenderGenericBlock {
    ResourceLocation texture;
    ModelBase model;
    float scale;

    public RenderLamp(ModelBase model, ResourceLocation texture, float scale) {
        this.texture = texture;
        this.model = model;
        this.scale = scale;
    }

    @Override
    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        GL11.glPushMatrix();
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
        if (metadata != 7 && metadata != 15) {
            GL11.glTranslatef((float)-0.55f, (float)-0.8f, (float)-0.45f);
        } else {
            GL11.glTranslatef((float)-1.0f, (float)-0.05f, (float)0.05f);
        }
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        this.renderLampInventory(block, metadata);
        tess.func_78381_a();
        GL11.glPopMatrix();
    }

    @Override
    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        int meta = world.func_72805_g(x, y, z);
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78380_c(block.func_149677_c(world, x, y, z));
        tess.func_78386_a(1.0f, 1.0f, 1.0f);
        this.renderLamp(world, x, y, z, block, renderer, meta);
        return true;
    }

    @Override
    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    protected void renderLampInventory(Block block, int meta) {
        TessellatorCubeProper cube = new TessellatorCubeProper(block, meta);
        Tessellator tess = Tessellator.field_78398_a;
        int width = 32;
        double px = 0.03125;
        int w1 = 16;
        int w2 = 14;
        int h1 = 2;
        int h2 = 4;
        double minW1 = (double)(32 - w1) / 2.0 * px;
        double maxW1 = (32.0 - (double)(32 - w1) / 2.0) * px;
        double minW2 = (double)(32 - w2) / 2.0 * px;
        double maxW2 = (32.0 - (double)(32 - w2) / 2.0) * px;
        double minH1 = (double)h1 * px;
        double maxH1 = (double)(32 - h1) * px;
        double minH2 = (double)(h1 + h2) * px;
        double maxH2 = (double)(32 - (h1 + h2)) * px;
        if (meta == 1 || meta == 9 || meta == 0 || meta == 8) {
            cube.drawStandardCube(tess, minW1, maxH1, minW1, maxW1, 1.0, maxW1);
            cube.drawStandardCube(tess, minW2, maxH2, minW2, maxW2, maxH1, maxW2);
        } else if (meta == 2 || meta == 10) {
            cube.drawStandardCube(tess, minW1, 0.0, minW1, maxW1, minH1, maxW1);
            cube.drawStandardCube(tess, minW2, minH1, minW2, maxW2, minH2, maxW2);
        } else if (meta == 3 || meta == 11) {
            cube.drawStandardCube(tess, minW1, minW1, maxH1, maxW1, maxW1, 1.0);
            cube.drawStandardCube(tess, minW2, minW2, maxH2, maxW2, maxW2, maxH1);
        } else if (meta == 4 || meta == 12) {
            cube.drawStandardCube(tess, minW1, minW1, 0.0, maxW1, maxW1, minH1);
            cube.drawStandardCube(tess, minW2, minW2, minH1, maxW2, maxW2, minH2);
        } else if (meta == 5 || meta == 13) {
            cube.drawStandardCube(tess, maxH1, minW1, minW1, 1.0, maxW1, maxW1);
            cube.drawStandardCube(tess, maxH2, minW2, minW2, maxH1, maxW2, maxW2);
        } else if (meta == 6 || meta == 14) {
            cube.drawStandardCube(tess, 0.0, minW1, minW1, minH1, maxW1, maxW1);
            cube.drawStandardCube(tess, minH1, minW2, minW2, minH2, maxW2, maxW2);
        } else if (meta == 7 || meta == 15) {
            cube.drawStandardCube(tess, 0.375, 0.125, 0.375, 0.625, 0.875, 0.625);
            cube.drawStandardCube(tess, 0.28125, 0.1875, 0.28125, 0.71875, 0.25, 0.71875);
            cube.drawStandardCube(tess, 0.28125, 0.75, 0.28125, 0.71875, 0.8125, 0.71875);
            cube.drawStandardCube(tess, 0.3125, 0.25, 0.3125, 0.6875, 0.75, 0.6875);
        }
    }

    protected void renderLamp(IBlockAccess world, int x, int y, int z, Block block, RenderBlocks renderer, int meta) {
        int width = 32;
        double px = 0.03125;
        int w1 = 16;
        int w2 = 14;
        int h1 = 2;
        int h2 = 4;
        double minW1 = (double)(32 - w1) / 2.0 * px;
        double maxW1 = (32.0 - (double)(32 - w1) / 2.0) * px;
        double minW2 = (double)(32 - w2) / 2.0 * px;
        double maxW2 = (32.0 - (double)(32 - w2) / 2.0) * px;
        double minH1 = (double)h1 * px;
        double maxH1 = (double)(32 - h1) * px;
        double minH2 = (double)(h1 + h2) * px;
        double maxH2 = (double)(32 - (h1 + h2)) * px;
        double d = 0.001;
        minW2 += d;
        maxW2 -= d;
        minH2 -= d;
        maxH2 += d;
        minH1 -= d;
        maxH1 += d;
        int dir = meta % 8;
        TessellatorCubeProper cube = new TessellatorCubeProper(block, meta);
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78372_c((float)x, (float)y, (float)z);
        if (meta == 1 || meta == 9) {
            cube.drawStandardCube(tess, minW1, maxH1, minW1, maxW1, 1.0, maxW1);
            cube.drawStandardCube(tess, minW2, maxH2, minW2, maxW2, maxH1, maxW2);
        } else if (meta == 2 || meta == 10) {
            cube.drawStandardCube(tess, minW1, 0.0, minW1, maxW1, minH1, maxW1);
            cube.drawStandardCube(tess, minW2, minH1, minW2, maxW2, minH2, maxW2);
        } else if (meta == 3 || meta == 11) {
            cube.drawStandardCube(tess, minW1, minW1, maxH1, maxW1, maxW1, 1.0);
            cube.drawStandardCube(tess, minW2, minW2, maxH2, maxW2, maxW2, maxH1);
        } else if (meta == 4 || meta == 12) {
            cube.drawStandardCube(tess, minW1, minW1, 0.0, maxW1, maxW1, minH1);
            cube.drawStandardCube(tess, minW2, minW2, minH1, maxW2, maxW2, minH2);
        } else if (meta == 5 || meta == 13) {
            cube.drawStandardCube(tess, maxH1, minW1, minW1, 1.0, maxW1, maxW1);
            cube.drawStandardCube(tess, maxH2, minW2, minW2, maxH1, maxW2, maxW2);
        } else if (meta == 6 || meta == 14) {
            cube.drawStandardCube(tess, 0.0, minW1, minW1, minH1, maxW1, maxW1);
            cube.drawStandardCube(tess, minH1, minW2, minW2, minH2, maxW2, maxW2);
        } else if (meta == 7 || meta == 15) {
            cube.drawStandardCube(tess, 0.375, 0.125, 0.375, 0.625, 0.875, 0.625);
            cube.drawStandardCube(tess, 0.28125, 0.1875, 0.28125, 0.71875, 0.25 - d, 0.71875);
            cube.drawStandardCube(tess, 0.28125, 0.75 + d, 0.28125, 0.71875, 0.8125, 0.71875);
            cube.drawStandardCube(tess, 0.3125, 0.25 - d, 0.3125, 0.6875, 0.75 + d, 0.6875);
            BlockTGLamp lamp = (BlockTGLamp)block;
            boolean top = lamp.canConnectTo(world, x, y + 1, z);
            boolean bottom = lamp.canConnectTo(world, x, y - 1, z);
            boolean north = lamp.canConnectTo(world, x, y, z - 1);
            boolean east = lamp.canConnectTo(world, x + 1, y, z);
            boolean south = lamp.canConnectTo(world, x, y, z + 1);
            boolean west = lamp.canConnectTo(world, x - 1, y, z);
            if (top) {
                cube.drawStandardCube(tess, 0.375, 0.875, 0.375, 0.625, 1.0, 0.625);
            }
            if (bottom) {
                cube.drawStandardCube(tess, 0.375, 0.0, 0.375, 0.625, 0.125, 0.625);
            }
            if (north) {
                cube.drawStandardCube(tess, 0.375, 0.1875, 0.0, 0.625, 0.25 - d, 0.28125);
                cube.drawStandardCube(tess, 0.375, 0.75 + d, 0.0, 0.625, 0.8125, 0.28125);
            }
            if (east) {
                cube.drawStandardCube(tess, 0.71875, 0.1875, 0.375, 1.0, 0.25 - d, 0.625);
                cube.drawStandardCube(tess, 0.71875, 0.75 + d, 0.375, 1.0, 0.8125, 0.625);
            }
            if (south) {
                cube.drawStandardCube(tess, 0.375, 0.1875, 0.71875, 0.625, 0.25 - d, 1.0);
                cube.drawStandardCube(tess, 0.375, 0.75 + d, 0.71875, 0.625, 0.8125, 1.0);
            }
            if (west) {
                cube.drawStandardCube(tess, 0.0, 0.1875, 0.375, 0.28125, 0.25 - d, 0.625);
                cube.drawStandardCube(tess, 0.0, 0.75 + d, 0.375, 0.28125, 0.8125, 0.625);
            }
        }
        tess.func_78372_c((float)(-x), (float)(-y), (float)(-z));
    }
}

