/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.TileEntities.PowerGen;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Interfaces.TileEntity.BreakAction;
import Reika.DragonAPI.Interfaces.TileEntity.ToggleTile;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.DragonAPI.Libraries.ReikaEntityHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.ReactorCraft.Auxiliary.MultiBlockTile;
import Reika.ReactorCraft.Base.TileEntityReactorBase;
import Reika.ReactorCraft.ReactorCraft;
import Reika.ReactorCraft.Registry.ReactorAchievements;
import Reika.ReactorCraft.Registry.ReactorBlocks;
import Reika.ReactorCraft.Registry.ReactorSounds;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.RotaryCraft.API.Interfaces.Screwdriverable;
import Reika.RotaryCraft.API.Power.PowerGenerator;
import Reika.RotaryCraft.API.Power.ShaftMerger;
import Reika.RotaryCraft.API.Power.ShaftPowerReceiver;
import Reika.RotaryCraft.Auxiliary.Interfaces.PipeConnector;
import Reika.RotaryCraft.Auxiliary.Interfaces.PowerSourceTracker;
import Reika.RotaryCraft.Auxiliary.PowerSourceList;
import Reika.RotaryCraft.Auxiliary.ShaftPowerEmitter;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Registry.DifficultyEffects;
import Reika.RotaryCraft.Registry.MachineRegistry;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityTurbineCore
extends TileEntityReactorBase
implements ShaftPowerEmitter,
Screwdriverable,
IFluidHandler,
PipeConnector,
MultiBlockTile,
BreakAction,
ToggleTile,
PowerSourceTracker {
    protected int steam;
    protected int omega;
    private int iotick;
    private int readx;
    private int ready;
    private int readz;
    private int writex;
    private int writey;
    private int writez;
    public static final int GEN_OMEGA = 65536;
    public static final int TORQUE_CAP = 32768;
    private int forcedlube = 0;
    private boolean ammonia;
    protected final HybridTank tank = new HybridTank("turbine", this.getLubricantCapacity());
    private Interference inter = null;
    private BlockArray contact = new BlockArray();
    private int damage;
    private boolean enabled = true;
    protected boolean hasMultiBlock = !this.needsMultiblock();
    private boolean readyForMultiBlock = false;
    private StepTimer soundTimer = new StepTimer(41);
    private int stage;
    private final StepTimer lubeTimer = new StepTimer((int)(20.0f / DifficultyEffects.LUBEUSAGE.getChance()));

    public final void markForMulti() {
        this.readyForMultiBlock = true;
    }

    protected int getLubricantCapacity() {
        return 64000;
    }

    @Override
    public void setHasMultiBlock(boolean has) {
        this.hasMultiBlock = has ? this.readyForMultiBlock : has;
        this.readyForMultiBlock = false;
    }

    @Override
    public final boolean hasMultiBlock() {
        return this.hasMultiBlock;
    }

    public int getDamage() {
        return this.damage;
    }

    public boolean needsMultiblock() {
        return false;
    }

    @Override
    public int getIndex() {
        return ReactorTiles.TURBINECORE.ordinal();
    }

    public final void updateEntity(World world, int x, int y, int z, int meta) {
        TileEntity tg;
        this.getIOSides(world, x, y, z, meta);
        if (!this.hasMultiBlock) {
            this.omega = 0;
            this.phi = 0.0f;
            this.steam = 0;
            return;
        }
        if (ReactorCraft.logger.shouldDebug()) {
            if (world.field_72995_K) {
                ReactorCraft.logger.log((Object)("Clientside " + this + " has " + this.steam + " steam, spinning @ " + this.omega + " rad/s. Phi=" + this.phi));
            } else {
                ReactorCraft.logger.log((Object)("Serverside " + this + " has " + this.steam + " steam, spinning @ " + this.omega + " rad/s."));
            }
        }
        this.thermalTicker.update();
        this.soundTimer.update();
        this.stage = this.calcStage();
        this.intakeLubricant(world, x, y, z, meta);
        this.distributeLubricant(world, x, y, z, meta);
        this.readSurroundings(world, x, y, z, meta);
        this.followHead(world, x, y, z, meta);
        if (this.canCollideCheck()) {
            this.enviroTest(world, x, y, z, meta);
        }
        this.readyForMultiBlock = false;
        if (this.steam > 0) {
            this.dumpSteam(world, x, y, z, meta);
            if (this.thermalTicker.checkCap()) {
                this.steam -= this.getConsumedSteam();
            }
        }
        if (this.omega == 0) {
            this.phi = 0.0f;
            this.steam = 0;
        } else {
            if (this.soundTimer.checkCap() && this.stage == 0) {
                ReactorSounds.TURBINE.playSoundAtBlock(world, x, y, z, 2.0f, 1.0f);
            }
            this.lubeTimer.update();
            if (!this.tank.isEmpty() && !world.field_72995_K && this.lubeTimer.checkCap()) {
                this.tank.removeLiquid(this.getConsumedLubricant());
            }
        }
        this.steam = (int)((float)this.steam * this.getDamageEfficiency());
        if (this.getGenPower() >= 1000000000L) {
            ReactorAchievements.GIGATURBINE.triggerAchievement(this.getPlacer());
        }
        if ((tg = this.getTileEntity(this.writex, this.writey, this.writez)) instanceof ShaftPowerReceiver) {
            ShaftPowerReceiver rec = (ShaftPowerReceiver)tg;
            rec.setOmega(this.getOmega());
            rec.setTorque(this.getTorque());
            rec.setPower(this.getPower());
        }
    }

    protected boolean checkForMultiblock(World world, int x, int y, int z, int meta) {
        return false;
    }

    protected int getConsumedLubricant() {
        return 20;
    }

    private void distributeLubricant(World world, int x, int y, int z, int meta) {
        ForgeDirection dir = this.getSteamMovement().getOpposite();
        int dx = x + dir.offsetX;
        int dy = y + dir.offsetY;
        int dz = z + dir.offsetZ;
        ReactorTiles r = ReactorTiles.getTE((IBlockAccess)world, dx, dy, dz);
        if (r == this.getMachine()) {
            TileEntityTurbineCore te = (TileEntityTurbineCore)world.func_147438_o(dx, dy, dz);
            int max = Math.min(this.tank.getRemainingSpace(), 1000);
            int dl = te.tank.getLevel() - this.tank.getLevel();
            if (dl > 1) {
                int rem = Math.min(dl / 2, max);
                this.tank.addLiquid(rem, FluidRegistry.getFluid((String)"rc lubricant"));
                te.tank.removeLiquid(rem);
            }
        }
    }

    protected void intakeLubricant(World world, int x, int y, int z, int meta) {
    }

    protected void dumpSteam(World world, int x, int y, int z, int meta) {
    }

    protected int getMaxStage() {
        return 4;
    }

    protected final int getConsumedSteam() {
        return this.steam / 32 + 1;
    }

    public ForgeDirection getSteamMovement() {
        switch (this.func_145832_p()) {
            case 0: {
                return ForgeDirection.WEST;
            }
            case 1: {
                return ForgeDirection.EAST;
            }
            case 2: {
                return ForgeDirection.NORTH;
            }
            case 3: {
                return ForgeDirection.SOUTH;
            }
        }
        return ForgeDirection.DOWN;
    }

    private void getIOSides(World world, int x, int y, int z, int meta) {
        switch (meta) {
            case 0: {
                this.readx = x + 1;
                this.ready = y;
                this.readz = z;
                this.writex = x - 1;
                this.writey = y;
                this.writez = z;
                break;
            }
            case 1: {
                this.readx = x - 1;
                this.ready = y;
                this.readz = z;
                this.writex = x + 1;
                this.writey = y;
                this.writez = z;
                break;
            }
            case 2: {
                this.readx = x;
                this.ready = y;
                this.readz = z + 1;
                this.writex = x;
                this.writey = y;
                this.writez = z - 1;
                break;
            }
            case 3: {
                this.readx = x;
                this.ready = y;
                this.readz = z - 1;
                this.writex = x;
                this.writey = y;
                this.writez = z + 1;
                break;
            }
            case 4: {
                this.readx = x;
                this.ready = y - 1;
                this.readz = z;
                this.writex = x;
                this.writey = y + 1;
                this.writez = z;
                break;
            }
            case 5: {
                this.readx = x;
                this.ready = y + 1;
                this.readz = z;
                this.writex = x;
                this.writey = y - 1;
                this.writez = z;
            }
        }
    }

    public int getMaxTorque() {
        return 32768;
    }

    public int getMaxSpeed() {
        return 65536;
    }

    private void updateSpeed(boolean up) {
        if (!DragonAPICore.debugtest && this.tank.isEmpty()) {
            up = false;
        }
        if (up) {
            int max = this.getMaxSpeed();
            if (this.omega < max) {
                this.omega = (int)((double)this.omega + 4.0 * ReikaMathLibrary.logbase((long)(max + 1), (int)2));
                if (this.omega > max) {
                    this.omega = max;
                }
            }
        } else if (this.omega > 0) {
            this.omega -= this.omega / 256 + 1;
        }
    }

    public final boolean isAtEndOFLine() {
        if (ReactorTiles.getTE((IBlockAccess)this.field_145850_b, this.readx, this.ready, this.readz) == this.getMachine()) {
            TileEntityTurbineCore tile = (TileEntityTurbineCore)this.field_145850_b.func_147438_o(this.readx, this.ready, this.readz);
            if (tile.writex == this.field_145851_c && tile.writey == this.field_145848_d && tile.writez == this.field_145849_e) {
                return false;
            }
        }
        return true;
    }

    private int getAccelDelay() {
        return 1 + (int)ReikaMathLibrary.logbase((long)(this.omega + 1), (int)2) / 20;
    }

    protected final int getGenTorque() {
        int torque = this.steam > 0 ? (int)((float)(this.steam * 24) * this.getTorqueFactor()) : this.omega / 16 + 1;
        int ret = this.omega > 0 ? (int)((double)torque * this.getEfficiency()) : 0;
        return Math.min(ret, this.getMaxTorque());
    }

    protected float getTorqueFactor() {
        return 1.0f;
    }

    private float getDamageEfficiency() {
        return this.damage > 0 ? 1.0f / (float)(this.damage + 1) : 1.0f;
    }

    protected final long getGenPower() {
        return (long)this.getGenTorque() * (long)this.omega;
    }

    protected double getEfficiency() {
        switch (this.getNumberStagesTotal()) {
            case 1: {
                return 0.025;
            }
            case 2: {
                return 0.1;
            }
            case 3: {
                return 0.25;
            }
            case 4: {
                return 0.5;
            }
            case 5: {
                return 1.0;
            }
        }
        return 0.0;
    }

    public final int getStage() {
        return this.stage;
    }

    private final int calcStage() {
        if (ReactorTiles.getTE((IBlockAccess)this.field_145850_b, this.readx, this.ready, this.readz) == this.getMachine()) {
            TileEntityTurbineCore tile = (TileEntityTurbineCore)this.field_145850_b.func_147438_o(this.readx, this.ready, this.readz);
            if (tile.writex == this.field_145851_c && tile.writey == this.field_145848_d && tile.writez == this.field_145849_e) {
                int stage = tile.calcStage();
                if (stage == this.getMaxStage()) {
                    return this.getMaxStage();
                }
                return stage + 1;
            }
        }
        return 0;
    }

    protected AxisAlignedBB getBoundingBox(World world, int x, int y, int z, int meta) {
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
        int r = 2 + this.stage;
        switch (meta) {
            case 2: 
            case 3: {
                box = box.func_72314_b((double)(r / 2), (double)(r / 2), 0.0);
                break;
            }
            case 0: 
            case 1: {
                box = box.func_72314_b(0.0, (double)(r / 2), (double)(r / 2));
            }
        }
        return box;
    }

    protected boolean intakeSteam(World world, int x, int y, int z, int meta) {
        Block id = world.func_147439_a(x, y - 1, z);
        int meta2 = world.func_72805_g(x, y - 1, z);
        boolean canAccel = false;
        if (id == ReactorBlocks.STEAM.getBlockInstance() && this.stage == 0 && (meta2 & 2) != 0 && (meta2 & 8) == 0) {
            int newmeta = 1 + (meta2 & 4);
            if ((meta2 & 4) != 0) {
                this.steam += 2;
                this.ammonia = true;
            } else {
                ++this.steam;
                this.ammonia = false;
            }
            canAccel = true;
        }
        if (canAccel && world.field_72995_K) {
            ForgeDirection dir = this.getSteamMovement();
            for (int i = 0; i < this.getNumberStagesTotal(); ++i) {
                TileEntityTurbineCore te = (TileEntityTurbineCore)world.func_147438_o(x + dir.offsetX, y, z + dir.offsetZ);
                double r = te.getRadius() * 2.4 - 2.0;
                for (int n = 0; n < 2; ++n) {
                    double v = ReikaRandomHelper.getRandomBetween((double)0.03125, (double)0.25);
                    double dx = (double)x + 0.5 + (double)(dir.offsetX * i);
                    double dy = (double)y + 0.5;
                    double dz = (double)z + 0.5 + (double)(dir.offsetZ * i);
                    dy = ReikaRandomHelper.getRandomPlusMinus((double)dy, (double)r);
                    if (dir.offsetX != 0) {
                        dz = ReikaRandomHelper.getRandomPlusMinus((double)dz, (double)r);
                    } else if (dir.offsetZ != 0) {
                        dx = ReikaRandomHelper.getRandomPlusMinus((double)dx, (double)r);
                    }
                    ReikaParticleHelper.CLOUD.spawnAt(world, dx, dy, dz, (double)dir.offsetX * v, 0.0, (double)dir.offsetZ * v);
                }
            }
        }
        return canAccel;
    }

    public boolean isAmmonia() {
        return this.ammonia;
    }

    private void readSurroundings(World world, int x, int y, int z, int meta) {
        if (this.canCollideCheck()) {
            this.contact.clear();
            if (this.contact.isEmpty()) {
                this.fillSurroundings(world, x, y, z, meta);
            }
            this.inter = null;
            for (int i = 0; i < this.contact.getSize(); ++i) {
                Coordinate c = this.contact.getNthBlock(i);
                if (!(ReikaMathLibrary.py3d((double)(x - c.xCoord), (double)(y - c.yCoord), (double)(z - c.zCoord)) <= this.getRadius())) continue;
                Block id2 = c.getBlock((IBlockAccess)world);
                int meta2 = c.getBlockMetadata((IBlockAccess)world);
                if (!ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)c.xCoord, (int)c.yCoord, (int)c.zCoord) && !c.equals(x, y, z) && id2 != ReactorBlocks.TURBINEMULTI.getBlockInstance()) {
                    this.phi = 0.0f;
                    this.omega = 0;
                    if (this.inter != null && this.inter.maxSpeed <= Interference.JAM.maxSpeed) continue;
                    this.inter = Interference.JAM;
                    continue;
                }
                if (!(id2 instanceof BlockLiquid) && !(id2 instanceof BlockFluidBase) || this.inter != null && this.inter.maxSpeed <= Interference.FLUID.maxSpeed) continue;
                this.inter = Interference.FLUID;
            }
        }
        if (this.getStage() == 0) {
            boolean accel;
            boolean bl = accel = this.enabled(world, x, y, z) && this.intakeSteam(world, x, y, z, meta);
            if (!world.field_72995_K) {
                this.updateSpeed(accel);
            }
        }
    }

    protected boolean canCollideCheck() {
        return true;
    }

    protected boolean enabled(World world, int x, int y, int z) {
        return this.enabled;
    }

    protected double getRadius() {
        return 1.5 + (double)(this.stage / 2);
    }

    private void fillSurroundings(World world, int x, int y, int z, int meta) {
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
        int r = 3;
        switch (meta) {
            case 2: 
            case 3: {
                for (int i = x - r; i <= x + r; ++i) {
                    for (int j = y - r; j <= y + r; ++j) {
                        if (x == i && y == j) continue;
                        this.contact.addBlockCoordinate(i, j, z);
                    }
                }
                break;
            }
            case 0: 
            case 1: {
                for (int i = z - r; i <= z + r; ++i) {
                    for (int j = y - r; j <= y + r; ++j) {
                        if (z == i && y == j) continue;
                        this.contact.addBlockCoordinate(x, j, i);
                    }
                }
                break;
            }
        }
    }

    private void enviroTest(World world, int x, int y, int z, int meta) {
        AxisAlignedBB box = this.getBoundingBox(world, x, y, z, meta);
        int r = 2 + this.stage / 2;
        List li = world.func_72872_a(EntityLivingBase.class, box);
        for (EntityLivingBase e : li) {
            if (this.getOmega() <= 0 || !(ReikaMathLibrary.py3d((double)(e.field_70165_t - (double)x - 0.5), (double)(e.field_70163_u - (double)y - 0.5), (double)(e.field_70161_v - (double)z - 0.5)) < (double)r)) continue;
            if (!TileEntityTurbineCore.canDamageTurbine((Entity)e)) continue;
            if (!world.field_72995_K) {
                Explosion exp = world.func_72876_a(null, e.field_70165_t, e.field_70163_u + (double)(e.func_70047_e() / 1.0f), e.field_70161_v, 2.0f, false);
                e.func_70097_a(DamageSource.func_94539_a((Explosion)exp), 2.0f);
                this.breakTurbine();
            }
            e.field_70159_w += 0.4 * (e.field_70165_t - (double)x - 0.5 + 0.1) + rand.nextDouble() * 0.1;
            e.field_70181_x += 0.4 * (e.field_70163_u - (double)y - 0.5 + 0.1);
            e.field_70179_y += 0.4 * (e.field_70161_v - (double)z - 0.5 + 0.1) + rand.nextDouble() * 0.1;
            if (this.inter != null && this.inter.maxSpeed <= Interference.MOB.maxSpeed) continue;
            this.inter = Interference.MOB;
        }
        if (this.inter != null) {
            this.omega = Math.min(this.omega, this.inter.maxSpeed);
        }
    }

    public static boolean canDamageTurbine(Entity e) {
        if (e instanceof EntityPlayer) {
            return !((EntityPlayer)e).field_71075_bZ.field_75098_d;
        }
        return ReikaEntityHelper.isSolidEntity((Entity)e);
    }

    protected void breakTurbine() {
        ++this.damage;
    }

    public final int getNumberStagesTotal() {
        if (this.needsMultiblock() && !this.hasMultiBlock()) {
            return 0;
        }
        if (ReactorTiles.getTE((IBlockAccess)this.field_145850_b, this.writex, this.writey, this.writez) == this.getMachine()) {
            TileEntityTurbineCore tile = (TileEntityTurbineCore)this.field_145850_b.func_147438_o(this.writex, this.writey, this.writez);
            if (tile.readx == this.field_145851_c && tile.ready == this.field_145848_d && tile.readz == this.field_145849_e && (tile.hasMultiBlock() || !tile.needsMultiblock())) {
                return tile.getNumberStagesTotal();
            }
        }
        return this.calcStage() + 1;
    }

    private void followHead(World world, int x, int y, int z, int meta) {
        TileEntityTurbineCore tile;
        if (ReactorTiles.getTE((IBlockAccess)this.field_145850_b, this.readx, this.ready, this.readz) == this.getMachine()) {
            tile = (TileEntityTurbineCore)world.func_147438_o(this.readx, this.ready, this.readz);
            if (tile.writex == x && tile.writey == y && tile.writez == z) {
                this.copyDataFrom(tile);
            }
        }
        if (ReactorTiles.getTE((IBlockAccess)this.field_145850_b, this.writex, this.writey, this.writez) == this.getMachine()) {
            tile = (TileEntityTurbineCore)this.field_145850_b.func_147438_o(this.writex, this.writey, this.writez);
            if (tile.readx == x && tile.ready == y && tile.readz == z && tile.inter != null) {
                this.inter = tile.inter;
            }
        }
    }

    protected void copyDataFrom(TileEntityTurbineCore tile) {
        this.omega = tile.omega;
        this.phi = tile.phi;
        this.steam = tile.steam;
        this.ammonia = tile.ammonia;
    }

    protected final void animateWithTick(World world, int x, int y, int z) {
        this.iotick -= 8;
        if (!this.isInWorld()) {
            this.phi = 0.0f;
            return;
        }
        this.phi = (float)((double)this.phi + this.getAnimationSpeed() * ReikaMathLibrary.doubpow((double)ReikaMathLibrary.logbase((long)(this.omega + 1), (int)2), (double)1.05));
    }

    protected double getAnimationSpeed() {
        return 0.2f;
    }

    public final int getOmega() {
        return this.isEmitting() ? this.omega : 0;
    }

    public final int getTorque() {
        return this.getGenTorque();
    }

    public final long getPower() {
        return this.getGenPower();
    }

    public final int getIORenderAlpha() {
        return this.iotick;
    }

    public final void setIORenderAlpha(int io) {
        this.iotick = io;
    }

    public final boolean canWriteTo(ForgeDirection from) {
        return this.field_145851_c + from.offsetX == this.writex && this.field_145848_d + from.offsetY == this.writey && this.field_145849_e + from.offsetZ == this.writez;
    }

    public final boolean isEmitting() {
        return this.getGenPower() > 0L;
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.omega = NBT.func_74762_e("speed");
        this.steam = NBT.func_74762_e("steamlevel");
        this.inter = Interference.get(NBT.func_74762_e("blocked"));
        this.damage = NBT.func_74762_e("dmg");
        this.ammonia = NBT.func_74767_n("ammonia");
        if (this.needsMultiblock() && NBT.func_74764_b("multi")) {
            this.hasMultiBlock = NBT.func_74767_n("multi");
        }
        this.tank.readFromNBT(NBT);
        this.stage = NBT.func_74762_e("stage");
        if (NBT.func_74764_b("t_enable")) {
            this.enabled = NBT.func_74767_n("t_enable");
        }
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("speed", this.omega);
        NBT.func_74768_a("steamlevel", this.steam);
        NBT.func_74768_a("dmg", this.damage);
        NBT.func_74757_a("ammonia", this.ammonia);
        if (this.inter != null) {
            NBT.func_74768_a("blocked", this.inter.ordinal());
        } else {
            NBT.func_74768_a("blocked", -1);
        }
        if (this.needsMultiblock()) {
            NBT.func_74757_a("multi", this.hasMultiBlock);
        }
        this.tank.writeToNBT(NBT);
        NBT.func_74768_a("stage", this.stage);
        NBT.func_74757_a("t_enable", this.enabled);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1)).func_72314_b(6.0, 6.0, 6.0);
    }

    public final long getMaxPower() {
        return this.getGenPower();
    }

    public final long getCurrentPower() {
        return this.getGenPower();
    }

    public final int getEmittingX() {
        return this.writex;
    }

    public final int getEmittingY() {
        return this.writey;
    }

    public final int getEmittingZ() {
        return this.writez;
    }

    public final boolean onShiftRightClick(World world, int x, int y, int z, ForgeDirection side) {
        return false;
    }

    public final boolean onRightClick(World world, int x, int y, int z, ForgeDirection side) {
        int meta = this.func_145832_p();
        this.setBlockMetadata(meta < (this.canOrientVertically() ? 5 : 3) ? meta + 1 : 0);
        return true;
    }

    protected boolean canOrientVertically() {
        return false;
    }

    public double func_145833_n() {
        return 4.0 * super.func_145833_n();
    }

    public final boolean canConnectToPipe(MachineRegistry m) {
        return m == MachineRegistry.HOSE || m == MachineRegistry.BEDPIPE;
    }

    public final boolean canConnectToPipeOnSide(MachineRegistry p, ForgeDirection side) {
        return this.canConnectToPipe(p);
    }

    public final TileEntityPiping.Flow getFlowForSide(ForgeDirection side) {
        return side == this.getSteamMovement().getOpposite() ? TileEntityPiping.Flow.INPUT : TileEntityPiping.Flow.NONE;
    }

    public final int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.canFill(from, resource.getFluid()) ? this.tank.fill(resource, doFill) : 0;
    }

    public final FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public final FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public final boolean canFill(ForgeDirection from, Fluid fluid) {
        return from == this.getSteamMovement().getOpposite() && fluid.equals(FluidRegistry.getFluid((String)"rc lubricant"));
    }

    public final boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public final FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }

    public final int getLubricant() {
        return this.tank.getLevel();
    }

    public int getLubricantToDrop() {
        return Math.abs(this.forcedlube - this.tank.getLevel()) < 25 ? this.forcedlube : this.tank.getLevel();
    }

    public void breakBlock() {
        TileEntityTurbineCore te;
        ForgeDirection dir = this.getSteamMovement();
        int dx = this.field_145851_c + dir.offsetX;
        int dy = this.field_145848_d + dir.offsetY;
        int dz = this.field_145849_e + dir.offsetZ;
        ReactorTiles m = ReactorTiles.getTE((IBlockAccess)this.field_145850_b, dx, dy, dz);
        if (m == this.getMachine()) {
            te = (TileEntityTurbineCore)this.getAdjacentTileEntity(dir);
            te.forcedlube = this.getLubricantToDrop();
        }
        dir = dir.getOpposite();
        dx = this.field_145851_c + dir.offsetX;
        dy = this.field_145848_d + dir.offsetY;
        dz = this.field_145849_e + dir.offsetZ;
        m = ReactorTiles.getTE((IBlockAccess)this.field_145850_b, dx, dy, dz);
        if (m == this.getMachine()) {
            te = (TileEntityTurbineCore)this.getAdjacentTileEntity(dir);
            te.forcedlube = this.getLubricantToDrop();
        }
    }

    public final void setLubricant(ItemStack is) {
        if (ReikaItemHelper.matchStacks((ItemStack)this.getMachine().getCraftedProduct(), (ItemStack)is) && is.field_77990_d != null) {
            int lube = is.field_77990_d.func_74762_e("lube");
            this.tank.setContents(lube, FluidRegistry.getFluid((String)"rc lubricant"));
        }
    }

    public final void addLubricant(int amt) {
        this.tank.addLiquid(amt, FluidRegistry.getFluid((String)"rc lubricant"));
    }

    public final boolean canAcceptLubricant(int amt) {
        return this.tank.canTakeIn(amt);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
        this.syncAllData(false);
    }

    public PowerSourceList getPowerSources(PowerSourceTracker io, ShaftMerger caller) {
        PowerSourceList p = new PowerSourceList();
        if (this.omega > 0) {
            p.addSource((PowerGenerator)this);
        }
        return p;
    }

    public void getAllOutputs(Collection<TileEntity> c, ForgeDirection dir) {
        c.add(this.getAdjacentTileEntity(this.getSteamMovement()));
    }

    public World getWorld() {
        return this.field_145850_b;
    }

    public int getX() {
        return this.field_145851_c;
    }

    public int getY() {
        return this.field_145848_d;
    }

    public int getZ() {
        return this.field_145849_e;
    }

    public int getIoOffsetX() {
        return 0;
    }

    public int getIoOffsetY() {
        return 0;
    }

    public int getIoOffsetZ() {
        return 0;
    }

    private static enum Interference {
        JAM(0),
        FLUID(512),
        MOB(4096);

        public final int maxSpeed;
        public static final Interference[] list;

        private Interference(int max) {
            this.maxSpeed = max;
        }

        public static Interference get(int o) {
            if (o < 0) {
                return null;
            }
            return list[o];
        }

        static {
            list = Interference.values();
        }
    }
}

