/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.TileEntities.Fusion;

import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.ReactorCraft.Auxiliary.ReactorCoreTE;
import Reika.ReactorCraft.Auxiliary.Temperatured;
import Reika.ReactorCraft.Base.TileEntityReactorBase;
import Reika.ReactorCraft.Entities.EntityNeutron;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.ReactorCraft.TileEntities.Fission.TileEntityWaterCell;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class TileEntityNeutronAbsorber
extends TileEntityReactorBase
implements Temperatured,
ReactorCoreTE {
    private StepTimer tempTimer = new StepTimer(20);

    @Override
    public int getIndex() {
        return ReactorTiles.ABSORBER.ordinal();
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        this.tempTimer.update();
        if (this.tempTimer.checkCap()) {
            this.updateTemperature(world, x, y, z);
            if (!world.field_72995_K && this.temperature >= this.getMaxTemperature()) {
                world.func_147449_b(x, y, z, (Block)Blocks.field_150356_k);
                ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)"random.fizz");
            }
        }
    }

    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public boolean onNeutron(EntityNeutron e, World world, int x, int y, int z) {
        if (e.getType() == EntityNeutron.NeutronType.FUSION) {
            this.temperature += 40;
            return true;
        }
        return false;
    }

    @Override
    public int getTemperature() {
        return this.temperature;
    }

    @Override
    public void setTemperature(int T) {
        this.temperature = T;
    }

    @Override
    public int getMaxTemperature() {
        return 1500;
    }

    @Override
    public boolean canDumpHeatInto(TileEntityWaterCell.LiquidStates liq) {
        return liq != TileEntityWaterCell.LiquidStates.EMPTY;
    }
}

