/*
 * Decompiled with CFR 0.152.
 */
package Reika.ReactorCraft.Blocks;

import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.ReactorCraft.Auxiliary.ClearSteamCommand;
import Reika.ReactorCraft.ReactorCraft;
import Reika.ReactorCraft.Registry.MatBlocks;
import Reika.ReactorCraft.Registry.ReactorBlocks;
import Reika.ReactorCraft.Registry.ReactorTiles;
import Reika.ReactorCraft.TileEntities.PowerGen.TileEntityTurbineCore;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidBase;

public class BlockSteam
extends Block {
    public BlockSteam(Material mat) {
        super(mat);
        this.func_149647_a((CreativeTabs)(ReactorCraft.instance.isLocked() ? null : ReactorCraft.tabRctr));
        this.func_149675_a(true);
        this.func_149752_b(3600000.0f);
        this.func_149713_g(0);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
    }

    public void func_149749_a(World world, int x, int y, int z, Block p5, int meta) {
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase e, ItemStack is) {
        if (e != null) {
            world.func_72921_c(x, y, z, 3, 3);
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        int maxh = 256;
        if (y > maxh || ClearSteamCommand.clearSteam()) {
            world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
            return;
        }
        int meta = world.func_72805_g(x, y, z);
        this.defaultMovement(world, x, y, z, rand, meta);
        world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
    }

    private void directionalMovement(World world, int x, int y, int z, Random rand, int meta) {
        ForgeDirection dir;
        switch (meta - 4) {
            case 0: {
                dir = ForgeDirection.EAST;
                break;
            }
            case 1: {
                dir = ForgeDirection.WEST;
                break;
            }
            case 2: {
                dir = ForgeDirection.SOUTH;
                break;
            }
            case 3: {
                dir = ForgeDirection.NORTH;
                break;
            }
            default: {
                dir = ForgeDirection.UP;
            }
        }
        int dx = x + dir.offsetX;
        int dy = y + dir.offsetY;
        int dz = z + dir.offsetZ;
        if (this.canMoveInto(world, dx, dy, dz)) {
            world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
            world.func_147465_d(dx, dy, dz, (Block)this, meta, 3);
        } else {
            world.func_72921_c(x, y, z, 0, 3);
        }
        world.func_147471_g(x, y, z);
        world.func_147471_g(dx, dy, dz);
    }

    private void defaultMovement(World world, int x, int y, int z, Random rand, int meta) {
        if (world.func_147439_a(x, y + 1, z) == ReactorBlocks.MATS.getBlockInstance() && world.func_72805_g(x, y + 1, z) == MatBlocks.SCRUBBER.ordinal()) {
            world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
            return;
        }
        if (ReactorTiles.getTE((IBlockAccess)world, x, y + 1, z) == ReactorTiles.TURBINECORE) {
            int dz;
            int dy;
            TileEntityTurbineCore te = (TileEntityTurbineCore)world.func_147438_o(x, y + 1, z);
            ForgeDirection dir = te.getSteamMovement();
            int d = te.getNumberStagesTotal() - te.getStage();
            int dx = x + dir.offsetX * d;
            if (this.canMoveInto(world, dx, dy = y + dir.offsetY, dz = z + dir.offsetZ * d)) {
                world.func_147465_d(dx, dy, dz, (Block)this, this.getTransmittedMetadata(meta, dir), 2);
                world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
                world.func_147471_g(dx, dy, dz);
            } else if (world.func_147439_a(dx, dy, dz) == ReactorBlocks.GENERATORMULTI.getBlockInstance() && world.func_72805_g(dx, dy, dz) % 8 == 3) {
                dx = te.field_145851_c + dir.offsetX * (1 + d);
                dy = te.field_145848_d + 3;
                dz = te.field_145849_e + dir.offsetZ * (1 + d);
                if (this.canMoveInto(world, dx, dy, dz)) {
                    world.func_147465_d(dx, dy, dz, (Block)this, this.getTransmittedMetadata(meta, dir), 2);
                    world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
                    world.func_147471_g(dx, dy, dz);
                } else {
                    world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
                }
            } else if (world.func_147439_a(dx, dy, dz) == ReactorBlocks.FLYWHEELMULTI.getBlockInstance()) {
                int ddx = ReikaRandomHelper.getRandomPlusMinus((int)dx, (int)(1 + 3 * Math.abs(dir.offsetZ)));
                int ddz = ReikaRandomHelper.getRandomPlusMinus((int)dz, (int)(1 + 3 * Math.abs(dir.offsetX)));
                if ((meta & 4) != 0) {
                    for (int i = 0; i <= 20 && !this.canMoveInto(world, dx, dy, dz); ++i) {
                        ddx = ReikaRandomHelper.getRandomPlusMinus((int)dx, (int)(1 + 3 * Math.abs(dir.offsetZ)));
                        ddz = ReikaRandomHelper.getRandomPlusMinus((int)dz, (int)(1 + 3 * Math.abs(dir.offsetX)));
                    }
                }
                if (this.canMoveInto(world, ddx, dy, ddz)) {
                    world.func_147465_d(ddx, dy, ddz, (Block)this, this.getTransmittedMetadata(meta, dir), 2);
                    world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
                    world.func_147471_g(ddx, dy, ddz);
                } else {
                    world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
                }
            } else {
                world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
            }
            world.func_147471_g(x, y, z);
            world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
            return;
        }
        if (this.canMoveInto(world, x, y + 1, z)) {
            if ((meta & 1) != 0 || ReikaRandomHelper.doWithChance((double)80.0)) {
                world.func_147465_d(x, y + 1, z, (Block)this, this.getTransmittedMetadata(meta, ForgeDirection.UP), 2);
            }
            world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
            world.func_147471_g(x, y, z);
            world.func_147471_g(x, y + 1, z);
            world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
            return;
        }
        Object[] dir = new ForgeDirection[]{ForgeDirection.EAST, ForgeDirection.WEST, ForgeDirection.SOUTH, ForgeDirection.NORTH};
        ReikaArrayHelper.shuffleArray((Object[])dir);
        for (int i = 0; i < dir.length; ++i) {
            int dx = x + ((ForgeDirection)dir[i]).offsetX;
            int dy = y + ((ForgeDirection)dir[i]).offsetY;
            int dz = z + ((ForgeDirection)dir[i]).offsetZ;
            if (!this.canMoveInto(world, dx, dy, dz)) continue;
            world.func_147465_d(dx, dy, dz, (Block)this, this.getTransmittedMetadata(meta, (ForgeDirection)dir[i]), 2);
            world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
            world.func_147471_g(x, y, z);
            world.func_147471_g(dx, dy, dz);
            world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world));
            return;
        }
    }

    public int getTransmittedMetadata(int original_meta, ForgeDirection dir) {
        if (dir == ForgeDirection.UP) {
            return (original_meta & 8) == 0 ? original_meta : 1 + (original_meta & 4);
        }
        return original_meta | 8;
    }

    public boolean canMoveInto(World world, int x, int y, int z) {
        Block id = world.func_147439_a(x, y, z);
        if (id == Blocks.field_150350_a) {
            return true;
        }
        if (id == this) {
            return false;
        }
        if (id instanceof BlockLiquid || id instanceof BlockFluidBase) {
            return false;
        }
        return ReikaWorldHelper.softBlocks((IBlockAccess)world, (int)x, (int)y, (int)z);
    }

    public int func_149738_a(World world) {
        return 2;
    }

    public boolean isAir(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public Item func_149650_a(int id, Random r, int fortune) {
        return null;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int meta, int fortune) {
        return new ArrayList<ItemStack>();
    }

    protected void func_149642_a(World world, int x, int y, int z, ItemStack is) {
    }

    public boolean func_149700_E() {
        return false;
    }

    public boolean func_149678_a(int par1, boolean par2) {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return 0;
    }

    public int func_149701_w() {
        return 1;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public IIcon getBlockTexture(IBlockAccess iba, int x, int y, int z) {
        return this.func_149691_a(0, 0);
    }

    public IIcon func_149691_a(int s, int meta) {
        return this.field_149761_L;
    }

    public void func_149651_a(IIconRegister ico) {
        this.field_149761_L = ico.func_94245_a("ReactorCraft:steam");
    }

    public boolean func_149646_a(IBlockAccess iba, int x, int y, int z, int side) {
        ForgeDirection dir = ForgeDirection.values()[side];
        int dx = x + dir.offsetX;
        int dy = y + dir.offsetY;
        int dz = z + dir.offsetZ;
        Block id = iba.func_147439_a(dx, dy, dz);
        return id != this && id != ReactorBlocks.MODELREACTOR.getBlockInstance();
    }

    public boolean isReplaceable(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public void func_149670_a(World world, int x, int y, int z, Entity e) {
        if (!(e instanceof EntityItem) && !(e instanceof EntityXPOrb)) {
            e.func_70097_a(DamageSource.field_76370_b, 1.0f);
            int meta = world.func_72805_g(x, y, z);
            if ((meta & 4) != 0 && e instanceof EntityLivingBase) {
                ((EntityLivingBase)e).func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 200, 0));
            }
        }
    }
}

