/*
 * Decompiled with CFR 0.152.
 */
package openmods.serializable;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import openmods.reflection.ConstructorAccess;
import openmods.serializable.IInstanceFactory;
import openmods.serializable.IObjectSerializer;
import openmods.serializable.IStreamReadable;
import openmods.serializable.IStreamWriteable;
import openmods.utils.io.IStreamReader;
import openmods.utils.io.IStreamSerializer;

public class SerializerAdapters {
    public static <T extends IStreamWriteable & IStreamReadable> IStreamSerializer<T> createFromFactory(final IInstanceFactory<T> factory) {
        return new IStreamSerializer<T>(){

            @Override
            public T readFromStream(DataInput input) throws IOException {
                IStreamWriteable instance = (IStreamWriteable)factory.create();
                ((IStreamReadable)((Object)instance)).readFromStream(input);
                return instance;
            }

            @Override
            public void writeToStream(T o, DataOutput output) throws IOException {
                o.writeToStream(output);
            }
        };
    }

    public static <T extends IStreamWriteable> IStreamSerializer<T> createFromReader(final IStreamReader<T> reader) {
        return new IStreamSerializer<T>(){

            @Override
            public T readFromStream(DataInput input) throws IOException {
                return (IStreamWriteable)reader.readFromStream(input);
            }

            @Override
            public void writeToStream(T o, DataOutput output) throws IOException {
                o.writeToStream(output);
            }
        };
    }

    public static <T> IStreamSerializer<T> createFromObjectSerializer(final IInstanceFactory<T> factory, final IObjectSerializer<T> serializer) {
        return new IStreamSerializer<T>(){

            @Override
            public T readFromStream(DataInput input) throws IOException {
                Object object = factory.create();
                serializer.readFromStream(object, input);
                return object;
            }

            @Override
            public void writeToStream(T o, DataOutput output) throws IOException {
                serializer.writeToStream(o, output);
            }
        };
    }

    public static <T> IStreamSerializer<T> createFromObjectSerializer(Class<? extends T> cls, IObjectSerializer<T> serializer) {
        ConstructorAccess<? extends T> factory = ConstructorAccess.create(cls);
        return SerializerAdapters.createFromObjectSerializer(factory, serializer);
    }
}

