/*
 * Decompiled with CFR 0.152.
 */
package openccsensors.common.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import resonantengine.api.graph.node.IEnergyNode;

public class UniversalElectricityUtils {
    public static boolean isValidTarget(TileEntity target) {
        return target instanceof IEnergyNode;
    }

    public static Map getDetails(World world, Object obj, boolean additional) {
        HashMap<String, Double> response = new HashMap<String, Double>();
        if (additional && obj instanceof IEnergyNode) {
            double joules = ((IEnergyNode)obj).getEnergy(ForgeDirection.UNKNOWN);
            double maxJoules = ((IEnergyNode)obj).getEnergyCapacity(ForgeDirection.UNKNOWN);
            response.put("Stored", joules);
            response.put("MaxStorage", maxJoules);
            if (maxJoules > 0.0) {
                double percent = 100.0 / maxJoules * joules;
                percent = Math.max(Math.min(percent, 100.0), 0.0);
                response.put("PowerPercentFull", percent);
            }
        }
        return response;
    }
}

