/*
 * Decompiled with CFR 0.152.
 */
package openccsensors.common.util;

import ic2.api.crops.CropCard;
import ic2.api.crops.ICropTile;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.NodeStats;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorChamber;
import ic2.api.tile.IEnergyStorage;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import openccsensors.common.util.InventoryUtils;

public class Ic2Utils {
    public static final int MASSFAB_MAX_ENERGY = 1100000;
    protected static final String MASS_FAB_CLASS = "ic2.core.block.machine.tileentity.TileEntityMatter";

    public static boolean isValidPowerTarget(Object target) {
        TileEntity energyTarget = null;
        if (target instanceof TileEntity) {
            TileEntity tile = (TileEntity)target;
            energyTarget = EnergyNet.instance.getTileEntity(tile.func_145831_w(), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
        }
        return energyTarget != null && (energyTarget instanceof IEnergySink || energyTarget instanceof IEnergySource || energyTarget instanceof IEnergyConductor || energyTarget instanceof IEnergyStorage);
    }

    public static boolean isValidMachineTarget(Object target) {
        return target != null && (target instanceof IReactor || target instanceof IReactorChamber);
    }

    public static HashMap getMachineDetails(World world, Object obj, boolean additional) {
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        if (obj == null || !(obj instanceof TileEntity) || !additional) {
            return response;
        }
        TileEntity tile = (TileEntity)obj;
        IReactor reactor = null;
        if (tile instanceof IReactor) {
            reactor = (IReactor)tile;
        } else if (tile instanceof IReactorChamber) {
            reactor = ((IReactorChamber)tile).getReactor();
        }
        if (reactor != null) {
            int maxHeat = reactor.getMaxHeat();
            int heat = reactor.getHeat();
            response.put("Heat", Integer.valueOf(heat));
            response.put("MaxHeat", Integer.valueOf(maxHeat));
            response.put("Output", Double.valueOf(reactor.getReactorEUEnergyOutput()));
            response.put("Active", Boolean.valueOf(reactor.produceEnergy()));
            response.put("HeatPercentage", Integer.valueOf(0));
            if (maxHeat > 0) {
                double heatPercentage = 100.0 / (double)maxHeat * (double)heat;
                response.put("HeatPercentage", Double.valueOf(Math.max(Math.min(heatPercentage, 100.0), 0.0)));
            }
        }
        if (tile.getClass().getName() == MASS_FAB_CLASS) {
            NBTTagCompound tagCompound = Ic2Utils.getTagCompound(tile);
            response.put("Energy", Integer.valueOf(tagCompound.func_74762_e("energy")));
            response.put("MaxEnergy", Integer.valueOf(1100000));
            response.put("Progress", Integer.valueOf(0));
            double progress = 9.09090909090909E-5 * (double)tagCompound.func_74762_e("energy");
            response.put("Progress", Double.valueOf(Math.min(Math.max(0.0, progress), 100.0)));
        }
        return response;
    }

    public static HashMap getPowerDetails(World world, Object obj, boolean additional) {
        HashMap<String, Number> response = new HashMap<String, Number>();
        if (obj == null || !(obj instanceof TileEntity) || !additional) {
            return response;
        }
        TileEntity tile = (TileEntity)obj;
        if (tile instanceof IEnergyStorage) {
            IEnergyStorage storage = (IEnergyStorage)tile;
            int capacity = storage.getCapacity();
            int stored = storage.getStored();
            response.put("Stored", stored);
            response.put("Capacity", capacity);
            response.put("Output", storage.getOutput());
            response.put("StoredPercentage", 0);
            if (capacity > 0) {
                response.put("StoredPercentage", Math.max(Math.min(100.0, 100.0 / (double)capacity * (double)stored), 0.0));
            }
        }
        if ((tile instanceof IEnergySink || tile instanceof IEnergySource || tile instanceof IEnergyConductor) && (tile = EnergyNet.instance.getTileEntity(tile.func_145831_w(), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e)) != null) {
            NodeStats stats = EnergyNet.instance.getNodeStats(tile);
            double energyIn = stats.getEnergyIn();
            double energyOut = stats.getEnergyOut();
            response.put("EnergyEmitted", energyOut);
            response.put("EnergySunken", energyIn);
            response.put("EnergyOut", energyOut);
            response.put("EnergyIn", energyIn);
            response.put("Voltage", stats.getVoltage());
        }
        return response;
    }

    protected static NBTTagCompound getTagCompound(TileEntity tile) {
        NBTTagCompound tagCompound = new NBTTagCompound();
        tile.func_145841_b(tagCompound);
        return tagCompound;
    }

    public static boolean isValidCropTarget(TileEntity tile) {
        return tile instanceof ICropTile;
    }

    public static Map getCropDetails(Object obj, ChunkCoordinates sensorPos, boolean additional) {
        HashMap<String, Object> response = new HashMap<String, Object>();
        if (obj == null) {
            return response;
        }
        TileEntity tile = (TileEntity)obj;
        HashMap<String, Integer> position = new HashMap<String, Integer>();
        position.put("X", tile.field_145851_c - sensorPos.field_71574_a);
        position.put("Y", tile.field_145848_d - sensorPos.field_71572_b);
        position.put("Z", tile.field_145849_e - sensorPos.field_71573_c);
        response.put("Position", position);
        ItemStack stack = new ItemStack(tile.func_145838_q(), 1, tile.func_145832_p());
        response.put("Name", InventoryUtils.getNameForItemStack(stack));
        response.put("RawName", InventoryUtils.getRawNameForStack(stack));
        response.put("DamageValue", stack.func_77960_j());
        if (obj instanceof ICropTile && additional) {
            ICropTile crop = (ICropTile)obj;
            response.put("AirQuality", crop.getAirQuality());
            response.put("Growth", crop.getGrowth());
            response.put("Gain", crop.getGain());
            response.put("Humidity", crop.getHumidity());
            response.put("HydrationStorage", crop.getHydrationStorage());
            response.put("LightLevel", crop.getLightLevel());
            response.put("Nutrients", crop.getNutrients());
            response.put("NutrientStorage", crop.getNutrientStorage());
            response.put("Resistance", crop.getResistance());
            response.put("ScanLevel", crop.getScanLevel());
            response.put("Size", crop.getSize());
            response.put("WeedExStorage", crop.getWeedExStorage());
            response.put("Status", "Empty");
            CropCard cropCard = crop.getCrop();
            if (cropCard != null) {
                response.put("IsWeed", cropCard.isWeed(crop));
                response.put("CanBeHarvested", cropCard.canBeHarvested(crop));
                if (cropCard.canBeHarvested(crop)) {
                    response.put("Status", "Grown");
                } else if (crop.getSize() == 0) {
                    response.put("Status", "New");
                } else {
                    response.put("Status", "Growing");
                }
                response.put("DiscoveredBy", cropCard.discoveredBy());
                response.put("EmittedLight", cropCard.getEmittedLight(crop));
                response.put("SizeAfterHarvest", cropCard.getSizeAfterHarvest(crop));
                response.put("CanCross", cropCard.canCross(crop));
                response.put("CanGrow", cropCard.canGrow(crop));
                response.put("Name", cropCard.getClass().getSimpleName());
            }
        }
        return response;
    }
}

