/*
 * Decompiled with CFR 0.152.
 */
package squeek.applecore.asm;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import squeek.applecore.asm.IClassTransformerModule;
import squeek.applecore.asm.module.ModuleBlockFood;
import squeek.applecore.asm.module.ModuleDrawTooltip;
import squeek.applecore.asm.module.ModuleFoodEatingSpeed;
import squeek.applecore.asm.module.ModuleFoodStats;
import squeek.applecore.asm.module.ModulePeacefulRegen;
import squeek.applecore.asm.module.ModulePlantFertilization;
import squeek.applecore.asm.module.ModulePlantGrowth;

public class TransformerModuleHandler
implements IClassTransformer {
    public static final String WILDCARD = "*";
    public static final String[] ALL_CLASSES = new String[]{"*"};
    private static final List<IClassTransformerModule> transformerModules = new ArrayList<IClassTransformerModule>();

    public static void registerTransformerModule(IClassTransformerModule transformerModule) {
        transformerModules.add(transformerModule);
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null) {
            return null;
        }
        for (IClassTransformerModule transformerModule : transformerModules) {
            for (String classToTransform : transformerModule.getClassesToTransform()) {
                if (!classToTransform.equals(WILDCARD) && !classToTransform.equals(transformedName)) continue;
                basicClass = transformerModule.transform(name, transformedName, basicClass);
            }
        }
        return basicClass;
    }

    static {
        TransformerModuleHandler.registerTransformerModule(new ModuleFoodStats());
        TransformerModuleHandler.registerTransformerModule(new ModulePlantGrowth());
        TransformerModuleHandler.registerTransformerModule(new ModuleFoodEatingSpeed());
        TransformerModuleHandler.registerTransformerModule(new ModuleBlockFood());
        TransformerModuleHandler.registerTransformerModule(new ModuleDrawTooltip());
        TransformerModuleHandler.registerTransformerModule(new ModulePeacefulRegen());
        TransformerModuleHandler.registerTransformerModule(new ModulePlantFertilization());
    }
}

