/*
 * Decompiled with CFR 0.152.
 */
package org.dave.CompactMachines.machines.tools;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.util.ForgeDirection;
import org.dave.CompactMachines.CompactMachines;
import org.dave.CompactMachines.handler.ConfigurationHandler;
import org.dave.CompactMachines.init.ModBlocks;
import org.dave.CompactMachines.integration.item.ItemSharedStorage;
import org.dave.CompactMachines.reference.Reference;
import org.dave.CompactMachines.tileentity.TileEntityInterface;
import org.dave.CompactMachines.tileentity.TileEntityMachine;
import org.dave.CompactMachines.utility.WorldUtils;

public class CubeTools {
    public static int getCoordByPos(double x) {
        return (int)(x / (double)ConfigurationHandler.cubeDistance);
    }

    public static int getCubeSize(IBlockAccess world, int coord) {
        int base = coord * ConfigurationHandler.cubeDistance;
        if (world.func_147439_a(base + 14, 40, 0) == ModBlocks.innerwall) {
            return 5;
        }
        if (world.func_147439_a(base + 12, 40, 0) == ModBlocks.innerwall) {
            return 4;
        }
        if (world.func_147439_a(base + 10, 40, 0) == ModBlocks.innerwall) {
            return 3;
        }
        if (world.func_147439_a(base + 8, 40, 0) == ModBlocks.innerwall) {
            return 2;
        }
        if (world.func_147439_a(base + 6, 40, 0) == ModBlocks.innerwall) {
            return 1;
        }
        return 0;
    }

    public static boolean shouldSideBeRendered(IBlockAccess world, int x, int y, int z, int side) {
        int coord = CubeTools.getCoordByPos(x);
        int size = Reference.getBoxSize(CubeTools.getCubeSize(world, coord));
        int relativeX = x - coord * ConfigurationHandler.cubeDistance;
        if (y == 41 && relativeX > 0 && relativeX < size && z < size && z > 0 && side == ForgeDirection.UP.ordinal()) {
            return true;
        }
        if (y == 39 + size && relativeX > 0 && relativeX < size && z < size && z > 0 && side == ForgeDirection.DOWN.ordinal()) {
            return true;
        }
        if (y > 40 && y < 40 + size) {
            if (side == ForgeDirection.EAST.ordinal() && relativeX == 1 && z < size && z > 0) {
                return true;
            }
            if (side == ForgeDirection.WEST.ordinal() && relativeX == size - 1 && z < size && z > 0) {
                return true;
            }
            if (side == ForgeDirection.NORTH.ordinal() && z == size - 1 && relativeX < size && relativeX > 0) {
                return true;
            }
            if (side == ForgeDirection.SOUTH.ordinal() && z == 1 && relativeX < size && relativeX > 0) {
                return true;
            }
        }
        return false;
    }

    public static void setCubeBiome(int coords, BiomeGenBase biome) {
        WorldServer machineWorld = MinecraftServer.func_71276_C().func_71218_a(ConfigurationHandler.dimensionId);
        Chunk chunk = machineWorld.func_72938_d(coords * ConfigurationHandler.cubeDistance, 0);
        if (chunk != null && chunk.field_76636_d) {
            byte[] biomeArray = chunk.func_76605_m();
            for (int x = 0; x < 15; ++x) {
                for (int z = 0; z < 15; ++z) {
                    biomeArray[z << 4 | x] = (byte)biome.field_76756_M;
                }
            }
        }
    }

    public static BiomeGenBase getMachineBiome(TileEntityMachine machine) {
        byte[] biomeArray = machine.func_145831_w().func_72938_d(machine.field_145851_c, machine.field_145849_e).func_76605_m();
        byte biomeId = biomeArray[(machine.field_145849_e & 0xF) << 4 | machine.field_145851_c & 0xF];
        if (biomeId > 0 && biomeId < BiomeGenBase.func_150565_n().length && BiomeDictionary.isBiomeRegistered((int)biomeId)) {
            return BiomeGenBase.func_150568_d((int)biomeId);
        }
        return WorldUtils.getBiomeByName(ConfigurationHandler.defaultBiome);
    }

    public static void generateCube(TileEntityMachine machine) {
        int size;
        int height = size = Reference.getBoxSize(machine.meta);
        WorldServer machineWorld = MinecraftServer.func_71276_C().func_71218_a(ConfigurationHandler.dimensionId);
        int x = machine.coords * ConfigurationHandler.cubeDistance;
        machineWorld.field_73059_b.func_73158_c((int)Math.floor((double)x / 16.0), 0);
        CubeTools.generateCube((World)machineWorld, x, 40, 0, x + size, 40 + height, size);
        if (ConfigurationHandler.adaptBiomes) {
            CubeTools.setCubeBiome(machine.coords, CubeTools.getMachineBiome(machine));
        } else {
            BiomeGenBase biome = WorldUtils.getBiomeByName(ConfigurationHandler.defaultBiome);
            CubeTools.setCubeBiome(machine.coords, biome);
        }
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            Vec3 pos = CubeTools.getInterfacePosition(machine.coords, machine.meta, dir);
            TileEntityInterface te = (TileEntityInterface)machineWorld.func_147438_o((int)pos.field_72450_a, (int)pos.field_72448_b, (int)pos.field_72449_c);
            te.setCoordSide(machine.coords, dir.ordinal());
        }
    }

    private static void generateCube(World worldObj, int posX1, int posY1, int posZ1, int posX2, int posY2, int posZ2) {
        int minX = Math.min(posX1, posX2);
        int minY = Math.min(posY1, posY2);
        int minZ = Math.min(posZ1, posZ2);
        int maxX = Math.max(posX1, posX2);
        int maxY = Math.max(posY1, posY2);
        int maxZ = Math.max(posZ1, posZ2);
        int midX = (int)Math.floor((posX1 + posX2) / 2);
        int midY = (int)Math.floor((posY1 + posY2) / 2);
        int midZ = (int)Math.floor((posZ1 + posZ2) / 2);
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (x != minX && y != minY && z != minZ && x != maxX && y != maxY && z != maxZ) continue;
                    Vec3 pos = Vec3.func_72443_a((double)x, (double)y, (double)z);
                    if (x == midX && y == midY && z == minZ) {
                        worldObj.func_147465_d(x, y, z, (Block)ModBlocks.interfaceblock, 0, 2);
                        continue;
                    }
                    if (x == midX && y == midY && z == maxZ) {
                        worldObj.func_147465_d(x, y, z, (Block)ModBlocks.interfaceblock, 0, 2);
                        continue;
                    }
                    if (x == midX && y == minY && z == midZ) {
                        worldObj.func_147465_d(x, y, z, (Block)ModBlocks.interfaceblock, 0, 2);
                        continue;
                    }
                    if (x == midX && y == maxY && z == midZ) {
                        worldObj.func_147465_d(x, y, z, (Block)ModBlocks.interfaceblock, 0, 2);
                        continue;
                    }
                    if (x == minX && y == midY && z == midZ) {
                        worldObj.func_147465_d(x, y, z, (Block)ModBlocks.interfaceblock, 0, 2);
                        continue;
                    }
                    if (x == maxX && y == midY && z == midZ) {
                        worldObj.func_147465_d(x, y, z, (Block)ModBlocks.interfaceblock, 0, 2);
                        continue;
                    }
                    worldObj.func_147465_d(x, y, z, (Block)ModBlocks.innerwall, 0, 2);
                }
            }
        }
    }

    public static void harvestMachine(TileEntityMachine machine, EntityPlayer player) {
        int size;
        if (machine.coords == -1) {
            return;
        }
        WorldServer machineWorld = MinecraftServer.func_71276_C().func_71218_a(ConfigurationHandler.dimensionId);
        int height = size = Reference.getBoxSize(machine.meta);
        List<ItemStack> stacks = CubeTools.harvestCube((World)machineWorld, machine.coords * ConfigurationHandler.cubeDistance + 1, 41, 1, machine.coords * ConfigurationHandler.cubeDistance + size - 1, 40 + height - 1, size - 1, player);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            ItemSharedStorage storage = machine.getStorage(dir.ordinal());
            ItemStack storedStack = storage.func_70301_a(0);
            if (storedStack != null && storedStack.field_77994_a > 0) {
                stacks.add(storedStack);
            }
            storage.func_70299_a(0, null);
            storage.setDirty();
        }
        World worldObj = CompactMachines.instance.machineHandler.getWorld();
        int droppedStacks = 0;
        for (ItemStack stack : stacks) {
            if (ConfigurationHandler.maxDroppedStacks != -1 && droppedStacks >= ConfigurationHandler.maxDroppedStacks) {
                return;
            }
            EntityItem entityitem = new EntityItem(machine.func_145831_w(), (double)machine.field_145851_c, (double)((float)machine.field_145848_d + 0.5f), (double)machine.field_145849_e, stack);
            entityitem.lifespan = 1200;
            entityitem.field_145804_b = 10;
            float f3 = 0.05f;
            entityitem.field_70159_w = (float)worldObj.field_73012_v.nextGaussian() * f3;
            entityitem.field_70181_x = (float)worldObj.field_73012_v.nextGaussian() * f3 + 0.2f;
            entityitem.field_70179_y = (float)worldObj.field_73012_v.nextGaussian() * f3;
            machine.func_145831_w().func_72838_d((Entity)entityitem);
            ++droppedStacks;
        }
    }

    private static List<ItemStack> harvestCube(World worldObj, int posX1, int posY1, int posZ1, int posX2, int posY2, int posZ2, EntityPlayer player) {
        int minX = Math.min(posX1, posX2);
        int minY = Math.min(posY1, posY2);
        int minZ = Math.min(posZ1, posZ2);
        int maxX = Math.max(posX1, posX2);
        int maxY = Math.max(posY1, posY2);
        int maxZ = Math.max(posZ1, posZ2);
        ArrayList<ItemStack> returnList = new ArrayList<ItemStack>();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    ArrayList<ItemStack> dropsList = WorldUtils.getItemStackFromBlock(worldObj, x, y, z);
                    if (dropsList != null) {
                        for (ItemStack s : dropsList) {
                            returnList.add(s);
                        }
                    }
                    if (player != null && worldObj.func_147438_o(x, y, z) instanceof TileEntityMachine) {
                        Block block = worldObj.func_147439_a(x, y, z);
                        block.removedByPlayer(worldObj, player, x, y, z, true);
                    }
                    worldObj.func_147468_f(x, y, z);
                    double[] head = new double[]{x, y, z};
                    AxisAlignedBB axis = AxisAlignedBB.func_72330_a((double)(head[0] - 2.0), (double)(head[1] - 2.0), (double)(head[2] - 2.0), (double)(head[0] + 3.0), (double)(head[1] + 3.0), (double)(head[2] + 3.0));
                    List result = worldObj.func_72872_a(EntityItem.class, axis);
                    for (int ii = 0; ii < result.size(); ++ii) {
                        if (!(result.get(ii) instanceof EntityItem)) continue;
                        EntityItem entity = (EntityItem)result.get(ii);
                        if (entity.field_70128_L) continue;
                        ItemStack mineable = entity.func_92059_d();
                        if (mineable.field_77994_a <= 0) continue;
                        entity.field_70170_p.func_72900_e((Entity)entity);
                        returnList.add(mineable);
                    }
                }
            }
        }
        return returnList;
    }

    public static Vec3 getInterfacePosition(int coord, int meta, ForgeDirection dir) {
        int size;
        int height = size = Reference.getBoxSize(meta);
        int xMin = coord * ConfigurationHandler.cubeDistance;
        int yMin = 40;
        int zMin = 0;
        int midX = xMin + size / 2;
        int midY = yMin + size / 2;
        int midZ = zMin + size / 2;
        int x = 0;
        int y = 0;
        int z = 0;
        if (dir == ForgeDirection.DOWN) {
            y = yMin;
            x = midX;
            z = midZ;
        } else if (dir == ForgeDirection.UP) {
            y = yMin + size;
            x = midX;
            z = midZ;
        } else {
            y = midY;
            if (dir == ForgeDirection.NORTH) {
                x = midX;
                z = zMin;
            } else if (dir == ForgeDirection.SOUTH) {
                x = midX;
                z = zMin + size;
            } else if (dir == ForgeDirection.EAST) {
                z = midZ;
                x = xMin + size;
            } else if (dir == ForgeDirection.WEST) {
                z = midZ;
                x = xMin;
            }
        }
        return Vec3.func_72443_a((double)x, (double)y, (double)z);
    }

    public static AxisAlignedBB getBoundingBoxForCube(int coord, int size) {
        AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)(coord * ConfigurationHandler.cubeDistance + 1), (double)40.0, (double)0.0, (double)(coord * ConfigurationHandler.cubeDistance + size + 1), (double)(40 + size + 1), (double)(size + 1));
        return bb;
    }
}

