/*
 * Decompiled with CFR 0.152.
 */
package org.dave.CompactMachines;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.command.ICommand;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import org.dave.CompactMachines.command.CommandSetCMCoords;
import org.dave.CompactMachines.handler.CMEventHandler;
import org.dave.CompactMachines.handler.CMTickHandler;
import org.dave.CompactMachines.handler.ConfigurationHandler;
import org.dave.CompactMachines.handler.GuiHandler;
import org.dave.CompactMachines.handler.SharedStorageHandler;
import org.dave.CompactMachines.handler.VillagerHandler;
import org.dave.CompactMachines.init.ModBlocks;
import org.dave.CompactMachines.init.ModItems;
import org.dave.CompactMachines.init.Recipes;
import org.dave.CompactMachines.machines.EntangleRegistry;
import org.dave.CompactMachines.machines.MachineSaveData;
import org.dave.CompactMachines.machines.world.MachineWorldChunkloadCallback;
import org.dave.CompactMachines.machines.world.WorldProviderMachines;
import org.dave.CompactMachines.network.PacketHandler;
import org.dave.CompactMachines.proxy.IProxy;
import org.dave.CompactMachines.reference.Reference;
import org.dave.CompactMachines.utility.LogHelper;

@Mod(modid="CompactMachines", name="Compact Machines", version="1.7.10-1.21", dependencies="after:appliedenergistics2;after:ProjRed|Transmission;after:OpenComputers;after:Waila;after:Botania;after:LookingGlass;after:Thaumcraft;after:PneumaticCraft;", guiFactory="org.dave.CompactMachines.client.CMGuiFactory")
public class CompactMachines {
    @Mod.Instance(value="CompactMachines")
    public static CompactMachines instance;
    @SidedProxy(clientSide="org.dave.CompactMachines.proxy.ClientProxy", serverSide="org.dave.CompactMachines.proxy.ServerProxy")
    public static IProxy proxy;
    public MachineSaveData machineHandler;
    public EntangleRegistry entangleRegistry;

    @Mod.EventHandler
    public void preServerStart(FMLServerAboutToStartEvent event) {
        this.entangleRegistry.clear();
        SharedStorageHandler.reloadStorageHandler(false);
        if (event.getSide() == Side.CLIENT) {
            LogHelper.info("Registering dimension " + ConfigurationHandler.dimensionId + " on client side");
            DimensionManager.registerProviderType((int)ConfigurationHandler.dimensionId, WorldProviderMachines.class, (boolean)true);
            DimensionManager.registerDimension((int)ConfigurationHandler.dimensionId, (int)ConfigurationHandler.dimensionId);
        }
    }

    @Mod.EventHandler
    public void postServerEnd(FMLServerStoppedEvent event) {
        if (event.getSide() == Side.CLIENT) {
            LogHelper.info("Unregistering dimension " + ConfigurationHandler.dimensionId + " on client side");
            DimensionManager.unregisterProviderType((int)ConfigurationHandler.dimensionId);
            DimensionManager.unregisterDimension((int)ConfigurationHandler.dimensionId);
        }
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandSetCMCoords());
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ConfigurationHandler.init(event.getSuggestedConfigurationFile());
        FMLCommonHandler.instance().bus().register((Object)new ConfigurationHandler());
        Reference.AE_AVAILABLE = Loader.isModLoaded((String)"appliedenergistics2");
        Reference.PR_AVAILABLE = Loader.isModLoaded((String)"ProjRed|Transmission");
        Reference.OC_AVAILABLE = Loader.isModLoaded((String)"OpenComputers");
        Reference.BOTANIA_AVAILABLE = Loader.isModLoaded((String)"Botania");
        Reference.MEK_AVAILABLE = Loader.isModLoaded((String)"Mekanism");
        Reference.THAUMCRAFT_AVAILABLE = Loader.isModLoaded((String)"Thaumcraft");
        Reference.PNEUMATICCRAFT_AVAILABLE = Loader.isModLoaded((String)"PneumaticCraft");
        if (ConfigurationHandler.dimensionId != -1 && event.getSide() == Side.SERVER) {
            LogHelper.info("Registering dimension " + ConfigurationHandler.dimensionId + " on server side");
            DimensionManager.registerProviderType((int)ConfigurationHandler.dimensionId, WorldProviderMachines.class, (boolean)true);
            DimensionManager.registerDimension((int)ConfigurationHandler.dimensionId, (int)ConfigurationHandler.dimensionId);
        }
        ModItems.init();
        ModBlocks.init();
        if (ConfigurationHandler.enableVillager) {
            VillagerHandler.instance().init();
        }
        CMEventHandler rte = new CMEventHandler();
        MinecraftForge.EVENT_BUS.register((Object)rte);
        FMLCommonHandler.instance().bus().register((Object)rte);
        CMTickHandler cth = new CMTickHandler();
        MinecraftForge.EVENT_BUS.register((Object)cth);
        FMLCommonHandler.instance().bus().register((Object)cth);
        MinecraftForge.EVENT_BUS.register((Object)new SharedStorageHandler.SharedStorageSaveHandler());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        PacketHandler.init();
        this.entangleRegistry = new EntangleRegistry();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        if (Loader.isModLoaded((String)"LookingGlass")) {
            FMLInterModComms.sendMessage((String)"LookingGlass", (String)"API", (String)"org.dave.CompactMachines.thirdparty.lookingglass.LookingGlassIntegration.register");
        } else {
            proxy.registerRenderers();
        }
        proxy.registerTileEntities();
        proxy.registerHandlers();
        if (ConfigurationHandler.enableVillager) {
            proxy.registerVillagerSkins();
        }
        Recipes.init();
        if (Loader.isModLoaded((String)"Waila")) {
            FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"org.dave.CompactMachines.handler.waila.BlockHandler.callbackRegister");
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (ConfigurationHandler.dimensionId == -1) {
            int dimensionId = DimensionManager.getNextFreeDimId();
            LogHelper.info("Using dimension " + dimensionId + " as machine dimension.");
            ConfigurationHandler.dimensionId = dimensionId;
            ConfigurationHandler.saveConfiguration();
            DimensionManager.registerProviderType((int)ConfigurationHandler.dimensionId, WorldProviderMachines.class, (boolean)true);
            DimensionManager.registerDimension((int)ConfigurationHandler.dimensionId, (int)ConfigurationHandler.dimensionId);
        }
        if ((Reference.upgradeItem = (Item)GameData.getItemRegistry().func_82594_a(ConfigurationHandler.upgradeItem)) == null) {
            LogHelper.warn("Upgrade item '" + ConfigurationHandler.upgradeItem + "' not found! Using nether_star.");
            Reference.upgradeItem = Items.field_151156_bN;
        }
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)instance, (ForgeChunkManager.LoadingCallback)new MachineWorldChunkloadCallback());
    }
}

