/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.cos.network;

import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import io.netty.channel.ChannelHandler;
import java.util.EnumMap;
import lain.mods.cos.network.NetworkPacket;
import lain.mods.cos.network.NetworkPacketCodec;
import lain.mods.cos.network.NetworkPacketHandler;
import net.minecraft.entity.player.EntityPlayerMP;

public class NetworkManager {
    private final NetworkPacketCodec codec = new NetworkPacketCodec();
    private final NetworkPacketHandler handler = new NetworkPacketHandler();
    private EnumMap<Side, FMLEmbeddedChannel> channels;

    public NetworkManager(String channelName) {
        this.channels = NetworkRegistry.INSTANCE.newChannel(channelName, new ChannelHandler[]{this.codec});
        for (FMLEmbeddedChannel channel : this.channels.values()) {
            channel.pipeline().addAfter(channel.findChannelHandlerNameForType(((Object)((Object)this.codec)).getClass()), "NetworkPacketHandler", (ChannelHandler)this.handler);
        }
    }

    public void registerPacket(int discriminator, Class<? extends NetworkPacket> packetClass) {
        if (discriminator < 0 || discriminator > 255) {
            throw new IllegalArgumentException("Invalid discriminator, valid range: 0-255.");
        }
        this.codec.addDiscriminator(discriminator, packetClass);
    }

    public void sendTo(NetworkPacket packet, EntityPlayerMP player) {
        if (packet != null && player != null) {
            this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
            this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
            this.channels.get(Side.SERVER).writeAndFlush((Object)packet);
        }
    }

    public void sendToAll(NetworkPacket packet) {
        if (packet != null) {
            this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
            this.channels.get(Side.SERVER).writeAndFlush((Object)packet);
        }
    }

    public void sendToAllAround(NetworkPacket packet, NetworkRegistry.TargetPoint point) {
        if (packet != null && point != null) {
            this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
            this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
            this.channels.get(Side.SERVER).writeAndFlush((Object)packet);
        }
    }

    public void sendToDimension(NetworkPacket packet, int dimensionId) {
        if (packet != null) {
            this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
            this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimensionId);
            this.channels.get(Side.SERVER).writeAndFlush((Object)packet);
        }
    }

    public void sendToServer(NetworkPacket packet) {
        if (packet != null) {
            this.channels.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
            this.channels.get(Side.CLIENT).writeAndFlush((Object)packet);
        }
    }
}

