/*
 * Decompiled with CFR 0.152.
 */
package org.mod.luaj.vm2;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.mod.luaj.vm2.Lua;
import org.mod.luaj.vm2.LuaClosure;
import org.mod.luaj.vm2.LuaString;
import org.mod.luaj.vm2.LuaValue;
import org.mod.luaj.vm2.Prototype;
import org.mod.luaj.vm2.Upvaldesc;
import org.mod.luaj.vm2.Varargs;

public class Print
extends Lua {
    private static final String STRING_FOR_NULL = "null";
    public static PrintStream ps = System.out;
    public static final String[] OPNAMES = new String[]{"MOVE", "LOADK", "LOADKX", "LOADBOOL", "LOADNIL", "GETUPVAL", "GETTABUP", "GETTABLE", "SETTABUP", "SETUPVAL", "SETTABLE", "NEWTABLE", "SELF", "ADD", "SUB", "MUL", "DIV", "MOD", "POW", "UNM", "NOT", "LEN", "CONCAT", "JMP", "EQ", "LT", "LE", "TEST", "TESTSET", "CALL", "TAILCALL", "RETURN", "FORLOOP", "FORPREP", "TFORCALL", "TFORLOOP", "SETLIST", "CLOSURE", "VARARG", "EXTRAARG", null};

    static void printString(PrintStream ps, LuaString s) {
        ps.print('\"');
        int n = s.m_length;
        block11: for (int i = 0; i < n; ++i) {
            byte c = s.m_bytes[s.m_offset + i];
            if (c >= 32 && c <= 126 && c != 34 && c != 92) {
                ps.print((char)c);
                continue;
            }
            switch (c) {
                case 34: {
                    ps.print("\\\"");
                    continue block11;
                }
                case 92: {
                    ps.print("\\\\");
                    continue block11;
                }
                case 7: {
                    ps.print("\\a");
                    continue block11;
                }
                case 8: {
                    ps.print("\\b");
                    continue block11;
                }
                case 12: {
                    ps.print("\\f");
                    continue block11;
                }
                case 9: {
                    ps.print("\\t");
                    continue block11;
                }
                case 13: {
                    ps.print("\\r");
                    continue block11;
                }
                case 10: {
                    ps.print("\\n");
                    continue block11;
                }
                case 11: {
                    ps.print("\\v");
                    continue block11;
                }
                default: {
                    ps.print('\\');
                    ps.print(Integer.toString(0x4E7 & c).substring(1));
                }
            }
        }
        ps.print('\"');
    }

    static void printValue(PrintStream ps, LuaValue v) {
        switch (v.type()) {
            case 4: {
                Print.printString(ps, (LuaString)v);
                break;
            }
            default: {
                ps.print(v.tojstring());
            }
        }
    }

    static void printConstant(PrintStream ps, Prototype f, int i) {
        Print.printValue(ps, f.k[i]);
    }

    static void printUpvalue(PrintStream ps, Upvaldesc u) {
        ps.print(u.idx + " ");
        Print.printValue(ps, u.name);
    }

    public static void printCode(Prototype f) {
        int[] code = f.code;
        int n = code.length;
        for (int pc = 0; pc < n; ++pc) {
            Print.printOpCode(f, pc);
            ps.println();
        }
    }

    public static void printOpCode(Prototype f, int pc) {
        Print.printOpCode(ps, f, pc);
    }

    public static void printOpCode(PrintStream ps, Prototype f, int pc) {
        int[] code = f.code;
        int i = code[pc];
        int o = Print.GET_OPCODE(i);
        int a = Print.GETARG_A(i);
        int b = Print.GETARG_B(i);
        int c = Print.GETARG_C(i);
        int bx = Print.GETARG_Bx(i);
        int sbx = Print.GETARG_sBx(i);
        int line = Print.getline(f, pc);
        ps.print("  " + (pc + 1) + "  ");
        if (line > 0) {
            ps.print("[" + line + "]  ");
        } else {
            ps.print("[-]  ");
        }
        ps.print(OPNAMES[o] + "  ");
        switch (Print.getOpMode(o)) {
            case 0: {
                ps.print(a);
                if (Print.getBMode(o) != 0) {
                    ps.print(" " + (Print.ISK(b) ? -1 - Print.INDEXK(b) : b));
                }
                if (Print.getCMode(o) == 0) break;
                ps.print(" " + (Print.ISK(c) ? -1 - Print.INDEXK(c) : c));
                break;
            }
            case 1: {
                if (Print.getBMode(o) == 3) {
                    ps.print(a + " " + (-1 - bx));
                    break;
                }
                ps.print(a + " " + bx);
                break;
            }
            case 2: {
                if (o == 23) {
                    ps.print(sbx);
                    break;
                }
                ps.print(a + " " + sbx);
            }
        }
        switch (o) {
            case 1: {
                ps.print("  ; ");
                Print.printConstant(ps, f, bx);
                break;
            }
            case 5: 
            case 9: {
                ps.print("  ; ");
                Print.printUpvalue(ps, f.upvalues[b]);
                break;
            }
            case 6: {
                ps.print("  ; ");
                Print.printUpvalue(ps, f.upvalues[b]);
                ps.print(" ");
                if (Print.ISK(c)) {
                    Print.printConstant(ps, f, Print.INDEXK(c));
                    break;
                }
                ps.print("-");
                break;
            }
            case 8: {
                ps.print("  ; ");
                Print.printUpvalue(ps, f.upvalues[a]);
                ps.print(" ");
                if (Print.ISK(b)) {
                    Print.printConstant(ps, f, Print.INDEXK(b));
                } else {
                    ps.print("-");
                }
                ps.print(" ");
                if (Print.ISK(c)) {
                    Print.printConstant(ps, f, Print.INDEXK(c));
                    break;
                }
                ps.print("-");
                break;
            }
            case 7: 
            case 12: {
                if (!Print.ISK(c)) break;
                ps.print("  ; ");
                Print.printConstant(ps, f, Print.INDEXK(c));
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 24: 
            case 25: 
            case 26: {
                if (!Print.ISK(b) && !Print.ISK(c)) break;
                ps.print("  ; ");
                if (Print.ISK(b)) {
                    Print.printConstant(ps, f, Print.INDEXK(b));
                } else {
                    ps.print("-");
                }
                ps.print(" ");
                if (Print.ISK(c)) {
                    Print.printConstant(ps, f, Print.INDEXK(c));
                    break;
                }
                ps.print("-");
                break;
            }
            case 23: 
            case 32: 
            case 33: {
                ps.print("  ; to " + (sbx + pc + 2));
                break;
            }
            case 37: {
                ps.print("  ; " + f.p[bx].getClass().getName());
                break;
            }
            case 36: {
                if (c == 0) {
                    ps.print("  ; " + code[++pc]);
                    break;
                }
                ps.print("  ; " + c);
                break;
            }
            case 38: {
                ps.print("  ; is_vararg=" + f.is_vararg);
                break;
            }
        }
    }

    private static int getline(Prototype f, int pc) {
        return pc > 0 && f.lineinfo != null && pc < f.lineinfo.length ? f.lineinfo[pc] : -1;
    }

    static void printHeader(Prototype f) {
        String s = String.valueOf(f.source);
        s = s.startsWith("@") || s.startsWith("=") ? s.substring(1) : ("\u001bLua".equals(s) ? "(bstring)" : "(string)");
        String a = f.linedefined == 0 ? "main" : "function";
        ps.print("\n%" + a + " <" + s + ":" + f.linedefined + "," + f.lastlinedefined + "> (" + f.code.length + " instructions, " + f.code.length * 4 + " bytes at " + Print.id(f) + ")\n");
        ps.print(f.numparams + " param, " + f.maxstacksize + " slot, " + f.upvalues.length + " upvalue, ");
        ps.print(f.locvars.length + " local, " + f.k.length + " constant, " + f.p.length + " function\n");
    }

    static void printConstants(Prototype f) {
        int n = f.k.length;
        ps.print("constants (" + n + ") for " + Print.id(f) + ":\n");
        for (int i = 0; i < n; ++i) {
            ps.print("  " + (i + 1) + "  ");
            Print.printValue(ps, f.k[i]);
            ps.print("\n");
        }
    }

    static void printLocals(Prototype f) {
        int n = f.locvars.length;
        ps.print("locals (" + n + ") for " + Print.id(f) + ":\n");
        for (int i = 0; i < n; ++i) {
            ps.println("  " + i + "  " + f.locvars[i].varname + " " + (f.locvars[i].startpc + 1) + " " + (f.locvars[i].endpc + 1));
        }
    }

    static void printUpValues(Prototype f) {
        int n = f.upvalues.length;
        ps.print("upvalues (" + n + ") for " + Print.id(f) + ":\n");
        for (int i = 0; i < n; ++i) {
            ps.print("  " + i + "  " + f.upvalues[i] + "\n");
        }
    }

    public static void print(Prototype prototype) {
        Print.printFunction(prototype, true);
    }

    public static void printFunction(Prototype prototype, boolean full) {
        int n = prototype.p.length;
        Print.printHeader(prototype);
        Print.printCode(prototype);
        if (full) {
            Print.printConstants(prototype);
            Print.printLocals(prototype);
            Print.printUpValues(prototype);
        }
        for (int i = 0; i < n; ++i) {
            Print.printFunction(prototype.p[i], full);
        }
    }

    private static void format(String s, int maxcols) {
        int n = s.length();
        if (n > maxcols) {
            ps.print(s.substring(0, maxcols));
        } else {
            ps.print(s);
            int i = maxcols - n;
            while (--i >= 0) {
                ps.print(' ');
            }
        }
    }

    private static String id(Prototype f) {
        return "Proto";
    }

    private void _assert(boolean b) {
        if (!b) {
            throw new NullPointerException("_assert failed");
        }
    }

    public static void printState(LuaClosure cl, int pc, LuaValue[] stack, int top, Varargs varargs) {
        PrintStream previous = ps;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ps = new PrintStream(baos);
        Print.printOpCode(cl.p, pc);
        ps.flush();
        ps.close();
        ps = previous;
        Print.format(baos.toString(), 50);
        Print.printStack(stack, top, varargs);
        ps.println();
    }

    public static void printStack(LuaValue[] stack, int top, Varargs varargs) {
        ps.print('[');
        for (int i = 0; i < stack.length; ++i) {
            LuaValue v = stack[i];
            if (v == null) {
                ps.print(STRING_FOR_NULL);
            } else {
                switch (v.type()) {
                    case 4: {
                        LuaString s = v.checkstring();
                        ps.print(s.length() < 48 ? s.tojstring() : s.substring(0, 32).tojstring() + "...+" + (s.length() - 32) + "b");
                        break;
                    }
                    case 6: {
                        ps.print(v.tojstring());
                        break;
                    }
                    case 7: {
                        Object o = v.touserdata();
                        if (o != null) {
                            String n = o.getClass().getName();
                            n = n.substring(n.lastIndexOf(46) + 1);
                            ps.print(n + ": " + Integer.toHexString(o.hashCode()));
                            break;
                        }
                        ps.print(v.toString());
                        break;
                    }
                    default: {
                        ps.print(v.tojstring());
                    }
                }
            }
            if (i + 1 == top) {
                ps.print(']');
            }
            ps.print(" | ");
        }
        ps.print(varargs);
    }
}

