/*
 * Decompiled with CFR 0.152.
 */
package emasher.modules;

import emasher.api.SideConfig;
import emasher.api.SocketModule;
import emasher.api.SocketTileAccess;
import emasher.blocks.BlockGasGeneric;
import emasher.items.Items;
import emasher.util.Config;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ModExhaust
extends SocketModule {
    public ModExhaust(int id) {
        super(id, "eng_toolbox:gasExhaust");
    }

    @Override
    public String getLocalizedName() {
        return "Exhaust";
    }

    public void getToolTip(List l) {
        l.add("Releases gas from an internal tank");
        l.add("when there are 4000 mB in the tank");
    }

    public void getIndicatorKey(List l) {
        l.add(Config.PREF_BLUE() + "Tank to output from");
        l.add(Config.PREF_RED() + "RS control circuit");
        l.add(Config.PREF_DARK_PURPLE() + "RS control latch");
    }

    @Override
    public void addRecipe() {
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack(Items.module(), 1, this.moduleID), new Object[]{"i", "b", Character.valueOf('c'), Items.circuit(), Character.valueOf('i'), Blocks.field_150411_aY, Character.valueOf('b'), new ItemStack(Items.module(), 1, 5)}));
    }

    @Override
    public boolean hasTankIndicator() {
        return true;
    }

    @Override
    public boolean hasRSIndicator() {
        return true;
    }

    @Override
    public boolean hasLatchIndicator() {
        return true;
    }

    @Override
    public void onRSInterfaceChange(SideConfig config, int index, SocketTileAccess ts, ForgeDirection side, boolean on) {
        this.tryOutputGas(config, ts, side);
    }

    @Override
    public void onRSLatchChange(SideConfig config, int index, SocketTileAccess ts, ForgeDirection side, boolean on) {
        this.tryOutputGas(config, ts, side);
    }

    @Override
    public void onAdjChangeSide(SocketTileAccess ts, SideConfig config, ForgeDirection side) {
        this.tryOutputGas(config, ts, side);
    }

    @Override
    public void onTankChange(SideConfig config, int index, SocketTileAccess ts, ForgeDirection side, boolean add) {
        this.tryOutputGas(config, ts, side);
    }

    private void tryOutputGas(SideConfig config, SocketTileAccess ts, ForgeDirection side) {
        boolean canOutput = true;
        for (int i = 0; i < 3; ++i) {
            if (config.rsControl[i] && ts.getRSControl(i)) {
                canOutput = false;
            }
            if (!config.rsLatch[i] || !ts.getRSLatch(i)) continue;
            canOutput = false;
        }
        if (canOutput && config.tank >= 0 && config.tank < 3) {
            Fluid fl;
            Block b;
            FluidStack f;
            int xo = ts.field_145851_c + side.offsetX;
            int yo = ts.field_145848_d + side.offsetY;
            int zo = ts.field_145849_e + side.offsetZ;
            if (ts.func_145831_w().func_147437_c(xo, yo, zo) && (f = ts.getFluidInTank(config.tank)) != null && f.amount >= 4000 && (b = (fl = f.getFluid()).getBlock()) != null && b instanceof BlockGasGeneric) {
                ts.func_145831_w().func_147449_b(xo, yo, zo, b);
                ts.drainInternal(config.tank, 4000, true);
            }
        }
    }
}

