/*
 * Decompiled with CFR 0.152.
 */
package am2.entities;

import am2.AMCore;
import am2.api.math.AMLineSegment;
import am2.api.math.AMVector3;
import am2.api.spell.component.interfaces.ISpellModifier;
import am2.api.spell.enums.SpellModifiers;
import am2.buffs.BuffEffectFrostSlowed;
import am2.damage.DamageSources;
import am2.entities.EntityDummyCaster;
import am2.particles.AMParticle;
import am2.particles.AMParticleIcons;
import am2.particles.ParticleFleePoint;
import am2.particles.ParticleFloatUpward;
import am2.particles.ParticleOrbitPoint;
import am2.spell.SpellHelper;
import am2.spell.SpellUtils;
import am2.spell.modifiers.Colour;
import am2.utility.DummyEntityPlayer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntitySpellEffect
extends Entity {
    private float rotation = 0.0f;
    private final float rotationSpeed;
    private int ticksToEffect = 20;
    private int maxTicksToEffect = 20;
    private int maxTicksToEffect_wall = 5;
    private int ticksToExist = 100;
    private ItemStack spellStack;
    private EntityPlayer dummycaster;
    private int casterEntityID;
    private float moveSpeed;
    private static final int WATCHER_STACK = 22;
    private static final int WATCHER_RADIUS = 23;
    private static final int WATCHER_GRAVITY = 24;
    private static final int WATCHER_TYPE = 25;
    private static final int WATCHER_ROF_IGNITE = 26;
    private static final int WATCHER_DAMAGEBONUS = 27;
    private static final int TYPE_ZONE = 0;
    private static final int TYPE_ROF = 1;
    private static final int TYPE_BLIZ = 2;
    private static final int TYPE_WALL = 3;
    private static final int TYPE_WAVE = 4;
    private boolean firstApply = true;

    public EntitySpellEffect(World par1World) {
        super(par1World);
        this.rotationSpeed = 10.0f;
        this.func_70105_a(0.25f, 0.25f);
    }

    public void SetCasterAndStack(EntityLivingBase caster, ItemStack spellScroll) {
        this.spellStack = spellScroll;
        this.dummycaster = DummyEntityPlayer.fromEntityLiving(caster);
        this.casterEntityID = caster.func_145782_y();
        if (this.spellStack != null) {
            this.field_70180_af.func_75692_b(22, (Object)this.spellStack);
        }
    }

    public void setRadius(float newRadius) {
        this.field_70180_af.func_75692_b(23, (Object)Float.valueOf(newRadius));
    }

    public void setTickRate(int newTickRate) {
        this.maxTicksToEffect = newTickRate;
    }

    public void setTicksToExist(int ticks) {
        this.ticksToExist = ticks;
    }

    public void setGravity(double gravity) {
        this.field_70180_af.func_75692_b(24, (Object)((int)Math.floor(gravity * 100.0)));
    }

    public void setDamageBonus(float damageBonus) {
        this.field_70180_af.func_75692_b(27, (Object)Float.valueOf(damageBonus));
    }

    public float getRotation() {
        return this.rotation;
    }

    public void setWall(float rotation) {
        this.func_70101_b(rotation, 0.0f);
        this.field_70180_af.func_75692_b(25, (Object)3);
    }

    public void setWave(float rotation, float speed) {
        this.func_70101_b(rotation, 0.0f);
        this.field_70180_af.func_75692_b(25, (Object)4);
        this.moveSpeed = speed;
        this.field_70138_W = 0.5f;
        this.maxTicksToEffect_wall = 1;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(23, (Object)Float.valueOf(3.0f));
        this.field_70180_af.func_75682_a(22, (Object)new ItemStack(Items.field_151153_ao));
        this.field_70180_af.func_75682_a(24, (Object)0);
        this.field_70180_af.func_75682_a(25, (Object)0);
        this.field_70180_af.func_75682_a(26, (Object)0);
        this.field_70180_af.func_75682_a(27, (Object)Float.valueOf(1.0f));
    }

    public void func_70071_h_() {
        if (this.dummycaster != null && this.dummycaster instanceof DummyEntityPlayer) {
            this.dummycaster.func_70071_h_();
        }
        switch (this.field_70180_af.func_75679_c(25)) {
            case 0: {
                this.zoneUpdate();
                break;
            }
            case 1: {
                this.rainOfFireUpdate();
                break;
            }
            case 2: {
                this.blizzardUpdate();
                break;
            }
            case 3: {
                this.wallUpdate();
                break;
            }
            case 4: {
                this.waveUpdate();
            }
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa >= this.ticksToExist) {
            this.func_70106_y();
        }
    }

    public void func_70106_y() {
        if (this.dummycaster instanceof DummyEntityPlayer) {
            this.dummycaster.func_70106_y();
        }
        super.func_70106_y();
    }

    private void zoneUpdate() {
        if (this.field_70170_p.field_72995_K && !AMCore.config.NoGFX()) {
            this.rotation += this.rotationSpeed;
            this.rotation %= 360.0f;
            double dist = this.field_70180_af.func_111145_d(23);
            double _rotation = this.rotation;
            if (this.spellStack == null) {
                this.spellStack = this.field_70180_af.func_82710_f(22);
                if (this.spellStack == null) {
                    return;
                }
            }
            int color = 0xFFFFFF;
            if (SpellUtils.instance.modifierIsPresent(SpellModifiers.COLOR, this.spellStack, 0)) {
                ISpellModifier[] mods = SpellUtils.instance.getModifiersForStage(this.spellStack, 0);
                int ordinalCount = 0;
                for (ISpellModifier mod : mods) {
                    if (!(mod instanceof Colour)) continue;
                    byte[] meta = SpellUtils.instance.getModifierMetadataFromStack(this.spellStack, mod, 0, ordinalCount++);
                    color = (int)mod.getModifier(SpellModifiers.COLOR, null, null, null, meta);
                }
            }
            if (AMCore.config.FullGFX() && this.field_70173_aa % 2 == 0 || this.field_70173_aa % 8 == 0) {
                for (int i = 0; i < 4; ++i) {
                    _rotation = (this.rotation + (float)(90 * i)) % 360.0f;
                    double x = this.field_70165_t - Math.cos(0.01745 * _rotation) * dist;
                    double z = this.field_70161_v - Math.sin(0.01745 * _rotation) * dist;
                    AMParticle effect = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(this.field_70170_p, AMParticleIcons.instance.getParticleForAffinity(SpellUtils.instance.mainAffinityFor(this.spellStack)), x, this.field_70163_u, z));
                    if (effect == null) continue;
                    effect.setIgnoreMaxAge(false);
                    effect.setMaxAge(20);
                    effect.setParticleScale(0.15f);
                    effect.setRGBColorI(color);
                    effect.AddParticleController(new ParticleFloatUpward(effect, 0.0f, 0.07f, 1, false));
                    if (!AMCore.config.LowGFX()) continue;
                    effect.AddParticleController(new ParticleOrbitPoint(effect, this.field_70165_t, this.field_70163_u, this.field_70161_v, 2, false).setIgnoreYCoordinate(true).SetOrbitSpeed(0.05f).SetTargetDistance(dist).setRotateDirection(true));
                }
            }
        }
        this.func_70091_d(0.0, (float)this.field_70180_af.func_75679_c(24) / 100.0f, 0.0);
        --this.ticksToEffect;
        if (this.spellStack == null) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
            return;
        }
        if (this.dummycaster == null) {
            this.dummycaster = DummyEntityPlayer.fromEntityLiving((EntityLivingBase)new EntityDummyCaster(this.field_70170_p));
        }
        if (this.ticksToEffect <= 0) {
            this.ticksToEffect = this.maxTicksToEffect;
            float radius = this.field_70180_af.func_111145_d(23);
            List possibleTargets = this.field_70170_p.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)(this.field_70165_t - (double)radius), (double)(this.field_70163_u - 1.0), (double)(this.field_70161_v - (double)radius), (double)(this.field_70165_t + (double)radius), (double)(this.field_70163_u + 3.0), (double)(this.field_70161_v + (double)radius)));
            for (Entity e : possibleTargets) {
                if (e instanceof EntityDragonPart && ((EntityDragonPart)e).field_70259_a instanceof EntityLivingBase) {
                    e = (EntityLivingBase)((EntityDragonPart)e).field_70259_a;
                }
                if (!(e instanceof EntityLivingBase)) continue;
                SpellHelper.instance.applyStageToEntity(this.spellStack, (EntityLivingBase)this.dummycaster, this.field_70170_p, e, 0, false);
            }
            if (this.field_70180_af.func_75679_c(24) < 0 && !this.firstApply) {
                SpellHelper.instance.applyStackStage(this.spellStack, (EntityLivingBase)this.dummycaster, null, this.field_70165_t, this.field_70163_u - 1.0, this.field_70161_v, 0, this.field_70170_p, false, false, this.field_70173_aa);
            } else {
                SpellHelper.instance.applyStackStage(this.spellStack, (EntityLivingBase)this.dummycaster, null, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0, this.field_70170_p, false, false, this.field_70173_aa);
            }
            this.firstApply = false;
        }
    }

    private void rainOfFireUpdate() {
        float radius = this.field_70180_af.func_111145_d(23);
        if (this.field_70170_p.field_72995_K) {
            if (this.spellStack == null) {
                this.spellStack = this.field_70180_af.func_82710_f(22);
                if (this.spellStack == null) {
                    return;
                }
            }
            int color = 0xFFFFFF;
            if (SpellUtils.instance.modifierIsPresent(SpellModifiers.COLOR, this.spellStack, 0)) {
                ISpellModifier[] mods = SpellUtils.instance.getModifiersForStage(this.spellStack, 0);
                int ordinalCount = 0;
                for (ISpellModifier mod : mods) {
                    if (!(mod instanceof Colour)) continue;
                    byte[] meta = SpellUtils.instance.getModifierMetadataFromStack(this.spellStack, mod, 0, ordinalCount++);
                    color = (int)mod.getModifier(SpellModifiers.COLOR, null, null, null, meta);
                }
            }
            for (int i = 0; i < 10; ++i) {
                double z;
                double y;
                double x = this.field_70165_t - (double)radius + this.field_70146_Z.nextDouble() * (double)radius * 2.0;
                AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(this.field_70170_p, "explosion_2", x, y = this.field_70163_u + 10.0, z = this.field_70161_v - (double)radius + this.field_70146_Z.nextDouble() * (double)radius * 2.0));
                if (particle == null) continue;
                particle.setMaxAge(20);
                particle.func_70024_g(this.field_70146_Z.nextDouble() * (double)0.2f, 0.0, this.field_70146_Z.nextDouble() * (double)0.2f);
                particle.setAffectedByGravity();
                particle.setDontRequireControllers();
                particle.setRGBColorI(color);
                particle.field_70145_X = false;
            }
        } else {
            int pZ;
            int pY;
            int pX;
            List possibleTargets = this.field_70170_p.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(this.field_70165_t - (double)radius), (double)(this.field_70163_u - 1.0), (double)(this.field_70161_v - (double)radius), (double)(this.field_70165_t + (double)radius), (double)(this.field_70163_u + 3.0), (double)(this.field_70161_v + (double)radius)));
            for (Entity e : possibleTargets) {
                if (e == this.dummycaster) continue;
                if (e instanceof EntityDragonPart && ((EntityDragonPart)e).field_70259_a instanceof EntityLivingBase) {
                    e = (EntityLivingBase)((EntityDragonPart)e).field_70259_a;
                }
                double lastVelX = e.field_70159_w;
                double lastVelY = e.field_70181_x;
                double lastVelZ = e.field_70179_y;
                float damage = 0.75f * this.field_70180_af.func_111145_d(27);
                if (SpellHelper.instance.attackTargetSpecial(null, e, (DamageSource)DamageSources.causeEntityFireDamage((EntityLivingBase)this.dummycaster), damage) && !(e instanceof EntityPlayer)) {
                    e.field_70172_ad = 10;
                }
                e.func_70024_g(-(e.field_70159_w - lastVelX), -(e.field_70181_x - lastVelY), -(e.field_70179_y - lastVelZ));
            }
            if (this.field_70180_af.func_75683_a(26) == 1 && this.field_70146_Z.nextInt(10) < 2 && this.field_70170_p.func_147437_c(pX = (int)(this.field_70165_t - (double)radius + (double)this.field_70146_Z.nextInt((int)Math.ceil(radius) * 2)), pY = (int)this.field_70163_u, pZ = (int)(this.field_70161_v - (double)radius + (double)this.field_70146_Z.nextInt((int)Math.ceil(radius) * 2)))) {
                this.field_70170_p.func_147449_b(pX, pY, pZ, (Block)Blocks.field_150480_ab);
            }
        }
    }

    private void blizzardUpdate() {
        float radius = this.field_70180_af.func_111145_d(23);
        if (this.field_70170_p.field_72995_K) {
            if (this.spellStack == null) {
                this.spellStack = this.field_70180_af.func_82710_f(22);
                if (this.spellStack == null) {
                    return;
                }
            }
            int color = 0xFFFFFF;
            if (SpellUtils.instance.modifierIsPresent(SpellModifiers.COLOR, this.spellStack, 0)) {
                ISpellModifier[] mods = SpellUtils.instance.getModifiersForStage(this.spellStack, 0);
                int ordinalCount = 0;
                for (ISpellModifier mod : mods) {
                    if (!(mod instanceof Colour)) continue;
                    byte[] meta = SpellUtils.instance.getModifierMetadataFromStack(this.spellStack, mod, 0, ordinalCount++);
                    color = (int)mod.getModifier(SpellModifiers.COLOR, null, null, null, meta);
                }
            }
            for (int i = 0; i < 20; ++i) {
                double z;
                double y;
                double x = this.field_70165_t - (double)radius + this.field_70146_Z.nextDouble() * (double)radius * 2.0;
                AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(this.field_70170_p, "snowflakes", x, y = this.field_70163_u + 10.0, z = this.field_70161_v - (double)radius + this.field_70146_Z.nextDouble() * (double)radius * 2.0));
                if (particle == null) continue;
                particle.setMaxAge(20);
                particle.setParticleScale(0.1f);
                particle.func_70024_g(this.field_70146_Z.nextDouble() * (double)0.2f - (double)0.1f, 0.0, this.field_70146_Z.nextDouble() * (double)0.2f - (double)0.1f);
                particle.setAffectedByGravity();
                particle.setRGBColorI(color);
                particle.setDontRequireControllers();
                particle.field_70145_X = false;
            }
            double x = this.field_70165_t - (double)radius + this.field_70146_Z.nextDouble() * (double)radius * 2.0;
            double z = this.field_70161_v - (double)radius + this.field_70146_Z.nextDouble() * (double)radius * 2.0;
            double y = this.field_70163_u + this.field_70146_Z.nextDouble();
            AMParticle particle = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(this.field_70170_p, "smoke", x, y, z));
            if (particle != null) {
                particle.setParticleScale(2.0f);
                particle.setMaxAge(20);
                particle.setRGBColorF(0.5098f, 0.7843f, 0.7843f);
                particle.SetParticleAlpha(0.6f);
                particle.AddParticleController(new ParticleFleePoint(particle, new AMVector3(x, y, z), 0.1f, 3.0, 1, false));
            }
        } else {
            int pZ;
            int pY;
            int pX;
            List possibleTargets = this.field_70170_p.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(this.field_70165_t - (double)radius), (double)(this.field_70163_u - 1.0), (double)(this.field_70161_v - (double)radius), (double)(this.field_70165_t + (double)radius), (double)(this.field_70163_u + 3.0), (double)(this.field_70161_v + (double)radius)));
            for (Entity e : possibleTargets) {
                if (e == this.dummycaster) continue;
                if (e instanceof EntityDragonPart && ((EntityDragonPart)e).field_70259_a instanceof EntityLivingBase) {
                    e = (EntityLivingBase)((EntityDragonPart)e).field_70259_a;
                }
                if (e instanceof EntityLivingBase) {
                    ((EntityLivingBase)e).func_70690_d((PotionEffect)new BuffEffectFrostSlowed(80, 3));
                }
                float damage = 1.0f * this.field_70180_af.func_111145_d(27);
                double lastVelX = e.field_70159_w;
                double lastVelY = e.field_70181_x;
                double lastVelZ = e.field_70179_y;
                if (SpellHelper.instance.attackTargetSpecial(null, e, (DamageSource)DamageSources.causeEntityFrostDamage((EntityLivingBase)this.dummycaster), damage) && !(e instanceof EntityPlayer)) {
                    e.field_70172_ad = 15;
                }
                e.func_70024_g(-(e.field_70159_w - lastVelX), -(e.field_70181_x - lastVelY), -(e.field_70179_y - lastVelZ));
            }
            if (this.field_70146_Z.nextInt(10) < 2 && this.field_70170_p.func_147437_c(pX = (int)(this.field_70165_t - (double)radius + (double)this.field_70146_Z.nextInt((int)Math.ceil(radius) * 2)), pY = (int)this.field_70163_u + this.field_70146_Z.nextInt(2), pZ = (int)(this.field_70161_v - (double)radius + (double)this.field_70146_Z.nextInt((int)Math.ceil(radius) * 2))) && !this.field_70170_p.func_147437_c(pX, pY - 1, pZ) && this.field_70170_p.func_147439_a(pX, pY, pZ).func_149662_c()) {
                this.field_70170_p.func_147449_b(pX, pY, pZ, Blocks.field_150433_aE);
            }
        }
    }

    private void wallUpdate() {
        block17: {
            block16: {
                if (!this.field_70170_p.field_72995_K) break block16;
                if (this.spellStack == null) {
                    this.spellStack = this.field_70180_af.func_82710_f(22);
                    if (this.spellStack == null) {
                        return;
                    }
                }
                double dist = this.field_70180_af.func_111145_d(23);
                int color = 0xFFFFFF;
                if (SpellUtils.instance.modifierIsPresent(SpellModifiers.COLOR, this.spellStack, 0)) {
                    ISpellModifier[] mods = SpellUtils.instance.getModifiersForStage(this.spellStack, 0);
                    int ordinalCount = 0;
                    for (ISpellModifier mod : mods) {
                        if (!(mod instanceof Colour)) continue;
                        byte[] meta = SpellUtils.instance.getModifierMetadataFromStack(this.spellStack, mod, 0, ordinalCount++);
                        color = (int)mod.getModifier(SpellModifiers.COLOR, null, null, null, meta);
                    }
                }
                double px = Math.cos(0.01745 * (double)(this.field_70177_z + 90.0f)) * (double)0.1f;
                double pz = Math.sin(0.01745 * (double)(this.field_70177_z + 90.0f)) * (double)0.1f;
                double py = 0.1f;
                float i = 0.0f;
                while ((double)i < dist) {
                    double x = this.field_70165_t - Math.cos(0.01745 * (double)this.field_70177_z) * (double)i;
                    double z = this.field_70161_v - Math.sin(0.01745 * (double)this.field_70177_z) * (double)i;
                    AMParticle effect = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(this.field_70170_p, AMParticleIcons.instance.getParticleForAffinity(SpellUtils.instance.mainAffinityFor(this.spellStack)), x, this.field_70163_u, z));
                    if (effect != null) {
                        effect.setIgnoreMaxAge(false);
                        effect.setMaxAge(20);
                        effect.addRandomOffset(1.0, 1.0, 1.0);
                        effect.setParticleScale(0.15f);
                        effect.setRGBColorI(color);
                        if (this.field_70180_af.func_75679_c(25) == 3) {
                            effect.AddParticleController(new ParticleFloatUpward(effect, 0.0f, 0.07f, 1, false));
                        } else {
                            effect.setAffectedByGravity();
                            effect.setDontRequireControllers();
                            effect.func_70024_g(px, py, pz);
                        }
                    }
                    x = this.field_70165_t - Math.cos(Math.toRadians(this.field_70177_z)) * (double)(-i);
                    z = this.field_70161_v - Math.sin(Math.toRadians(this.field_70177_z)) * (double)(-i);
                    effect = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(this.field_70170_p, AMParticleIcons.instance.getParticleForAffinity(SpellUtils.instance.mainAffinityFor(this.spellStack)), x, this.field_70163_u, z));
                    if (effect != null) {
                        effect.setIgnoreMaxAge(false);
                        effect.addRandomOffset(1.0, 1.0, 1.0);
                        effect.setMaxAge(20);
                        effect.setParticleScale(0.15f);
                        effect.setRGBColorI(color);
                        if (this.field_70180_af.func_75679_c(25) == 3) {
                            effect.AddParticleController(new ParticleFloatUpward(effect, 0.0f, 0.07f, 1, false));
                        } else {
                            effect.setAffectedByGravity();
                            effect.setDontRequireControllers();
                            effect.func_70024_g(px, py, pz);
                        }
                    }
                    i += 0.5f;
                }
                break block17;
            }
            --this.ticksToEffect;
            if (this.spellStack == null) {
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70106_y();
                }
                return;
            }
            if (this.dummycaster == null) {
                this.dummycaster = DummyEntityPlayer.fromEntityLiving((EntityLivingBase)new EntityDummyCaster(this.field_70170_p));
            }
            if (this.ticksToEffect > 0) break block17;
            this.ticksToEffect = this.maxTicksToEffect_wall;
            float radius = this.field_70180_af.func_111145_d(23);
            List possibleTargets = this.field_70170_p.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)(this.field_70165_t - (double)radius), (double)(this.field_70163_u - 1.0), (double)(this.field_70161_v - (double)radius), (double)(this.field_70165_t + (double)radius), (double)(this.field_70163_u + 3.0), (double)(this.field_70161_v + (double)radius)));
            ItemStack newStack = SpellUtils.instance.popStackStage(this.spellStack);
            for (Entity e : possibleTargets) {
                if (e == this || e == this.dummycaster || e.func_145782_y() == this.casterEntityID) continue;
                if (e instanceof EntityDragonPart && ((EntityDragonPart)e).field_70259_a instanceof EntityLivingBase) {
                    e = (EntityLivingBase)((EntityDragonPart)e).field_70259_a;
                }
                AMVector3 target = new AMVector3(e);
                double dirX = Math.cos(0.01745 * (double)this.field_70177_z);
                double dirZ = Math.sin(0.01745 * (double)this.field_70177_z);
                AMVector3 a = new AMVector3(this.field_70165_t - dirX * (double)radius, this.field_70163_u, this.field_70161_v - dirZ * (double)radius);
                AMVector3 b = new AMVector3(this.field_70165_t - dirX * (double)(-radius), this.field_70163_u, this.field_70161_v - dirZ * (double)(-radius));
                AMVector3 closest = new AMLineSegment(a, b).closestPointOnLine(target);
                closest.y = 0.0f;
                target.y = 0.0f;
                double hDistance = closest.distanceTo(target);
                double vDistance = Math.abs(this.field_70163_u - e.field_70163_u);
                if (!(e instanceof EntityLivingBase) || !(hDistance < 0.75) || !(vDistance < 2.0)) continue;
                SpellHelper.instance.applyStackStage(this.spellStack, (EntityLivingBase)this.dummycaster, (EntityLivingBase)e, this.field_70165_t, this.field_70163_u, this.field_70161_v, 0, this.field_70170_p, false, false, 0);
            }
        }
    }

    private void waveUpdate() {
        AMVector3[] vecs;
        this.ticksToEffect = 0;
        this.wallUpdate();
        double dx = Math.cos(Math.toRadians(this.field_70177_z + 90.0f));
        double dz = Math.sin(Math.toRadians(this.field_70177_z + 90.0f));
        this.func_70091_d(dx * (double)this.moveSpeed, 0.0, dz * (double)this.moveSpeed);
        double dxH = Math.cos(Math.toRadians(this.field_70177_z));
        double dzH = Math.sin(Math.toRadians(this.field_70177_z));
        float radius = this.field_70180_af.func_111145_d(23);
        AMVector3 a = new AMVector3(this.field_70165_t + dx - dxH * (double)radius, this.field_70163_u, this.field_70161_v + dz - dzH * (double)radius);
        AMVector3 b = new AMVector3(this.field_70165_t + dx - dxH * (double)(-radius), this.field_70163_u, this.field_70161_v + dz - dzH * (double)(-radius));
        if (this.dummycaster == null) {
            this.dummycaster = DummyEntityPlayer.fromEntityLiving((EntityLivingBase)new EntityDummyCaster(this.field_70170_p));
        }
        for (AMVector3 vec : vecs = this.getAllBlockLocationsBetween(a, b)) {
            SpellHelper.instance.applyStageToGround(this.spellStack, (EntityLivingBase)this.dummycaster, this.field_70170_p, (int)vec.x, (int)vec.y, (int)vec.z, 0, (double)vec.x + 0.5, (double)vec.y + 0.5, (double)vec.z + 0.5, 0, false);
        }
    }

    private AMVector3[] getAllBlockLocationsBetween(AMVector3 a, AMVector3 b) {
        a.floorToI();
        b.floorToI();
        double stepX = a.x < b.x ? (double)0.2f : (double)-0.2f;
        double stepZ = a.z < b.z ? (double)0.2f : (double)-0.2f;
        ArrayList<AMVector3> vecList = new ArrayList<AMVector3>();
        AMVector3 curPos = new AMVector3(a.x, a.y, a.z);
        int i = 0;
        while ((float)i < this.field_70131_O) {
            vecList.add(new AMVector3(curPos.x, curPos.y + (float)i, curPos.z));
            ++i;
        }
        while (stepX != 0.0 || stepZ != 0.0) {
            if (stepX < 0.0 && curPos.x <= b.x || stepX > 0.0 && curPos.x >= b.x) {
                stepX = 0.0;
            }
            if (stepZ < 0.0 && curPos.z <= b.z || stepZ > 0.0 && curPos.z >= b.z) {
                stepZ = 0.0;
            }
            curPos = new AMVector3((double)curPos.x + stepX, curPos.y, (double)curPos.z + stepZ);
            AMVector3 tempPos = curPos.copy();
            tempPos.roundToI();
            if (vecList.contains(tempPos)) continue;
            int i2 = 0;
            while ((float)i2 < this.field_70131_O) {
                vecList.add(new AMVector3(tempPos.x, tempPos.y + (float)i2, tempPos.z));
                ++i2;
            }
        }
        return vecList.toArray(new AMVector3[vecList.size()]);
    }

    protected void func_70069_a(float par1) {
    }

    public void func_70030_z() {
    }

    protected void func_70037_a(NBTTagCompound var1) {
    }

    protected void func_70014_b(NBTTagCompound var1) {
    }

    public void setRainOfFire(boolean ignite) {
        this.field_70180_af.func_75692_b(25, (Object)1);
        if (ignite) {
            this.field_70180_af.func_75692_b(26, (Object)1);
        }
    }

    public void setBlizzard() {
        this.field_70180_af.func_75692_b(25, (Object)2);
    }

    public boolean isBlizzard() {
        return this.field_70180_af.func_75679_c(25) == 2;
    }

    public boolean isRainOfFire() {
        return this.field_70180_af.func_75679_c(25) == 1;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }
}

