/*
 * Decompiled with CFR 0.152.
 */
package am2.blocks.tileentities;

import am2.AMCore;
import am2.api.blocks.IKeystoneLockable;
import am2.api.power.PowerTypes;
import am2.blocks.tileentities.TileEntityAMPower;
import am2.items.ISpellFocus;
import am2.network.AMDataWriter;
import am2.particles.AMParticle;
import am2.particles.ParticleFadeOut;
import am2.particles.ParticleHoldPosition;
import am2.particles.ParticleOrbitPoint;
import am2.power.PowerNodeRegistry;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.DamageSource;

public class TileEntityAstralBarrier
extends TileEntityAMPower
implements IInventory,
IKeystoneLockable {
    private ItemStack[] inventory = new ItemStack[this.func_70302_i_()];
    private static final int maxRadius = 20;
    private static final int minRadius = 5;
    private boolean displayAura = false;
    private int particleTickCounter = 0;
    public static int keystoneSlot = 0;

    public TileEntityAstralBarrier() {
        super(250);
    }

    public void ToggleAuraDisplay() {
        this.displayAura = !this.displayAura;
    }

    public int getRadius() {
        if (this.inventory[0] != null && this.inventory[0].func_77973_b() instanceof ISpellFocus) {
            ISpellFocus focus = (ISpellFocus)this.inventory[0].func_77973_b();
            return (focus.getFocusLevel() + 1) * 5;
        }
        return 0;
    }

    public boolean IsActive() {
        return PowerNodeRegistry.For(this.field_145850_b).checkPower(this, 0.35f * (float)this.getRadius()) && this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e) && this.getRadius() > 0;
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_145841_b(compound);
        S35PacketUpdateTileEntity packet = new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e), compound);
        return packet;
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        int radius = this.getRadius();
        if (this.IsActive()) {
            PowerNodeRegistry.For(this.field_145850_b).consumePower(this, PowerNodeRegistry.For(this.field_145850_b).getHighestPowerType(this), 0.35f * (float)radius);
        }
        if (this.field_145850_b.field_72995_K && this.IsActive()) {
            if (this.displayAura) {
                AMParticle effect = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(this.field_145850_b, "symbols", this.field_145851_c, (double)this.field_145848_d + 0.5, this.field_145849_e));
                if (effect != null) {
                    effect.setIgnoreMaxAge(false);
                    effect.setMaxAge(100);
                    effect.setParticleScale(0.5f);
                    effect.AddParticleController(new ParticleOrbitPoint(effect, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 1, false).SetOrbitSpeed(0.03).SetTargetDistance(radius));
                }
            }
            ++this.particleTickCounter;
            if (this.particleTickCounter >= 15) {
                this.particleTickCounter = 0;
                String particleName = "";
                AMParticle effect = (AMParticle)((Object)AMCore.proxy.particleManager.spawn(this.field_145850_b, "sparkle", (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.1 + this.field_145850_b.field_73012_v.nextDouble() * 0.5, (double)this.field_145849_e + 0.5));
                if (effect != null) {
                    effect.setIgnoreMaxAge(false);
                    effect.setMaxAge(100);
                    effect.setParticleScale(0.5f);
                    float color = this.field_145850_b.field_73012_v.nextFloat() * 0.2f + 0.8f;
                    effect.AddParticleController(new ParticleOrbitPoint(effect, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 1, false).SetOrbitSpeed(0.005).SetTargetDistance(this.field_145850_b.field_73012_v.nextDouble() * 0.6 - 0.3));
                    effect.AddParticleController(new ParticleHoldPosition(effect, 80, 2, true));
                    effect.AddParticleController(new ParticleFadeOut(effect, 3, false).setFadeSpeed(0.05f));
                }
            }
        }
    }

    public void onEntityBlocked(EntityLivingBase entity) {
        if (this.field_145850_b.field_72995_K && PowerNodeRegistry.For(this.func_145831_w()).checkPower(this, PowerTypes.DARK, 50.0f)) {
            entity.func_70097_a(DamageSource.field_76376_m, 5.0f);
            PowerNodeRegistry.For(this.func_145831_w()).consumePower(this, PowerTypes.DARK, 50.0f);
        }
    }

    public int func_70302_i_() {
        return 4;
    }

    public ItemStack func_70301_a(int slot) {
        if (slot >= this.inventory.length) {
            return null;
        }
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.inventory[i] != null) {
            if (this.inventory[i].field_77994_a <= j) {
                ItemStack itemstack = this.inventory[i];
                this.inventory[i] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.inventory[i].func_77979_a(j);
            if (this.inventory[i].field_77994_a == 0) {
                this.inventory[i] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        if (this.inventory[i] != null) {
            ItemStack itemstack = this.inventory[i];
            this.inventory[i] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "Astral Barrier";
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return entityplayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("AstralBarrierInventory", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            String tag = String.format("ArrayIndex", i);
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte byte0 = nbttagcompound1.func_74771_c(tag);
            if (byte0 < 0 || byte0 >= this.inventory.length) continue;
            this.inventory[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            String tag = String.format("ArrayIndex", i);
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a(tag, (byte)i);
            this.inventory[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("AstralBarrierInventory", (NBTBase)nbttaglist);
    }

    @Override
    public boolean canProvidePower(PowerTypes type) {
        return false;
    }

    private void writeInventory(AMDataWriter writer) {
        for (ItemStack stack : this.inventory) {
            if (stack == null) {
                writer.add(false);
                continue;
            }
            writer.add(true);
            writer.add(stack);
        }
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    @Override
    public int getChargeRate() {
        return 50;
    }

    @Override
    public boolean canRelayPower(PowerTypes type) {
        return false;
    }

    @Override
    public ItemStack[] getRunesInKey() {
        ItemStack[] runes = new ItemStack[]{this.inventory[1], this.inventory[2], this.inventory[3]};
        return runes;
    }

    @Override
    public boolean keystoneMustBeHeld() {
        return false;
    }

    @Override
    public boolean keystoneMustBeInActionBar() {
        return false;
    }
}

