/*
 * Decompiled with CFR 0.152.
 */
package net.p455w0rd.wirelesscraftingterminal.common.container;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.implementations.guiobjects.IGuiItemObject;
import appeng.api.networking.IGrid;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.parts.IPart;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.client.me.InternalSlotME;
import appeng.client.me.SlotME;
import appeng.helpers.ICustomNameObject;
import appeng.helpers.InventoryAction;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.AdaptorPlayerHand;
import appeng.util.item.AEItemStack;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.p455w0rd.wirelesscraftingterminal.api.IWirelessCraftingTermHandler;
import net.p455w0rd.wirelesscraftingterminal.api.networking.security.WCTIActionHost;
import net.p455w0rd.wirelesscraftingterminal.api.networking.security.WCTPlayerSource;
import net.p455w0rd.wirelesscraftingterminal.common.container.ContainerOpenContext;
import net.p455w0rd.wirelesscraftingterminal.common.container.guisync.GuiSync;
import net.p455w0rd.wirelesscraftingterminal.common.container.guisync.SyncData;
import net.p455w0rd.wirelesscraftingterminal.common.container.slot.AppEngSlot;
import net.p455w0rd.wirelesscraftingterminal.common.container.slot.SlotCraftingMatrix;
import net.p455w0rd.wirelesscraftingterminal.common.container.slot.SlotCraftingTerm;
import net.p455w0rd.wirelesscraftingterminal.common.container.slot.SlotDisabled;
import net.p455w0rd.wirelesscraftingterminal.common.container.slot.SlotFake;
import net.p455w0rd.wirelesscraftingterminal.common.container.slot.SlotInaccessible;
import net.p455w0rd.wirelesscraftingterminal.common.container.slot.SlotPlayerHotBar;
import net.p455w0rd.wirelesscraftingterminal.common.container.slot.SlotPlayerInv;
import net.p455w0rd.wirelesscraftingterminal.common.utils.RandomUtils;
import net.p455w0rd.wirelesscraftingterminal.common.utils.WCTLog;
import net.p455w0rd.wirelesscraftingterminal.core.sync.network.NetworkHandler;
import net.p455w0rd.wirelesscraftingterminal.core.sync.packets.PacketInventoryAction;
import net.p455w0rd.wirelesscraftingterminal.core.sync.packets.PacketPartialItem;
import net.p455w0rd.wirelesscraftingterminal.core.sync.packets.PacketValueConfig;
import net.p455w0rd.wirelesscraftingterminal.helpers.WirelessTerminalGuiObject;

public abstract class WCTBaseContainer
extends Container {
    private final InventoryPlayer invPlayer;
    private final BaseActionSource mySrc;
    private final HashSet<Integer> locked = new HashSet();
    private final TileEntity tileEntity;
    private final IPart part;
    private final IGuiItemObject obj;
    public final WirelessTerminalGuiObject obj2;
    private final List<PacketPartialItem> dataChunks = new LinkedList<PacketPartialItem>();
    private final HashMap<Integer, SyncData> syncData = new HashMap();
    private boolean isContainerValid = true;
    private String customName;
    private ContainerOpenContext openContext;
    private IMEInventoryHandler<IAEItemStack> cellInv;
    private IEnergySource powerSrc;
    private boolean sentCustomName;
    private int ticksSinceCheck = 900;
    private IAEItemStack clientRequestedTargetItem = null;

    public WCTBaseContainer(InventoryPlayer ip, TileEntity myTile, IPart myPart) {
        this(ip, myTile, myPart, null);
    }

    public WCTBaseContainer(InventoryPlayer ip, TileEntity myTile, IPart myPart, IGuiItemObject gio) {
        this.invPlayer = ip;
        this.tileEntity = myTile;
        this.part = myPart;
        this.obj = gio;
        EntityPlayer player = ip.field_70458_d;
        this.obj2 = this.getGuiObject(RandomUtils.getWirelessTerm(ip), player, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        this.mySrc = new WCTPlayerSource(ip.field_70458_d, this.getActionHost());
        this.prepareSync();
    }

    protected WirelessTerminalGuiObject getGuiObject(ItemStack it, EntityPlayer player, World w, int x, int y, int z) {
        IWirelessCraftingTermHandler wh;
        if (it != null && (wh = (IWirelessCraftingTermHandler)AEApi.instance().registries().wireless().getWirelessTerminalHandler(it)) != null) {
            return new WirelessTerminalGuiObject(wh, it, player, w, x, y, z);
        }
        return null;
    }

    protected WCTIActionHost getActionHost() {
        if (this.obj instanceof WCTIActionHost) {
            return (WCTIActionHost)this.obj;
        }
        if (this.tileEntity instanceof WCTIActionHost) {
            return (WCTIActionHost)this.tileEntity;
        }
        if (this.part instanceof WCTIActionHost) {
            return (WCTIActionHost)this.part;
        }
        return null;
    }

    private void prepareSync() {
        for (Field f : ((Object)((Object)this)).getClass().getFields()) {
            if (!f.isAnnotationPresent(GuiSync.class)) continue;
            GuiSync annotation = f.getAnnotation(GuiSync.class);
            if (this.syncData.containsKey(annotation.value())) {
                WCTLog.warning("Channel already in use: " + annotation.value() + " for " + f.getName(), new Object[0]);
                continue;
            }
            this.syncData.put(annotation.value(), new SyncData(this, f, annotation));
        }
    }

    public WCTBaseContainer(InventoryPlayer ip, Object anchor) {
        this.invPlayer = ip;
        this.tileEntity = anchor instanceof TileEntity ? (TileEntity)anchor : null;
        this.part = anchor instanceof IPart ? (IPart)anchor : null;
        this.obj = anchor instanceof IGuiItemObject ? (IGuiItemObject)anchor : null;
        EntityPlayer player = ip.field_70458_d;
        this.obj2 = this.getGuiObject(RandomUtils.getWirelessTerm(ip), player, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        if (this.tileEntity == null && this.part == null && this.obj == null) {
            throw new IllegalArgumentException("Must have a valid anchor, instead " + anchor + " in " + ip);
        }
        this.mySrc = new WCTPlayerSource(ip.field_70458_d, this.getActionHost());
        this.prepareSync();
    }

    public void postPartial(PacketPartialItem packetPartialItem) {
        this.dataChunks.add(packetPartialItem);
        if (packetPartialItem.getPageCount() == this.dataChunks.size()) {
            this.parsePartials();
        }
    }

    private void parsePartials() {
        int total = 0;
        for (PacketPartialItem ppi : this.dataChunks) {
            total += ppi.getSize();
        }
        byte[] buffer = new byte[total];
        int cursor = 0;
        for (PacketPartialItem ppi : this.dataChunks) {
            cursor = ppi.write(buffer, cursor);
        }
        try {
            NBTTagCompound data = CompressedStreamTools.func_74796_a((InputStream)new ByteArrayInputStream(buffer));
            if (data != null) {
                this.setTargetStack(AEApi.instance().storage().createItemStack(ItemStack.func_77949_a((NBTTagCompound)data)));
            }
        }
        catch (IOException e) {
            WCTLog.debug(e.getMessage(), new Object[0]);
        }
        this.dataChunks.clear();
    }

    public IAEItemStack getTargetStack() {
        return this.clientRequestedTargetItem;
    }

    public void setTargetStack(IAEItemStack stack) {
        if (Platform.isClient()) {
            ItemStack b;
            ItemStack a = stack == null ? null : stack.getItemStack();
            ItemStack itemStack = b = this.clientRequestedTargetItem == null ? null : this.clientRequestedTargetItem.getItemStack();
            if (Platform.isSameItemPrecise((ItemStack)a, (ItemStack)b)) {
                return;
            }
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            NBTTagCompound item = new NBTTagCompound();
            if (stack != null) {
                stack.writeToNBT(item);
            }
            try {
                CompressedStreamTools.func_74799_a((NBTTagCompound)item, (OutputStream)stream);
                int maxChunkSize = 30000;
                LinkedList<byte[]> miniPackets = new LinkedList<byte[]>();
                byte[] data = stream.toByteArray();
                ByteArrayInputStream bis = new ByteArrayInputStream(data, 0, stream.size());
                while (bis.available() > 0) {
                    int nextBLock = bis.available() > 30000 ? 30000 : bis.available();
                    byte[] nextSegment = new byte[nextBLock];
                    bis.read(nextSegment);
                    miniPackets.add(nextSegment);
                }
                bis.close();
                stream.close();
                int page = 0;
                for (byte[] packet : miniPackets) {
                    PacketPartialItem ppi = new PacketPartialItem(page, miniPackets.size(), packet);
                    ++page;
                    NetworkHandler.instance.sendToServer(ppi);
                }
            }
            catch (IOException e) {
                WCTLog.debug(e.getMessage(), new Object[0]);
                return;
            }
        }
        this.clientRequestedTargetItem = stack == null ? null : stack.copy();
    }

    public BaseActionSource getActionSource() {
        return this.mySrc;
    }

    public void verifyPermissions(SecurityPermissions security, boolean requirePower) {
        if (Platform.isClient()) {
            return;
        }
        ++this.ticksSinceCheck;
        if (this.ticksSinceCheck < 20) {
            return;
        }
        this.ticksSinceCheck = 0;
        this.setValidContainer(this.isValidContainer() && this.hasAccess(security, requirePower));
    }

    protected boolean hasAccess(SecurityPermissions perm, boolean requirePower) {
        IEnergyGrid eg;
        IGrid grid = this.obj2.getTargetGrid();
        if (grid != null && !(eg = (IEnergyGrid)grid.getCache(IEnergyGrid.class)).isNetworkPowered()) {
            return false;
        }
        ISecurityGrid sg = (ISecurityGrid)grid.getCache(ISecurityGrid.class);
        return sg.hasPermission(this.getInventoryPlayer().field_70458_d, perm);
    }

    public void lockPlayerInventorySlot(int idx) {
        this.locked.add(idx);
    }

    public Object getTarget() {
        if (this.tileEntity != null) {
            return this.tileEntity;
        }
        if (this.part != null) {
            return this.part;
        }
        if (this.obj != null) {
            return this.obj;
        }
        return null;
    }

    public InventoryPlayer getPlayerInv() {
        return this.getInventoryPlayer();
    }

    public TileEntity getTileEntity() {
        return this.tileEntity;
    }

    public final void updateFullProgressBar(int idx, long value) {
        if (this.syncData.containsKey(idx)) {
            this.syncData.get(idx).update(value);
            return;
        }
        this.func_75137_b(idx, (int)value);
    }

    public void stringSync(int idx, String value) {
        if (this.syncData.containsKey(idx)) {
            this.syncData.get(idx).update(value);
        }
    }

    protected void bindPlayerInventory(InventoryPlayer inventoryPlayer, int offsetX, int offsetY) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                if (this.locked.contains(j + i * 9 + 9)) {
                    this.func_75146_a(new SlotDisabled((IInventory)inventoryPlayer, j + i * 9 + 9, 8 + j * 18 + offsetX, offsetY + i * 18));
                    continue;
                }
                this.func_75146_a(new SlotPlayerInv((IInventory)inventoryPlayer, j + i * 9 + 9, 8 + j * 18 + offsetX, offsetY + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            if (this.locked.contains(i)) {
                this.func_75146_a(new SlotDisabled((IInventory)inventoryPlayer, i, 8 + i * 18 + offsetX, 58 + offsetY));
                continue;
            }
            this.func_75146_a(new SlotPlayerHotBar((IInventory)inventoryPlayer, i, 8 + i * 18 + offsetX, 58 + offsetY));
        }
    }

    protected Slot func_75146_a(Slot newSlot) {
        if (newSlot instanceof AppEngSlot) {
            AppEngSlot s = (AppEngSlot)newSlot;
            s.setContainer(this);
            return super.func_75146_a(newSlot);
        }
        throw new IllegalArgumentException("Invalid Slot [" + newSlot + "]for AE Container instead of AppEngSlot.");
    }

    public void func_75142_b() {
        this.sendCustomName();
        if (Platform.isServer()) {
            for (Object crafter : this.field_75149_d) {
                ICrafting icrafting = (ICrafting)crafter;
                for (SyncData sd : this.syncData.values()) {
                    sd.tick(icrafting);
                }
            }
        }
        super.func_75142_b();
    }

    public ItemStack func_82846_b(EntityPlayer p, int idx) {
        if (Platform.isClient()) {
            return null;
        }
        boolean hasMETiles = false;
        for (Object is : this.field_75151_b) {
            if (!(is instanceof InternalSlotME)) continue;
            hasMETiles = true;
            break;
        }
        if (hasMETiles && Platform.isClient()) {
            return null;
        }
        AppEngSlot clickSlot = (AppEngSlot)((Object)this.field_75151_b.get(idx));
        if (clickSlot instanceof SlotDisabled || clickSlot instanceof SlotInaccessible) {
            return null;
        }
        if (clickSlot != null && clickSlot.func_75216_d()) {
            AppEngSlot cs;
            ItemStack tis = clickSlot.func_75211_c();
            if (tis == null) {
                return null;
            }
            ArrayList<AppEngSlot> selectedSlots = new ArrayList<AppEngSlot>();
            if (clickSlot.isPlayerSide()) {
                tis = this.shiftStoreItem(tis);
                for (Object e : this.field_75151_b) {
                    cs = (AppEngSlot)((Object)e);
                    if (cs.isPlayerSide() || cs instanceof SlotFake || cs instanceof SlotCraftingMatrix || !cs.func_75214_a(tis)) continue;
                    selectedSlots.add(cs);
                }
            } else {
                for (Object e : this.field_75151_b) {
                    cs = (AppEngSlot)((Object)e);
                    if (!cs.isPlayerSide() || cs instanceof SlotFake || cs instanceof SlotCraftingMatrix || !cs.func_75214_a(tis)) continue;
                    selectedSlots.add(cs);
                }
            }
            if (selectedSlots.isEmpty() && clickSlot.isPlayerSide() && tis != null) {
                for (Object e : this.field_75151_b) {
                    cs = (AppEngSlot)((Object)e);
                    ItemStack destination = cs.func_75211_c();
                    if (cs.isPlayerSide() || !(cs instanceof SlotFake)) continue;
                    if (Platform.isSameItemPrecise((ItemStack)destination, (ItemStack)tis)) {
                        return null;
                    }
                    if (destination != null) continue;
                    cs.func_75215_d(tis.func_77946_l());
                    cs.func_75218_e();
                    this.updateSlot(cs);
                    return null;
                }
            }
            if (tis != null) {
                int placeAble;
                for (Slot slot : selectedSlots) {
                    ItemStack t;
                    if (slot instanceof SlotDisabled || slot instanceof SlotME || !slot.func_75214_a(tis) || !slot.func_75216_d() || !Platform.isSameItemPrecise((ItemStack)tis, (ItemStack)(t = slot.func_75211_c()))) continue;
                    int maxSize = t.func_77976_d();
                    if (maxSize > slot.func_75219_a()) {
                        maxSize = slot.func_75219_a();
                    }
                    if (tis.field_77994_a < (placeAble = maxSize - t.field_77994_a)) {
                        placeAble = tis.field_77994_a;
                    }
                    t.field_77994_a += placeAble;
                    tis.field_77994_a -= placeAble;
                    if (tis.field_77994_a <= 0) {
                        clickSlot.func_75215_d(null);
                        slot.func_75218_e();
                        this.updateSlot(clickSlot);
                        this.updateSlot(slot);
                        return null;
                    }
                    this.updateSlot(slot);
                }
                for (Slot slot : selectedSlots) {
                    if (slot instanceof SlotDisabled || slot instanceof SlotME || !slot.func_75214_a(tis)) continue;
                    if (slot.func_75216_d()) {
                        ItemStack t = slot.func_75211_c();
                        if (!Platform.isSameItemPrecise((ItemStack)t, (ItemStack)tis)) continue;
                        int maxSize = t.func_77976_d();
                        if (slot.func_75219_a() < maxSize) {
                            maxSize = slot.func_75219_a();
                        }
                        if (tis.field_77994_a < (placeAble = maxSize - t.field_77994_a)) {
                            placeAble = tis.field_77994_a;
                        }
                        t.field_77994_a += placeAble;
                        tis.field_77994_a -= placeAble;
                        if (tis.field_77994_a <= 0) {
                            clickSlot.func_75215_d(null);
                            slot.func_75218_e();
                            this.updateSlot(clickSlot);
                            this.updateSlot(slot);
                            return null;
                        }
                        this.updateSlot(slot);
                        continue;
                    }
                    int maxSize = tis.func_77976_d();
                    if (maxSize > slot.func_75219_a()) {
                        maxSize = slot.func_75219_a();
                    }
                    ItemStack tmp = tis.func_77946_l();
                    if (tmp.field_77994_a > maxSize) {
                        tmp.field_77994_a = maxSize;
                    }
                    tis.field_77994_a -= tmp.field_77994_a;
                    slot.func_75215_d(tmp);
                    if (tis.field_77994_a <= 0) {
                        clickSlot.func_75215_d(null);
                        slot.func_75218_e();
                        this.updateSlot(clickSlot);
                        this.updateSlot(slot);
                        return null;
                    }
                    this.updateSlot(slot);
                }
            }
            clickSlot.func_75215_d(tis != null ? tis.func_77946_l() : null);
        }
        this.updateSlot(clickSlot);
        return null;
    }

    public final void func_75137_b(int idx, int value) {
        if (this.syncData.containsKey(idx)) {
            this.syncData.get(idx).update(value);
        }
    }

    public boolean func_75145_c(EntityPlayer entityplayer) {
        if (this.isValidContainer()) {
            if (this.tileEntity instanceof IInventory) {
                return ((IInventory)this.tileEntity).func_70300_a(entityplayer);
            }
            return true;
        }
        return false;
    }

    public boolean func_94531_b(Slot s) {
        return ((AppEngSlot)s).isDraggable();
    }

    public void doAction(EntityPlayerMP player, InventoryAction action, int slot, long id) {
        if (slot >= 0 && slot < this.field_75151_b.size()) {
            Slot s = this.func_75139_a(slot);
            if (s instanceof SlotCraftingTerm) {
                switch (action) {
                    case CRAFT_SHIFT: 
                    case CRAFT_ITEM: 
                    case CRAFT_STACK: {
                        ((SlotCraftingTerm)s).doClick(action, (EntityPlayer)player);
                        this.updateHeld(player);
                    }
                }
            }
            if (s instanceof SlotFake) {
                ItemStack hand = player.field_71071_by.func_70445_o();
                switch (action) {
                    case PICKUP_OR_SET_DOWN: {
                        if (hand == null) {
                            s.func_75215_d(null);
                            break;
                        }
                        s.func_75215_d(hand.func_77946_l());
                        break;
                    }
                    case PLACE_SINGLE: {
                        if (hand == null) break;
                        ItemStack is = hand.func_77946_l();
                        is.field_77994_a = 1;
                        s.func_75215_d(is);
                        break;
                    }
                    case SPLIT_OR_PLACE_SINGLE: {
                        ItemStack is = s.func_75211_c();
                        if (is != null) {
                            if (hand == null) {
                                --is.field_77994_a;
                            } else if (hand.func_77969_a(is)) {
                                is.field_77994_a = Math.min(is.func_77976_d(), is.field_77994_a + 1);
                            } else {
                                is = hand.func_77946_l();
                                is.field_77994_a = 1;
                            }
                            s.func_75215_d(is);
                            break;
                        }
                        if (hand == null) break;
                        is = hand.func_77946_l();
                        is.field_77994_a = 1;
                        s.func_75215_d(is);
                        break;
                    }
                }
            }
            if (action == InventoryAction.MOVE_REGION) {
                LinkedList<Slot> from = new LinkedList<Slot>();
                for (Object j : this.field_75151_b) {
                    if (!(j instanceof Slot) || j.getClass() != s.getClass()) continue;
                    from.add((Slot)j);
                }
                for (Slot fr : from) {
                    this.func_82846_b((EntityPlayer)player, fr.field_75222_d);
                }
            }
            return;
        }
        IAEItemStack slotItem = this.clientRequestedTargetItem;
        switch (action) {
            case SHIFT_CLICK: {
                if (this.getPowerSource() == null || this.getCellInventory() == null) {
                    return;
                }
                if (slotItem == null) break;
                IAEItemStack ais = slotItem.copy();
                ItemStack myItem = ais.getItemStack();
                ais.setStackSize((long)myItem.func_77976_d());
                InventoryAdaptor adp = InventoryAdaptor.getAdaptor((Object)player, (ForgeDirection)ForgeDirection.UNKNOWN);
                myItem.field_77994_a = (int)ais.getStackSize();
                myItem = adp.simulateAdd(myItem);
                if (myItem != null) {
                    ais.setStackSize(ais.getStackSize() - (long)myItem.field_77994_a);
                }
                if ((ais = (IAEItemStack)Platform.poweredExtraction((IEnergySource)this.getPowerSource(), this.getCellInventory(), (IAEStack)ais, (BaseActionSource)this.getActionSource())) == null) break;
                adp.addItems(ais.getItemStack());
                break;
            }
            case ROLL_DOWN: {
                if (this.getPowerSource() == null || this.getCellInventory() == null) {
                    return;
                }
                boolean releaseQty = true;
                ItemStack isg = player.field_71071_by.func_70445_o();
                if (isg == null) break;
                IAEItemStack ais = AEApi.instance().storage().createItemStack(isg);
                ais.setStackSize(1L);
                IAEItemStack extracted = ais.copy();
                ais = (IAEItemStack)Platform.poweredInsert((IEnergySource)this.getPowerSource(), this.getCellInventory(), (IAEStack)ais, (BaseActionSource)this.getActionSource());
                if (ais != null) break;
                AdaptorPlayerHand ia = new AdaptorPlayerHand((EntityPlayer)player);
                ItemStack fail = ia.removeItems(1, extracted.getItemStack(), null);
                if (fail == null) {
                    this.getCellInventory().extractItems((IAEStack)extracted, Actionable.MODULATE, this.getActionSource());
                }
                this.updateHeld(player);
                break;
            }
            case ROLL_UP: 
            case PICKUP_SINGLE: {
                if (this.getPowerSource() == null || this.getCellInventory() == null) {
                    return;
                }
                if (slotItem == null) break;
                int liftQty = 1;
                ItemStack item = player.field_71071_by.func_70445_o();
                if (item != null) {
                    if (item.field_77994_a >= item.func_77976_d()) {
                        liftQty = 0;
                    }
                    if (!Platform.isSameItemPrecise((ItemStack)slotItem.getItemStack(), (ItemStack)item)) {
                        liftQty = 0;
                    }
                }
                if (liftQty <= 0) break;
                IAEItemStack ais = slotItem.copy();
                ais.setStackSize(1L);
                ais = (IAEItemStack)Platform.poweredExtraction((IEnergySource)this.getPowerSource(), this.getCellInventory(), (IAEStack)ais, (BaseActionSource)this.getActionSource());
                if (ais == null) break;
                AdaptorPlayerHand ia = new AdaptorPlayerHand((EntityPlayer)player);
                ItemStack fail = ia.addItems(ais.getItemStack());
                if (fail != null) {
                    this.getCellInventory().injectItems((IAEStack)ais, Actionable.MODULATE, this.getActionSource());
                }
                this.updateHeld(player);
                break;
            }
            case PICKUP_OR_SET_DOWN: {
                if (this.getPowerSource() == null || this.getCellInventory() == null) {
                    return;
                }
                if (player.field_71071_by.func_70445_o() == null) {
                    if (slotItem == null) break;
                    IAEItemStack ais = slotItem.copy();
                    ais.setStackSize((long)ais.getItemStack().func_77976_d());
                    ais = (IAEItemStack)Platform.poweredExtraction((IEnergySource)this.getPowerSource(), this.getCellInventory(), (IAEStack)ais, (BaseActionSource)this.getActionSource());
                    if (ais != null) {
                        player.field_71071_by.func_70437_b(ais.getItemStack());
                    } else {
                        player.field_71071_by.func_70437_b(null);
                    }
                    this.updateHeld(player);
                    break;
                }
                IAEItemStack ais = AEApi.instance().storage().createItemStack(player.field_71071_by.func_70445_o());
                ais = (IAEItemStack)Platform.poweredInsert((IEnergySource)this.getPowerSource(), this.getCellInventory(), (IAEStack)ais, (BaseActionSource)this.getActionSource());
                if (ais != null) {
                    player.field_71071_by.func_70437_b(ais.getItemStack());
                } else {
                    player.field_71071_by.func_70437_b(null);
                }
                this.updateHeld(player);
                break;
            }
            case SPLIT_OR_PLACE_SINGLE: {
                if (this.getPowerSource() == null || this.getCellInventory() == null) {
                    return;
                }
                if (player.field_71071_by.func_70445_o() == null) {
                    if (slotItem == null) break;
                    IAEItemStack ais = slotItem.copy();
                    long maxSize = ais.getItemStack().func_77976_d();
                    ais.setStackSize(maxSize);
                    ais = (IAEItemStack)this.getCellInventory().extractItems((IAEStack)ais, Actionable.SIMULATE, this.getActionSource());
                    if (ais != null) {
                        long stackSize = Math.min(maxSize, ais.getStackSize());
                        ais.setStackSize(stackSize + 1L >> 1);
                        ais = (IAEItemStack)Platform.poweredExtraction((IEnergySource)this.getPowerSource(), this.getCellInventory(), (IAEStack)ais, (BaseActionSource)this.getActionSource());
                    }
                    if (ais != null) {
                        player.field_71071_by.func_70437_b(ais.getItemStack());
                    } else {
                        player.field_71071_by.func_70437_b(null);
                    }
                    this.updateHeld(player);
                    break;
                }
                IAEItemStack ais = AEApi.instance().storage().createItemStack(player.field_71071_by.func_70445_o());
                ais.setStackSize(1L);
                ais = (IAEItemStack)Platform.poweredInsert((IEnergySource)this.getPowerSource(), this.getCellInventory(), (IAEStack)ais, (BaseActionSource)this.getActionSource());
                if (ais != null) break;
                ItemStack is = player.field_71071_by.func_70445_o();
                --is.field_77994_a;
                if (is.field_77994_a <= 0) {
                    player.field_71071_by.func_70437_b(null);
                }
                this.updateHeld(player);
                break;
            }
            case CREATIVE_DUPLICATE: {
                if (!player.field_71075_bZ.field_75098_d || slotItem == null) break;
                ItemStack is = slotItem.getItemStack();
                is.field_77994_a = is.func_77976_d();
                player.field_71071_by.func_70437_b(is);
                this.updateHeld(player);
                break;
            }
            case MOVE_REGION: {
                if (this.getPowerSource() == null || this.getCellInventory() == null) {
                    return;
                }
                if (slotItem == null) break;
                int playerInv = 36;
                for (int slotNum = 0; slotNum < 36; ++slotNum) {
                    IAEItemStack ais = slotItem.copy();
                    ItemStack myItem = ais.getItemStack();
                    ais.setStackSize((long)myItem.func_77976_d());
                    InventoryAdaptor adp = InventoryAdaptor.getAdaptor((Object)player, (ForgeDirection)ForgeDirection.UNKNOWN);
                    myItem.field_77994_a = (int)ais.getStackSize();
                    myItem = adp.simulateAdd(myItem);
                    if (myItem != null) {
                        ais.setStackSize(ais.getStackSize() - (long)myItem.field_77994_a);
                    }
                    if ((ais = (IAEItemStack)Platform.poweredExtraction((IEnergySource)this.getPowerSource(), this.getCellInventory(), (IAEStack)ais, (BaseActionSource)this.getActionSource())) == null) {
                        return;
                    }
                    adp.addItems(ais.getItemStack());
                }
                break;
            }
        }
    }

    protected void updateHeld(EntityPlayerMP p) {
        if (Platform.isServer()) {
            try {
                NetworkHandler.instance.sendTo(new PacketInventoryAction(InventoryAction.UPDATE_HAND, 0, (IAEItemStack)AEItemStack.create((ItemStack)p.field_71071_by.func_70445_o())), p);
            }
            catch (IOException e) {
                WCTLog.debug(e.getMessage(), new Object[0]);
            }
        }
    }

    private ItemStack shiftStoreItem(ItemStack input) {
        if (this.getPowerSource() == null || this.getCellInventory() == null) {
            return input;
        }
        IAEItemStack ais = (IAEItemStack)Platform.poweredInsert((IEnergySource)this.getPowerSource(), this.getCellInventory(), (IAEStack)AEApi.instance().storage().createItemStack(input), (BaseActionSource)this.getActionSource());
        if (ais == null) {
            return null;
        }
        return ais.getItemStack();
    }

    private void updateSlot(Slot clickSlot) {
        this.func_75142_b();
    }

    private void sendCustomName() {
        if (!this.sentCustomName) {
            this.sentCustomName = true;
            if (Platform.isServer()) {
                ICustomNameObject name = null;
                if (this.part instanceof ICustomNameObject) {
                    name = (ICustomNameObject)this.part;
                }
                if (this.tileEntity instanceof ICustomNameObject) {
                    name = (ICustomNameObject)this.tileEntity;
                }
                if (this.obj instanceof ICustomNameObject) {
                    name = (ICustomNameObject)this.obj;
                }
                if (this instanceof ICustomNameObject) {
                    name = (ICustomNameObject)this;
                }
                if (name != null) {
                    if (name.hasCustomName()) {
                        this.setCustomName(name.getCustomName());
                    }
                    if (this.getCustomName() != null) {
                        try {
                            NetworkHandler.instance.sendTo(new PacketValueConfig("CustomName", this.getCustomName()), (EntityPlayerMP)this.getInventoryPlayer().field_70458_d);
                        }
                        catch (IOException e) {
                            WCTLog.debug(e.getMessage(), new Object[0]);
                        }
                    }
                }
            }
        }
    }

    public void swapSlotContents(int slotA, int slotB) {
        ItemStack testB;
        Slot a = this.func_75139_a(slotA);
        Slot b = this.func_75139_a(slotB);
        if (a == null || b == null) {
            return;
        }
        ItemStack isA = a.func_75211_c();
        ItemStack isB = b.func_75211_c();
        if (isA == null && isB == null) {
            return;
        }
        if (isA != null && !a.func_82869_a(this.getInventoryPlayer().field_70458_d)) {
            return;
        }
        if (isB != null && !b.func_82869_a(this.getInventoryPlayer().field_70458_d)) {
            return;
        }
        if (isB != null && !a.func_75214_a(isB)) {
            return;
        }
        if (isA != null && !b.func_75214_a(isA)) {
            return;
        }
        ItemStack testA = isB == null ? null : isB.func_77946_l();
        ItemStack itemStack = testB = isA == null ? null : isA.func_77946_l();
        if (testA != null && testA.field_77994_a > a.func_75219_a()) {
            if (testB != null) {
                return;
            }
            int totalA = testA.field_77994_a;
            testA.field_77994_a = a.func_75219_a();
            testB = testA.func_77946_l();
            testB.field_77994_a = totalA - testA.field_77994_a;
        }
        if (testB != null && testB.field_77994_a > b.func_75219_a()) {
            if (testA != null) {
                return;
            }
            int totalB = testB.field_77994_a;
            testB.field_77994_a = b.func_75219_a();
            testA = testB.func_77946_l();
            testA.field_77994_a = totalB - testA.field_77994_a;
        }
        a.func_75215_d(testA);
        b.func_75215_d(testB);
    }

    public void onUpdate(String field, Object oldValue, Object newValue) {
    }

    public void onSlotChange(Slot s) {
    }

    public boolean isValidForSlot(Slot s, ItemStack i) {
        return true;
    }

    public IMEInventoryHandler<IAEItemStack> getCellInventory() {
        return this.cellInv;
    }

    public void setCellInventory(IMEInventoryHandler<IAEItemStack> cellInv) {
        this.cellInv = cellInv;
    }

    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public InventoryPlayer getInventoryPlayer() {
        return this.invPlayer;
    }

    public boolean isValidContainer() {
        return this.isContainerValid;
    }

    public void setValidContainer(boolean isContainerValid) {
        this.isContainerValid = isContainerValid;
    }

    public ContainerOpenContext getOpenContext() {
        return this.openContext;
    }

    public void setOpenContext(ContainerOpenContext openContext) {
        this.openContext = openContext;
    }

    public IEnergySource getPowerSource() {
        return this.powerSrc;
    }

    public void setPowerSource(IEnergySource powerSrc) {
        this.powerSrc = powerSrc;
    }
}

