/*
 * Decompiled with CFR 0.152.
 */
package net.p455w0rd.wirelesscraftingterminal.common.container;

import appeng.api.AEApi;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.CraftingItemList;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.helpers.ICustomNameObject;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import appeng.util.Platform;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.p455w0rd.wirelesscraftingterminal.api.IWirelessCraftingTermHandler;
import net.p455w0rd.wirelesscraftingterminal.common.container.WCTBaseContainer;
import net.p455w0rd.wirelesscraftingterminal.common.container.guisync.GuiSync;
import net.p455w0rd.wirelesscraftingterminal.common.utils.RandomUtils;
import net.p455w0rd.wirelesscraftingterminal.common.utils.WCTLog;
import net.p455w0rd.wirelesscraftingterminal.core.sync.network.NetworkHandler;
import net.p455w0rd.wirelesscraftingterminal.core.sync.packets.PacketMEInventoryUpdate;
import net.p455w0rd.wirelesscraftingterminal.core.sync.packets.PacketValueConfig;
import net.p455w0rd.wirelesscraftingterminal.helpers.WirelessTerminalGuiObject;

public class ContainerCraftingCPU
extends WCTBaseContainer
implements IMEMonitorHandlerReceiver<IAEItemStack>,
ICustomNameObject {
    private final IItemList<IAEItemStack> list = AEApi.instance().storage().createItemList();
    private CraftingCPUCluster monitor = null;
    private String cpuName = null;
    private final WirelessTerminalGuiObject obj;
    @GuiSync(value=0)
    public long eta = -1L;

    public ContainerCraftingCPU(InventoryPlayer ip, Object te) {
        super(ip, te);
        this.obj = this.getGuiObject(RandomUtils.getWirelessTerm(ip), ip.field_70458_d, ip.field_70458_d.field_70170_p, (int)ip.field_70458_d.field_70165_t, (int)ip.field_70458_d.field_70163_u, (int)ip.field_70458_d.field_70161_v);
        if (this.obj == null) {
            this.setValidContainer(false);
        }
    }

    @Override
    protected WirelessTerminalGuiObject getGuiObject(ItemStack it, EntityPlayer player, World w, int x, int y, int z) {
        IWirelessCraftingTermHandler wh;
        if (it != null && (wh = (IWirelessCraftingTermHandler)AEApi.instance().registries().wireless().getWirelessTerminalHandler(it)) != null) {
            return new WirelessTerminalGuiObject(wh, it, player, w, x, y, z);
        }
        return null;
    }

    protected void setCPU(ICraftingCPU c) {
        if (c == this.getMonitor()) {
            return;
        }
        if (this.getMonitor() != null) {
            this.getMonitor().removeListener((IMEMonitorHandlerReceiver)this);
        }
        for (Object g : this.field_75149_d) {
            if (!(g instanceof EntityPlayer)) continue;
            try {
                NetworkHandler.instance.sendTo(new PacketValueConfig("CraftingStatus", "Clear"), (EntityPlayerMP)g);
            }
            catch (IOException e) {
                WCTLog.debug(e.getMessage(), new Object[0]);
            }
        }
        if (c instanceof CraftingCPUCluster) {
            this.cpuName = c.getName();
            this.setMonitor((CraftingCPUCluster)c);
            this.list.resetStatus();
            this.getMonitor().getListOfItem(this.list, CraftingItemList.ALL);
            this.getMonitor().addListener((IMEMonitorHandlerReceiver)this, null);
            this.setEstimatedTime(0L);
        } else {
            this.setMonitor(null);
            this.cpuName = "";
            this.setEstimatedTime(-1L);
        }
    }

    public void cancelCrafting() {
        if (this.getMonitor() != null) {
            this.getMonitor().cancel();
        }
        this.setEstimatedTime(-1L);
    }

    public void func_82847_b(ICrafting c) {
        super.func_82847_b(c);
        if (this.field_75149_d.isEmpty() && this.getMonitor() != null) {
            this.getMonitor().removeListener((IMEMonitorHandlerReceiver)this);
        }
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (this.getMonitor() != null) {
            this.getMonitor().removeListener((IMEMonitorHandlerReceiver)this);
        }
    }

    @Override
    public void func_75142_b() {
        if (Platform.isServer() && this.getMonitor() != null && !this.list.isEmpty()) {
            try {
                if (this.getEstimatedTime() >= 0L) {
                    // empty if block
                }
                PacketMEInventoryUpdate a = new PacketMEInventoryUpdate(0);
                PacketMEInventoryUpdate b = new PacketMEInventoryUpdate(1);
                PacketMEInventoryUpdate c = new PacketMEInventoryUpdate(2);
                for (IAEItemStack out : this.list) {
                    a.appendItem(this.getMonitor().getItemStack(out, CraftingItemList.STORAGE));
                    b.appendItem(this.getMonitor().getItemStack(out, CraftingItemList.ACTIVE));
                    c.appendItem(this.getMonitor().getItemStack(out, CraftingItemList.PENDING));
                }
                this.list.resetStatus();
                for (Object g : this.field_75149_d) {
                    if (!(g instanceof EntityPlayer)) continue;
                    if (!a.isEmpty()) {
                        NetworkHandler.instance.sendTo(a, (EntityPlayerMP)g);
                    }
                    if (!b.isEmpty()) {
                        NetworkHandler.instance.sendTo(b, (EntityPlayerMP)g);
                    }
                    if (c.isEmpty()) continue;
                    NetworkHandler.instance.sendTo(c, (EntityPlayerMP)g);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.func_75142_b();
    }

    public boolean isValid(Object verificationToken) {
        return true;
    }

    public void postChange(IBaseMonitor<IAEItemStack> monitor, Iterable<IAEItemStack> change, BaseActionSource actionSource) {
        for (IAEItemStack is : change) {
            is = is.copy();
            is.setStackSize(1L);
            this.list.add((IAEStack)is);
        }
    }

    public void onListUpdate() {
    }

    @Override
    public String getCustomName() {
        return this.cpuName;
    }

    public boolean hasCustomName() {
        return this.cpuName != null && this.cpuName.length() > 0;
    }

    public long getEstimatedTime() {
        return this.eta;
    }

    private void setEstimatedTime(long eta) {
        this.eta = eta;
    }

    CraftingCPUCluster getMonitor() {
        return this.monitor;
    }

    private void setMonitor(CraftingCPUCluster monitor) {
        this.monitor = monitor;
    }

    IGrid getNetwork() {
        return this.obj.getTargetGrid();
    }
}

