/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.network.sync;

import cofh.api.energy.EnergyStorage;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.ISyncPart;

public class SyncEnergyStorage
extends EnergyStorage
implements ISyncPart {
    private String tagName = "energyStorage";
    private boolean hasChanged;

    public SyncEnergyStorage(int capacity) {
        super(capacity);
    }

    public SyncEnergyStorage(int capacity, int maxTransfer) {
        super(capacity, maxTransfer);
    }

    public SyncEnergyStorage(int capacity, int maxReceive, int maxExtract) {
        super(capacity, maxReceive, maxExtract);
    }

    @Override
    public void setEnergyStored(int energy) {
        super.setEnergyStored(energy);
        this.hasChanged = true;
    }

    @Override
    public void modifyEnergyStored(int energy) {
        super.modifyEnergyStored(energy);
        this.hasChanged = true;
    }

    @Override
    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!simulate) {
            this.hasChanged = true;
        }
        return super.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!simulate) {
            this.hasChanged = true;
        }
        return super.extractEnergy(maxExtract, simulate);
    }

    @Override
    public void writeToBuf(ByteBuf buf) {
        if (this.energy < 0) {
            this.energy = 0;
        }
        buf.writeInt(this.energy);
    }

    @Override
    public void readFromBuf(ByteBuf buf) {
        this.energy = buf.readInt();
        if (this.energy > this.capacity) {
            this.energy = this.capacity;
        }
    }

    @Override
    public final void writeToNBT(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTTagCompound energyTag = new NBTTagCompound();
        this.writeToNBT(energyTag);
        nbt.func_74782_a(this.getTagName(), (NBTBase)energyTag);
        this.hasChanged = false;
    }

    @Override
    public final void readFromNBT(NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (nbt.func_74764_b(this.getTagName())) {
            this.readFromNBT(nbt.func_74775_l(this.getTagName()));
        }
    }

    public String getTagName() {
        return this.tagName;
    }

    public SyncEnergyStorage setTagName(String tagName) {
        this.tagName = tagName;
        return this;
    }

    @Override
    public boolean canSync(NBTHelper.SyncType sync) {
        return sync.isType(NBTHelper.SyncType.SYNC, NBTHelper.SyncType.SAVE);
    }

    @Override
    public boolean equal() {
        return this.hasChanged;
    }
}

