/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.handlers.inventories;

import appeng.api.AEApi;
import appeng.api.implementations.tiles.ITileStorageMonitorable;
import appeng.api.networking.IGrid;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.me.helpers.IGridProxyable;
import cpw.mods.fml.common.Loader;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.api.ActionType;
import sonar.core.api.InventoryHandler;
import sonar.core.api.SonarAPI;
import sonar.core.api.StoredItemStack;
import sonar.core.integration.AE2Helper;

public class AE2InventoryProvider
extends InventoryHandler {
    public static String name = "AE2-Inventory";

    @Override
    public String getName() {
        return name;
    }

    @Override
    public boolean isLoadable() {
        return Loader.isModLoaded((String)"appliedenergistics2");
    }

    @Override
    public boolean canHandleItems(TileEntity tile, ForgeDirection dir) {
        return tile instanceof IGridProxyable;
    }

    @Override
    public StoredItemStack getStack(int slot, TileEntity tile, ForgeDirection dir) {
        IGridProxyable proxy = (IGridProxyable)tile;
        IGrid grid = proxy.getProxy().getNode().getGrid();
        if (grid != null) {
            IStorageGrid storage = (IStorageGrid)grid.getCache(IStorageGrid.class);
            IItemList items = storage.getItemInventory().getStorageList();
            if (items == null) {
                return null;
            }
            int current = 0;
            for (IAEItemStack item : items) {
                if (current == slot) {
                    return AE2Helper.convertAEItemStack((IAEStack)item);
                }
                ++current;
            }
        }
        return null;
    }

    @Override
    public InventoryHandler.StorageSize getItems(List<StoredItemStack> storedStacks, TileEntity tile, ForgeDirection dir) {
        long maxStorage = 0L;
        IGridProxyable proxy = (IGridProxyable)tile;
        IGrid grid = proxy.getProxy().getNode().getGrid();
        if (grid != null) {
            IStorageGrid storage = (IStorageGrid)grid.getCache(IStorageGrid.class);
            IItemList items = storage.getItemInventory().getStorageList();
            if (items == null) {
                return InventoryHandler.StorageSize.EMPTY;
            }
            for (IAEItemStack item : items) {
                SonarAPI.getItemHelper().addStackToList(storedStacks, AE2Helper.convertAEItemStack((IAEStack)item));
                maxStorage += item.getStackSize();
            }
        }
        return new InventoryHandler.StorageSize(maxStorage, maxStorage);
    }

    public IItemList<IAEItemStack> getItemList(TileEntity tile, ForgeDirection dir) {
        IStorageMonitorable monitor = ((ITileStorageMonitorable)tile).getMonitorable(dir, (BaseActionSource)new MachineSource((IActionHost)tile));
        if (monitor != null) {
            IMEMonitor stacks = monitor.getItemInventory();
            IItemList items = stacks.getAvailableItems(AEApi.instance().storage().createItemList());
            return items;
        }
        return null;
    }

    @Override
    public StoredItemStack addStack(StoredItemStack add, TileEntity tile, ForgeDirection dir, ActionType action) {
        IGridProxyable proxy = (IGridProxyable)tile;
        IGrid grid = proxy.getProxy().getNode().getGrid();
        if (grid != null) {
            IStorageGrid storage = (IStorageGrid)grid.getCache(IStorageGrid.class);
            IAEItemStack stack = (IAEItemStack)storage.getItemInventory().injectItems((IAEStack)AE2Helper.convertStoredItemStack(add), AE2Helper.getActionable(action), (BaseActionSource)new MachineSource((IActionHost)tile));
            if (stack == null || stack.getStackSize() == 0L) {
                return null;
            }
            return AE2Helper.convertAEItemStack((IAEStack)stack);
        }
        return add;
    }

    @Override
    public StoredItemStack removeStack(StoredItemStack remove, TileEntity tile, ForgeDirection dir, ActionType action) {
        IGridProxyable proxy = (IGridProxyable)tile;
        IGrid grid = proxy.getProxy().getNode().getGrid();
        if (grid != null) {
            IStorageGrid storage = (IStorageGrid)grid.getCache(IStorageGrid.class);
            StoredItemStack stack = SonarAPI.getItemHelper().getStackToAdd(remove.stored, remove, AE2Helper.convertAEItemStack(storage.getItemInventory().extractItems((IAEStack)AE2Helper.convertStoredItemStack(remove), AE2Helper.getActionable(action), (BaseActionSource)new MachineSource((IActionHost)tile))));
            if (stack == null || stack.getStackSize() == 0L) {
                return null;
            }
            return stack;
        }
        return remove;
    }
}

