/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.handlers.energy;

import cpw.mods.fml.common.Loader;
import mekanism.api.energy.IStrictEnergyAcceptor;
import mekanism.api.energy.IStrictEnergyStorage;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.api.ActionType;
import sonar.core.api.EnergyHandler;
import sonar.core.api.EnergyType;
import sonar.core.api.StoredEnergyStack;

public class MekanismProvider
extends EnergyHandler {
    public static String name = "Mekanism-Provider";

    @Override
    public String getName() {
        return name;
    }

    @Override
    public boolean canProvideEnergy(TileEntity tile, ForgeDirection dir) {
        return tile instanceof IStrictEnergyStorage;
    }

    @Override
    public void getEnergy(StoredEnergyStack energyStack, TileEntity tile, ForgeDirection dir) {
        if (tile instanceof IStrictEnergyStorage) {
            IStrictEnergyStorage storage = (IStrictEnergyStorage)tile;
            energyStack.setStorageValues((long)(storage.getEnergy() / 10.0), (long)(storage.getMaxEnergy() / 10.0));
        }
    }

    @Override
    public StoredEnergyStack addEnergy(StoredEnergyStack transfer, TileEntity tile, ForgeDirection dir, ActionType action) {
        IStrictEnergyAcceptor acceptor;
        if (tile instanceof IStrictEnergyAcceptor && (acceptor = (IStrictEnergyAcceptor)tile).canReceiveEnergy(dir)) {
            transfer.stored = (long)((double)transfer.stored - acceptor.transferEnergyToAcceptor(dir, (double)transfer.stored));
        }
        if (transfer.stored == 0L) {
            transfer = null;
        }
        return transfer;
    }

    @Override
    public StoredEnergyStack removeEnergy(StoredEnergyStack transfer, TileEntity tile, ForgeDirection dir, ActionType action) {
        if (tile instanceof IStrictEnergyStorage) {
            IStrictEnergyStorage storage = (IStrictEnergyStorage)tile;
            double maxRemove = Math.min((double)transfer.stored, storage.getEnergy());
            transfer.stored = (long)((double)transfer.stored - maxRemove);
            storage.setEnergy(storage.getEnergy() - maxRemove);
        }
        return transfer;
    }

    @Override
    public boolean isLoadable() {
        return Loader.isModLoaded((String)"Mekanism");
    }

    @Override
    public EnergyType getProvidedType() {
        return EnergyType.MJ;
    }
}

