/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.handlers.energy;

import appeng.api.config.PowerMultiplier;
import appeng.api.networking.energy.IAEPowerStorage;
import appeng.api.networking.energy.IEnergyGrid;
import cpw.mods.fml.common.Loader;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import sonar.core.api.ActionType;
import sonar.core.api.EnergyHandler;
import sonar.core.api.EnergyType;
import sonar.core.api.StoredEnergyStack;
import sonar.core.integration.AE2Helper;

public class AEProvider
extends EnergyHandler {
    public static String name = "AE-Provider";

    @Override
    public String getName() {
        return name;
    }

    @Override
    public boolean canProvideEnergy(TileEntity tile, ForgeDirection dir) {
        return tile instanceof IAEPowerStorage || tile instanceof IEnergyGrid;
    }

    @Override
    public void getEnergy(StoredEnergyStack energyStack, TileEntity tile, ForgeDirection dir) {
        if (tile instanceof IEnergyGrid) {
            IEnergyGrid grid = (IEnergyGrid)tile;
            energyStack.setUsage((long)grid.getAvgPowerUsage());
            energyStack.setStorageValues((long)grid.getStoredPower(), (long)grid.getMaxStoredPower());
        } else if (tile instanceof IAEPowerStorage) {
            IAEPowerStorage power = (IAEPowerStorage)tile;
            energyStack.setStorageValues((long)power.getAECurrentPower(), (long)power.getAEMaxPower());
        }
    }

    @Override
    public StoredEnergyStack addEnergy(StoredEnergyStack transfer, TileEntity tile, ForgeDirection dir, ActionType action) {
        if (tile instanceof IEnergyGrid) {
            IEnergyGrid grid = (IEnergyGrid)tile;
            transfer.stored = (long)grid.injectPower((double)Math.min(transfer.stored, 10000L), AE2Helper.getActionable(action));
        } else if (tile instanceof IAEPowerStorage) {
            IAEPowerStorage grid = (IAEPowerStorage)tile;
            transfer.stored = (long)grid.injectAEPower((double)Math.min(transfer.stored, 10000L), AE2Helper.getActionable(action));
        }
        if (transfer.stored == 0L) {
            transfer = null;
        }
        return transfer;
    }

    @Override
    public StoredEnergyStack removeEnergy(StoredEnergyStack transfer, TileEntity tile, ForgeDirection dir, ActionType action) {
        if (tile instanceof IEnergyGrid) {
            IEnergyGrid grid = (IEnergyGrid)tile;
            transfer.stored = (long)((double)transfer.stored - grid.extractAEPower((double)Math.min(transfer.stored, 10000L), AE2Helper.getActionable(action), PowerMultiplier.CONFIG));
        } else if (tile instanceof IAEPowerStorage) {
            IAEPowerStorage grid = (IAEPowerStorage)tile;
            transfer.stored = (long)((double)transfer.stored - grid.extractAEPower((double)Math.min(transfer.stored, 10000L), AE2Helper.getActionable(action), PowerMultiplier.CONFIG));
        }
        if (transfer.stored == 0L) {
            transfer = null;
        }
        return transfer;
    }

    @Override
    public boolean isLoadable() {
        return Loader.isModLoaded((String)"appliedenergistics2");
    }

    @Override
    public EnergyType getProvidedType() {
        return EnergyType.AE;
    }
}

