/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.entity.mob.teleport;

import chylex.hee.entity.fx.FXType;
import chylex.hee.packets.AbstractClientPacket;
import chylex.hee.packets.AbstractPacket;
import chylex.hee.packets.PacketPipeline;
import chylex.hee.packets.client.C12TeleportEntity;
import chylex.hee.packets.client.C21EffectEntity;
import chylex.hee.system.abstractions.Vec;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;

@FunctionalInterface
public interface ITeleportListener<T extends Entity> {
    public static final ITeleportListener playSound = (entity, startPos, rand) -> {
        entity.field_70170_p.func_72908_a(startPos.x, startPos.y, startPos.z, "mob.endermen.portal", 1.0f, 1.0f);
        entity.func_85030_a("mob.endermen.portal", 1.0f, 1.0f);
    };
    public static final ITeleportListener spawnParticlesPrevPos = (entity, startPos, rand) -> PacketPipeline.sendToAllAround(entity.field_71093_bK, startPos.x, startPos.y, startPos.z, 64.0, new C21EffectEntity(FXType.Entity.SIMPLE_TELEPORT_NOSOUND, startPos.x, startPos.y, startPos.z, entity.field_70130_N, entity.field_70131_O));
    public static final ITeleportListener skipRenderLerp = (entity, startPos, rand) -> PacketPipeline.sendToAllAround(entity, 128.0, (AbstractPacket)new C12TeleportEntity(entity));
    public static final ITeleportListener updatePlayerPosition = (entity, startPos, rand) -> {
        if (entity instanceof EntityPlayer) {
            ((EntityPlayer)entity).func_70634_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        }
    };

    public void onTeleport(T var1, Vec var2, Random var3);

    public static ITeleportListener sendPacket(IOnTeleportPacketProvider packet) {
        return (entity, startPos, rand) -> {
            Vec endPos = Vec.pos(entity);
            Vec middlePos = startPos.interpolated(endPos, 0.5);
            PacketPipeline.sendToAllAround(entity.field_71093_bK, middlePos.x, middlePos.y, middlePos.z, 32.0 + startPos.distance(endPos), packet.create(startPos, Vec.pos(entity)));
        };
    }

    public static interface IOnTeleportPacketProvider {
        public AbstractClientPacket create(Vec var1, Vec var2);
    }
}

