/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.ItemHandlers;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.ModInteract.DeepInteract.ReikaThaumHelper;
import Reika.DragonAPI.ModList;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import thaumcraft.api.IWarpingGear;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IEssentiaContainerItem;

public class ThaumItemHelper {
    public static boolean isTotemBlock(Block b, int meta) {
        return b == BlockEntry.TOTEM.getBlock() && meta < 2 || b == BlockEntry.TOTEMNODE.getBlock() && meta == BlockEntry.TOTEMNODE.metadata;
    }

    public static boolean isCrystalCluster(Block b) {
        return b == BlockEntry.CRYSTAL.getBlock();
    }

    public static boolean isWarpingToolOrArmor(ItemStack is) {
        return is != null && is.func_77973_b() instanceof IWarpingGear;
    }

    public static boolean isVoidMetalTool(ItemStack is) {
        return is != null && is.func_77973_b().getClass().getName().startsWith("thaumcraft.common.items.equipment.ItemVoid");
    }

    public static boolean isVoidMetalArmor(ItemStack is) {
        return is != null && is.func_77973_b().getClass().getName().startsWith("thaumcraft.common.items.armor.ItemVoid");
    }

    public static ItemStack getCrystallizedEssentia(Aspect a) {
        ItemStack is = ItemEntry.CRYSTALESSENCE.getItem();
        ((IEssentiaContainerItem)is.func_77973_b()).setAspects(is, new AspectList().add(a, 1));
        return is;
    }

    public static ItemStack getManaBean(Aspect a) {
        ItemStack is = ItemEntry.MANABEAN.getItem();
        ((IEssentiaContainerItem)is.func_77973_b()).setAspects(is, new AspectList().add(a, 1));
        return is;
    }

    public static ItemStack getWispEssence(Aspect a) {
        ItemStack is = ItemEntry.WISP.getItem();
        ((IEssentiaContainerItem)is.func_77973_b()).setAspects(is, new AspectList().add(a, 2));
        return is;
    }

    public static ItemStack getResearchNote(String key, World world, boolean complete) {
        ItemStack is = ItemEntry.RESEARCH.getItem();
        ReikaThaumHelper.programResearchNote(is, key, world);
        if (is.field_77990_d == null) {
            DragonAPICore.logError("Research '" + key + "' does not exist!");
            return null;
        }
        is.field_77990_d.func_74757_a("complete", complete);
        if (complete) {
            is.func_77964_b(64);
        }
        return is;
    }

    public static enum BlockEntry {
        TOTEM("blockCosmeticSolid", 0),
        TILE("blockCosmeticSolid", 1),
        THAUMIUM("blockCosmeticSolid", 4),
        TALLOW("blockCosmeticSolid", 5),
        ARCANESTONE("blockCosmeticSolid", 6),
        ARCANEBRICKS("blockCosmeticSolid", 7),
        ANCIENTSTONE("blockCosmeticSolid", 11),
        ANCIENTROCK("blockCosmeticSolid", 12),
        CRUSTEDSTONE("blockCosmeticSolid", 14),
        ANCIENTPEDESTAL("blockCosmeticSolid", 15),
        SHIMMER("blockCustomPlant", 2),
        CINDER("blockCustomPlant", 3),
        ETHEREAL("blockCustomPlant", 4),
        CRYSTAL("blockCrystal"),
        JAR("blockJar"),
        NODE("blockAiry", 0),
        TOTEMNODE("blockAiry", 4),
        GREATWOODPLANKS("blockWoodenDevice", 6),
        SILVERWOODPLANKS("blockWoodenDevice", 7);

        public final int metadata;
        private final String item;

        private BlockEntry(String s) {
            this(s, 0);
        }

        private BlockEntry(String s, int meta) {
            this.item = s;
            this.metadata = meta;
        }

        public Block getBlock() {
            return GameRegistry.findBlock((String)ModList.THAUMCRAFT.modLabel, (String)this.item);
        }

        public ItemStack getItem() {
            return new ItemStack(this.getBlock(), 1, this.metadata);
        }

        public boolean match(Block b, int meta) {
            return b == this.getBlock() && meta == this.metadata;
        }
    }

    public static enum ItemEntry {
        ALUMENTUM("ItemResource", 0),
        NITOR("ItemResource", 1),
        THAUMIUM("ItemResource", 2),
        TALLOW("ItemResource", 4),
        FABRIC("ItemResource", 7),
        VISFITLER("ItemResource", 8),
        FRAGMENT("ItemResource", 9),
        MIRROR("ItemResource", 10),
        GOO("ItemResource", 11),
        TENDRIL("ItemResource", 12),
        LABEL("ItemResource", 13),
        SALIS("ItemResource", 14),
        CHARM("ItemResource", 15),
        VOIDMETAL("ItemResource", 16),
        VOIDSEED("ItemResource", 17),
        PRIMALFOCUS("FocusPrimal"),
        SALTS("ItemBathSalts"),
        ELDRITCHEYE("ItemEldritchObject"),
        BALANCED("ItemShard", 6),
        PHIAL("ItemEssence", 0),
        CRYSTALESSENCE("ItemCrystalEssence", 0),
        NUGGETCLUSTER("ItemNugget", 0),
        LOOTBAG1("ItemLootBag", 0),
        LOOTBAG2("ItemLootBag", 1),
        LOOTBAG3("ItemLootBag", 2),
        MANABEAN("ItemManaBean"),
        ZOMBIEBRAIN("ItemZombieBrain"),
        WISP("ItemWispEssence"),
        RESEARCH("ItemResearchNotes");

        public final int metadata;
        private final String item;

        private ItemEntry(String s) {
            this(s, 0);
        }

        private ItemEntry(String s, int meta) {
            this.item = s;
            this.metadata = meta;
        }

        public ItemStack getItem() {
            Item is = GameRegistry.findItem((String)ModList.THAUMCRAFT.modLabel, (String)this.item);
            return new ItemStack(is, 1, this.metadata);
        }
    }
}

