/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.ItemHandlers;

import Reika.DragonAPI.Base.CropHandlerBase;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.ModList;
import java.lang.reflect.Field;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class IC2RubberLogHandler
extends CropHandlerBase {
    private static final IC2RubberLogHandler instance = new IC2RubberLogHandler();
    private final Block logBlock;
    private final ItemStack resin;

    private IC2RubberLogHandler() {
        if (!ModList.IC2.isLoaded()) {
            this.logBlock = null;
            this.resin = null;
            return;
        }
        this.logBlock = this.getFieldBlock("rubberWood");
        this.resin = this.getField("resin");
    }

    private Block getFieldBlock(String s) {
        ItemStack is = this.getField(s);
        return is != null ? Block.func_149634_a((Item)is.func_77973_b()) : null;
    }

    private ItemStack getField(String s) {
        try {
            Class c = ModList.IC2.getItemClass();
            Field f = c.getDeclaredField(s);
            f.setAccessible(true);
            return (ItemStack)f.get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            DragonAPICore.logError("Exception for reading " + this.getMod() + "!");
            this.logFailure(e);
            return null;
        }
    }

    public static IC2RubberLogHandler getInstance() {
        return instance;
    }

    @Override
    public int getHarvestedMeta(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return meta + 6;
    }

    @Override
    public boolean isCrop(Block id, int meta) {
        return id == this.logBlock && this.isValidMeta(meta);
    }

    private boolean isValidMeta(int meta) {
        return meta % 6 >= 2;
    }

    @Override
    public boolean isRipeCrop(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        return this.isValidMeta(meta) && meta < 6;
    }

    @Override
    public void makeRipe(World world, int x, int y, int z) {
        world.func_72921_c(x, y, z, world.func_72805_g(x, y, z) % 6, 3);
    }

    @Override
    public int getGrowthState(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (!this.isValidMeta(meta)) {
            return -1;
        }
        return meta < 6 ? 0 : 1;
    }

    @Override
    public boolean isSeedItem(ItemStack is) {
        return false;
    }

    @Override
    public ArrayList<ItemStack> getDropsOverride(World world, int x, int y, int z, Block id, int meta, int fortune) {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        li.add(ReikaItemHelper.getSizedItemStack(this.resin, 1 + world.field_73012_v.nextInt(3)));
        return li;
    }

    @Override
    public ArrayList<ItemStack> getAdditionalDrops(World world, int x, int y, int z, Block id, int meta, int fortune) {
        return new ArrayList<ItemStack>();
    }

    @Override
    public boolean neverDropsSecondSeed() {
        return true;
    }

    @Override
    public boolean initializedProperly() {
        return this.resin != null && this.logBlock != null;
    }

    @Override
    public ModList getMod() {
        return ModList.IC2;
    }
}

