/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.DeepInteract;

import Reika.DragonAPI.Auxiliary.Trackers.ReflectiveFailureTracker;
import Reika.DragonAPI.Auxiliary.Trackers.TickRegistry;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.KeyedItemStack;
import Reika.DragonAPI.Instantiable.Data.Maps.ItemHashMap;
import Reika.DragonAPI.Instantiable.Data.Maps.MultiMap;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.ModList;
import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.implementations.tiles.IChestOrDrive;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IMachineSet;
import appeng.api.networking.crafting.ICraftingCallback;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.security.PlayerSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.ICellProvider;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.IReadOnlyCollection;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;

public class MESystemReader
implements IMEMonitorHandlerReceiver<IAEItemStack> {
    private static Class gridCache;
    private static Field activeCellProviders;
    private static Object tickHandlerInstance;
    private static Method getNetworks;
    private static Collection<MESystemEffect> systemEffects;
    private static final Comparator<IAEItemStack> sizeSorter;
    private final IGridNode node;
    private final BaseActionSource actionSource;
    private ICraftingRequester requester = null;
    private final IdentityHashMap<Future<ICraftingJob>, CraftCompleteCallback> crafting = new IdentityHashMap();
    private final MultiMap<CraftCompleteCallback, ICraftingLink> craftingLinks = new MultiMap().setNullEmpty();
    private final MultiMap<KeyedItemStack, ChangeCallback> changeCallbacks = new MultiMap();
    private Object monitorToken = new Object();
    public final boolean isEmpty;

    public MESystemReader(IGridNode ign, EntityPlayer ep) {
        this(ign, new PlayerSource(ep, null));
    }

    public MESystemReader(IGridNode ign, IActionHost iah) {
        this(ign, new MachineSource(iah));
    }

    public MESystemReader(IGridNode ign, MESystemReader reader) {
        this(ign, reader.actionSource);
        this.crafting.putAll(reader.crafting);
        this.craftingLinks.putAll(reader.craftingLinks);
        this.requester = reader.requester;
    }

    private MESystemReader(IGridNode ign, BaseActionSource src) {
        this.node = ign;
        this.actionSource = src;
        IReadOnlyCollection<IGridNode> nodes = ign.getGrid().getNodes();
        Iterator iterator = nodes.iterator();
        this.isEmpty = !iterator.hasNext() || iterator.next() == this.node && nodes.size() == 1;
    }

    public MESystemReader setRequester(ICraftingRequester icr) {
        this.requester = icr;
        return this;
    }

    public MESystemReader addCallback(ItemStack is, ChangeCallback call) {
        this.changeCallbacks.addValue(new KeyedItemStack(is).setSimpleHash(true).setIgnoreNBT(true), call);
        this.getStorage().addListener(this, this.monitorToken);
        return this;
    }

    public void clearCallbacks() {
        this.changeCallbacks.clear();
    }

    private IMEMonitor<IAEItemStack> getStorage() {
        if (this.node == null || this.node.getGrid() == null) {
            return null;
        }
        return ((IStorageGrid)this.node.getGrid().getCache(IStorageGrid.class)).getItemInventory();
    }

    private ICraftingGrid getCraftingGrid() {
        if (this.node == null || this.node.getGrid() == null) {
            return null;
        }
        return (ICraftingGrid)this.node.getGrid().getCache(ICraftingGrid.class);
    }

    public ItemHashMap<Long> getMESystemContents() {
        ItemHashMap<Long> map = new ItemHashMap().enableNBT();
        if (this.node == null || this.node.getGrid() == null || this.getStorage() == null) {
            return map;
        }
        for (IAEItemStack iae : this.getStorage().getStorageList()) {
            if (!iae.isItem() || !iae.isMeaningful()) continue;
            map.put(iae.getItemStack(), (Long)iae.getStackSize());
        }
        return map;
    }

    public Collection<ItemStack> getRawMESystemContents() {
        ArrayList<ItemStack> c = new ArrayList<ItemStack>();
        if (this.node == null || this.node.getGrid() == null || this.getStorage() == null) {
            return c;
        }
        for (IAEItemStack iae : this.getStorage().getStorageList()) {
            if (!iae.isItem() || !iae.isMeaningful()) continue;
            c.add(iae.getItemStack());
        }
        return c;
    }

    public static IAEItemStack createAEStack(ItemStack is) {
        return AEApi.instance().storage().createItemStack(is);
    }

    public static HashSet<ICellProvider> getAllCellContainers(IStorageGrid isg) {
        try {
            if (isg.getClass() == gridCache) {
                HashSet set = (HashSet)activeCellProviders.get(isg);
                return set;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static IChestOrDrive getContainer(ICellProvider icp) {
        return null;
    }

    public long removeItem(ItemStack is, boolean simulate, boolean nbt) {
        IMEMonitor<IAEItemStack> mon = this.getStorage();
        if (!nbt) {
            Collection<IAEItemStack> c = this.getFuzzyItemList(is, FuzzyMode.IGNORE_ALL);
            IAEStack most = null;
            for (IAEItemStack iae : c) {
                if (most != null && iae.getStackSize() < most.getStackSize() || is.func_77973_b() != iae.getItem() || is.func_77960_j() != iae.getItemDamage() && is.func_77960_j() != Short.MAX_VALUE) continue;
                most = iae;
            }
            if (most == null) {
                return 0L;
            }
            most.setStackSize(is.field_77994_a);
            ExtractedItem ei = this.extract((IAEItemStack)most, simulate);
            return ei != null ? ei.amount : 0L;
        }
        ExtractedItem ei = this.extract(MESystemReader.createAEStack(is), simulate);
        return ei != null ? ei.amount : 0L;
    }

    public ExtractedItemGroup removeItemFuzzy(ItemStack is, boolean simulate, FuzzyMode fz, boolean oredict, boolean nbt, boolean allowMultiple) {
        IMEMonitor<IAEItemStack> mon = this.getStorage();
        IAEItemStack ae = MESystemReader.createAEStack(is);
        Collection<IAEItemStack> c = this.getFuzzyItemList(is, fz);
        ArrayList<IAEItemStack> li = new ArrayList<IAEItemStack>();
        for (IAEItemStack iae : c) {
            if (!oredict && is.func_77973_b() != iae.getItem() || nbt && !ReikaNBTHelper.areNBTTagsEqual(is.field_77990_d, iae.hasTagCompound() ? iae.getTagCompound().getNBTTagCompoundCopy() : null)) continue;
            li.add(iae.copy());
        }
        Collections.sort(li, sizeSorter);
        int wanted = is.field_77994_a;
        ExtractedItemGroup ret = new ExtractedItemGroup();
        for (IAEItemStack iae : li) {
            long amt = Math.min((long)wanted, iae.getStackSize());
            iae.setStackSize(amt);
            ExtractedItem ei = this.extract(iae, simulate);
            ret.addItem(ei);
            long has = Math.min(iae.getStackSize(), ei.amount);
            if ((wanted = (int)((long)wanted - has)) > 0 && allowMultiple) continue;
            break;
        }
        return ret.isEmpty() ? null : ret;
    }

    private Collection<IAEItemStack> getFuzzyItemList(ItemStack is, FuzzyMode fz) {
        IMEMonitor<IAEItemStack> mon = this.getStorage();
        IAEItemStack ae = MESystemReader.createAEStack(is);
        ArrayList<IAEItemStack> c = new ArrayList<IAEItemStack>(mon.getStorageList().findFuzzy(ae, fz));
        if (is.func_77960_j() == Short.MAX_VALUE) {
            ItemStack cp = is.func_77946_l();
            cp.func_77964_b(0);
            ae = MESystemReader.createAEStack(cp);
            c.addAll(mon.getStorageList().findFuzzy(ae, fz));
        }
        ArrayList<IAEItemStack> c2 = new ArrayList<IAEItemStack>();
        for (IAEItemStack iae : c) {
            ExtractedItem ei = this.extract(iae, true);
            if (ei == null) continue;
            IAEItemStack iae2 = MESystemReader.createAEStack(ei.getItem());
            iae2.setStackSize(ei.amount);
            c2.add(iae2);
        }
        return c2;
    }

    private ExtractedItem extract(IAEItemStack ae, boolean simulate) {
        IAEItemStack is = this.getStorage().extractItems(ae, simulate ? Actionable.SIMULATE : Actionable.MODULATE, this.actionSource);
        return is != null ? new ExtractedItem(is) : null;
    }

    public long addItem(ItemStack is, boolean simulate) {
        IAEItemStack ret = this.getStorage().injectItems(MESystemReader.createAEStack(is), simulate ? Actionable.SIMULATE : Actionable.MODULATE, this.actionSource);
        return ret != null ? ret.getStackSize() : 0L;
    }

    public long getItemCount(ItemStack is, boolean nbt) {
        return this.removeItem(ReikaItemHelper.getSizedItemStack(is, Integer.MAX_VALUE), true, nbt);
    }

    public long getFuzzyItemCount(ItemStack is, FuzzyMode fz, boolean ore, boolean nbt) {
        ExtractedItemGroup ei = this.removeItemFuzzy(ReikaItemHelper.getSizedItemStack(is, Integer.MAX_VALUE), true, fz, ore, nbt, true);
        return ei != null ? ei.count() : 0L;
    }

    public void triggerFuzzyCrafting(World world, ItemStack is, long amt, ICraftingCallback callback, CraftCompleteCallback callback2) {
        this.triggerCrafting(world, is, amt, callback, callback2);
    }

    public void triggerCrafting(World world, ItemStack is, long amt, ICraftingCallback callback, CraftCompleteCallback callback2) {
        if (this.node == null || this.node.getGrid() == null) {
            return;
        }
        IAEItemStack iae = MESystemReader.createAEStack(is);
        iae.setStackSize(amt);
        if (callback == null) {
            callback = new NoopCraftingCallback();
        }
        Future<ICraftingJob> f = this.getCraftingGrid().beginCraftingJob(world, this.node.getGrid(), this.actionSource, iae, callback);
        if (callback2 != null) {
            this.crafting.put(f, callback2);
        }
    }

    public void tick() {
        ICraftingGrid cache = this.getCraftingGrid();
        if (cache != null) {
            Collection<ICraftingLink> c;
            HashSet<Future<ICraftingJob>> removeCalls = new HashSet<Future<ICraftingJob>>();
            for (Future<ICraftingJob> f : this.crafting.keySet()) {
                if (!f.isDone()) continue;
                try {
                    ICraftingJob job = f.get();
                    ICraftingLink l = cache.submitJob(job, this.requester, null, true, this.actionSource);
                    if (l == null) {
                        DragonAPICore.logError(job + " to craft " + job.getOutput() + " returned a null link!");
                    } else {
                        CraftCompleteCallback ccc = this.crafting.get(f);
                        if (ccc != null) {
                            this.craftingLinks.addValue(ccc, l);
                            ccc.onCraftingLinkReturned(l);
                        }
                    }
                    removeCalls.add(f);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
            for (Future<ICraftingJob> f : removeCalls) {
                this.crafting.remove(f);
            }
            MultiMap<CraftCompleteCallback, ICraftingLink> removeLinks = new MultiMap().setNullEmpty();
            for (CraftCompleteCallback ccc : this.craftingLinks.keySet()) {
                c = this.craftingLinks.get(ccc);
                if (c == null || c.isEmpty()) continue;
                for (ICraftingLink l : c) {
                    if (!l.isDone()) continue;
                    ccc.onCraftingComplete(l);
                    removeLinks.addValue(ccc, l);
                }
            }
            for (CraftCompleteCallback ccc : removeLinks.keySet()) {
                c = removeLinks.get(ccc);
                if (c == null) continue;
                for (ICraftingLink l : c) {
                    this.craftingLinks.remove(ccc, l);
                }
            }
        }
    }

    @Override
    public boolean isValid(Object verificationToken) {
        return verificationToken.equals(this.monitorToken);
    }

    @Override
    public void postChange(IBaseMonitor<IAEItemStack> monitor, Iterable<IAEItemStack> change, BaseActionSource actionSource) {
        for (IAEItemStack iae : change) {
            KeyedItemStack ks = new KeyedItemStack(iae.getItemStack()).setSimpleHash(true).setIgnoreNBT(true);
            Collection<ChangeCallback> c = this.changeCallbacks.get(ks);
            for (ChangeCallback cc : c) {
                cc.onItemChange(iae);
            }
        }
    }

    @Override
    public void onListUpdate() {
        for (ChangeCallback cc : this.changeCallbacks.allValues(false)) {
            cc.onItemChange(null);
        }
    }

    public static Collection<IGrid> getAllMENetworks() {
        try {
            return (Collection)getNetworks.invoke(tickHandlerInstance, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<IGrid>();
        }
    }

    public static void registerMESystemEffect(MESystemEffect effect) {
        systemEffects.add(effect);
    }

    public static void registerEffectHandler() {
        if (!systemEffects.isEmpty()) {
            TickRegistry.instance.registerTickHandler(new EffectHandler());
        }
    }

    static {
        systemEffects = new ArrayList<MESystemEffect>();
        sizeSorter = new Comparator<IAEItemStack>(){

            @Override
            public int compare(IAEItemStack o1, IAEItemStack o2) {
                return -Long.compare(o1.getStackSize(), o2.getStackSize());
            }
        };
        try {
            Class<?> c = Class.forName("appeng.hooks.TickHandler");
            Field inst = c.getField("INSTANCE");
            tickHandlerInstance = inst.get(null);
            getNetworks = c.getDeclaredMethod("getGridList", new Class[0]);
            gridCache = Class.forName("appeng.me.cache.GridStorageCache");
            activeCellProviders = gridCache.getDeclaredField("activeCellProviders");
            activeCellProviders.setAccessible(true);
        }
        catch (Exception e) {
            DragonAPICore.logError("Could not build getter to ME system list!");
            ReflectiveFailureTracker.instance.logModReflectiveFailure(ModList.APPENG, e);
        }
    }

    private static class FakeActionHost
    implements IActionHost {
        private IGridNode node;

        private FakeActionHost(IGridNode ign) {
            this.node = ign;
        }

        @Override
        public IGridNode getGridNode(ForgeDirection dir) {
            return this.node;
        }

        @Override
        public AECableType getCableConnectionType(ForgeDirection dir) {
            return AECableType.GLASS;
        }

        @Override
        public void securityBreak() {
        }

        @Override
        public IGridNode getActionableNode() {
            return this.node;
        }
    }

    private static class GenericActionSource
    extends BaseActionSource {
        private GenericActionSource() {
        }

        @Override
        public boolean isMachine() {
            return true;
        }
    }

    private static class FakeActionSource
    extends MachineSource {
        private FakeActionSource(IGridNode ign) {
            super(new FakeActionHost(ign));
        }
    }

    public static abstract class ItemInSystemEffect
    implements MESystemEffect {
        private final ItemStack itemKey;

        public ItemInSystemEffect(ItemStack is) {
            this.itemKey = is;
        }

        @Override
        public final void performEffect(IGrid grid) {
            if (grid.isEmpty() || grid.getNodes().isEmpty() || !grid.getNodes().iterator().hasNext()) {
                return;
            }
            IMachineSet iah = grid.getMachines(IActionHost.class);
            MESystemReader me = null;
            if (iah.isEmpty()) {
                IReadOnlyCollection<IGridNode> ign = grid.getNodes();
                try {
                    Iterator it = ign.iterator();
                    if (it.hasNext()) {
                        IGridNode ign2 = (IGridNode)it.next();
                        me = new MESystemReader(ign2, new FakeActionSource(ign2));
                    }
                }
                catch (Exception e) {
                    DragonAPICore.logError("Detected invalid ME system when running " + this + ": " + grid.getNodes() + "\n; Threw exception on access: ");
                    e.printStackTrace();
                }
            } else {
                IActionHost ia = (IActionHost)iah.iterator().next();
                me = new MESystemReader(ia.getActionableNode(), new MachineSource(ia));
            }
            if (me == null) {
                return;
            }
            long amt = me.getItemCount(this.itemKey, this.itemKey.field_77990_d != null);
            if (amt > 0L) {
                this.doEffect(grid, amt);
            }
        }

        protected abstract void doEffect(IGrid var1, long var2);
    }

    public static interface MESystemEffect {
        public void performEffect(IGrid var1);

        public int getTickFrequency();
    }

    public static final class ExtractedItemGroup {
        private final ArrayList<ExtractedItem> items = new ArrayList();

        private ExtractedItemGroup() {
        }

        private ExtractedItemGroup(ExtractedItem ... li) {
            for (ExtractedItem ei : li) {
                this.addItem(ei);
            }
        }

        private void addItem(ExtractedItem ei) {
            this.items.add(ei);
        }

        public long count() {
            long ret = 0L;
            for (ExtractedItem ei : this.items) {
                ret += ei.amount;
            }
            return ret;
        }

        public boolean isEmpty() {
            return this.items.isEmpty();
        }

        public ExtractedItem getBiggest() {
            ExtractedItem ret = null;
            for (ExtractedItem ei : this.items) {
                if (ret != null && ei.amount <= ret.amount) continue;
                ret = ei;
            }
            return ret;
        }

        public Collection<ExtractedItem> getItems() {
            return Collections.unmodifiableCollection(this.items);
        }
    }

    public static final class ExtractedItem {
        private final ItemStack item;
        public final long amount;

        private ExtractedItem(ItemStack is, long amt) {
            this.item = is;
            this.amount = amt;
        }

        private ExtractedItem(IAEItemStack iae) {
            this(iae.getItemStack(), iae.getStackSize());
        }

        public ItemStack getItem() {
            return ReikaItemHelper.getSizedItemStack(this.item, (int)Math.min(Integer.MAX_VALUE, this.amount));
        }
    }

    public static enum MatchMode {
        EXACT(0xFFCC00, "Exact Match"),
        FUZZY(43775, "Fuzzy Match"),
        FUZZYORE(65280, "Fuzzy/Ore Match"),
        FUZZYNBT(0xAA00FF, "Fuzzy/Ore Match, Ignore NBT");

        public final int color;
        public final String desc;
        public static final MatchMode[] list;

        private MatchMode(int c, String s) {
            this.color = c;
            this.desc = s;
        }

        public long countItems(MESystemReader net, ItemStack is) {
            switch (this) {
                case EXACT: {
                    return net.getItemCount(is, true);
                }
                case FUZZY: {
                    return net.getFuzzyItemCount(is, FuzzyMode.IGNORE_ALL, false, true);
                }
                case FUZZYORE: {
                    return net.getFuzzyItemCount(is, FuzzyMode.IGNORE_ALL, true, true);
                }
                case FUZZYNBT: {
                    return net.getFuzzyItemCount(is, FuzzyMode.IGNORE_ALL, true, false);
                }
            }
            return 0L;
        }

        public ExtractedItemGroup removeItems(MESystemReader net, ItemStack is, boolean simulate, boolean allowMultiple) {
            switch (this) {
                case EXACT: {
                    long amt = net.removeItem(is, simulate, true);
                    return amt != 0L ? new ExtractedItemGroup(new ExtractedItem[]{new ExtractedItem(is, amt)}) : null;
                }
                case FUZZY: {
                    return net.removeItemFuzzy(is, simulate, FuzzyMode.IGNORE_ALL, false, true, allowMultiple);
                }
                case FUZZYORE: {
                    return net.removeItemFuzzy(is, simulate, FuzzyMode.IGNORE_ALL, true, true, allowMultiple);
                }
                case FUZZYNBT: {
                    return net.removeItemFuzzy(is, simulate, FuzzyMode.IGNORE_ALL, true, false, allowMultiple);
                }
            }
            return null;
        }

        public MatchMode next() {
            return list[(this.ordinal() + 1) % list.length];
        }

        public boolean compare(ItemStack is1, ItemStack is2) {
            switch (this) {
                case EXACT: {
                    return ReikaItemHelper.matchStacks(is1, is2) && ItemStack.func_77970_a((ItemStack)is1, (ItemStack)is2);
                }
                case FUZZY: {
                    return is1.func_77973_b() == is2.func_77973_b() && ItemStack.func_77970_a((ItemStack)is1, (ItemStack)is2);
                }
                case FUZZYNBT: {
                    return is1.func_77973_b() == is2.func_77973_b();
                }
                case FUZZYORE: {
                    return ReikaItemHelper.checkOreDictOverlap(is1, is2);
                }
            }
            return false;
        }

        static {
            list = MatchMode.values();
        }
    }

    private static class NoopCraftingCallback
    implements ICraftingCallback {
        private NoopCraftingCallback() {
        }

        @Override
        public void calculationComplete(ICraftingJob job) {
        }
    }

    public static interface ChangeCallback {
        public void onItemChange(IAEItemStack var1);
    }

    public static interface CraftCompleteCallback {
        public void onCraftingLinkReturned(ICraftingLink var1);

        public void onCraftingComplete(ICraftingLink var1);
    }

    private static class EffectHandler
    implements TickRegistry.TickHandler {
        private EffectHandler() {
        }

        @Override
        public void tick(TickRegistry.TickType type, Object ... tickData) {
            Collection<IGrid> grids = null;
            long tick = DimensionManager.getWorld((int)0).func_82737_E();
            for (MESystemEffect effect : systemEffects) {
                if (tick % (long)effect.getTickFrequency() != 0L) continue;
                if (grids == null) {
                    grids = MESystemReader.getAllMENetworks();
                }
                for (IGrid g : grids) {
                    if (g.isEmpty()) continue;
                    effect.performEffect(g);
                }
            }
        }

        @Override
        public EnumSet<TickRegistry.TickType> getType() {
            return EnumSet.of(TickRegistry.TickType.SERVER);
        }

        @Override
        public boolean canFire(TickEvent.Phase p) {
            return p == TickEvent.Phase.END;
        }

        @Override
        public String getLabel() {
            return "ME System Tick";
        }
    }
}

