/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.ModInteract.DeepInteract;

import Reika.DragonAPI.Instantiable.Data.BlockStruct.BlockArray;
import Reika.DragonAPI.Instantiable.Data.BlockStruct.FilledBlockArray;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Instantiable.Data.Immutable.Coordinate;
import buildcraft.BuildCraftBuilders;
import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.SchematicBlock;
import buildcraft.api.blueprints.SchematicBlockBase;
import buildcraft.core.Box;
import buildcraft.core.blueprints.Blueprint;
import buildcraft.core.blueprints.BptContext;
import buildcraft.core.blueprints.LibraryId;
import buildcraft.core.blueprints.SchematicRegistry;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BCBlueprintBuilder {
    public static Blueprint convertBA(World world, BlockArray ba) {
        Blueprint ret = new Blueprint(ba.getSizeX(), ba.getSizeY(), ba.getSizeZ());
        BptContext bpt = ret.getContext(world, new Box(ba.getMinX(), ba.getMinY(), ba.getMinZ(), ba.getMaxX(), ba.getMaxY(), ba.getMaxZ()));
        for (Coordinate c : ba.keySet()) {
            Block b = c.getBlock((IBlockAccess)world);
            int meta = c.getBlockMetadata((IBlockAccess)world);
            SchematicBlock s = SchematicRegistry.INSTANCE.createSchematicBlock(b, meta);
            s.idsToWorld(bpt.getMappingRegistry());
            s.storeRequirements((IBuilderContext)bpt, c.xCoord, c.yCoord, c.zCoord);
            if (s instanceof SchematicBlock) {
                SchematicBlock sb = s;
                sb.meta = meta;
                sb.storedRequirements = new ItemStack[]{new ItemStack(b, 1, meta)};
            }
            ret.put(c.xCoord - ba.getMinX(), c.yCoord - ba.getMinY(), c.zCoord - ba.getMinZ(), (SchematicBlockBase)s);
        }
        return ret;
    }

    public static Blueprint convertBA(FilledBlockArray ba) {
        Blueprint ret = new Blueprint(ba.getSizeX(), ba.getSizeY(), ba.getSizeZ());
        BptContext bpt = ret.getContext(ba.world, new Box(ba.getMinX(), ba.getMinY(), ba.getMinZ(), ba.getMaxX(), ba.getMaxY(), ba.getMaxZ()));
        for (Coordinate c : ba.keySet()) {
            BlockKey bk = ba.getBlockKeyAt(c.xCoord, c.yCoord, c.zCoord);
            SchematicBlock s = SchematicRegistry.INSTANCE.createSchematicBlock(bk.blockID, bk.hasMetadata() ? bk.metadata : 0);
            s.idsToWorld(bpt.getMappingRegistry());
            s.storeRequirements((IBuilderContext)bpt, c.xCoord, c.yCoord, c.zCoord);
            if (s instanceof SchematicBlock) {
                SchematicBlock sb = s;
                sb.meta = bk.hasMetadata() ? bk.metadata : 0;
                sb.storedRequirements = new ItemStack[]{new ItemStack(bk.blockID, 1, sb.meta)};
            }
            ret.put(c.xCoord - ba.getMinX(), c.yCoord - ba.getMinY(), c.zCoord - ba.getMinZ(), (SchematicBlockBase)s);
        }
        return ret;
    }

    private static LibraryId getExistingBlueprint(String name) {
        for (LibraryId id : BuildCraftBuilders.serverDB.getBlueprintIds()) {
            if (id.name == null || !id.name.endsWith(name)) continue;
            return id;
        }
        return null;
    }

    public static ItemStack writeBlueprintToDisk(Blueprint b, String name, String author) {
        LibraryId id = BCBlueprintBuilder.getExistingBlueprint(name);
        if (id == null) {
            id = new LibraryId();
            id.name = name;
            BuildCraftBuilders.serverDB.add(id, b.getNBT());
        }
        b.id = id;
        b.author = author;
        b.anchorX = 0;
        b.anchorY = 0;
        b.anchorZ = 0;
        return b.getStack();
    }

    public static void registerBlockForDirectPlacement(Block b) {
        BCBlueprintBuilder.registerBlockForDirectPlacement(b, -1);
    }

    public static void registerBlockForDirectPlacement(Block b, int meta) {
        SchematicRegistry.INSTANCE.registerSchematicBlock(b, meta, SchematicDirect.class, new Object[]{new BlockKey(b, meta)});
    }

    private static class SchematicDirect
    extends SchematicBlock {
        private final BlockKey key;

        public SchematicDirect(BlockKey bk) {
            this.key = bk;
            this.block = bk.blockID;
            this.meta = bk.hasMetadata() ? bk.metadata : 0;
        }

        public void getRequirementsForPlacement(IBuilderContext context, LinkedList<ItemStack> requirements) {
            requirements.add(this.key.asItemStack());
        }

        public void storeRequirements(IBuilderContext context, int x, int y, int z) {
        }
    }
}

