/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries.World;

import Reika.DragonAPI.Base.BlockTieredResource;
import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Extras.BlockProperties;
import Reika.DragonAPI.Instantiable.Data.Maps.BlockMap;
import Reika.DragonAPI.Interfaces.Block.SemiUnbreakable;
import Reika.DragonAPI.Interfaces.Block.SpecialOreBlock;
import Reika.DragonAPI.Interfaces.Block.Submergeable;
import Reika.DragonAPI.Libraries.Java.ReikaObfuscationHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaOreHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaTreeHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.ChiselBlockHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.MystCraftHandler;
import Reika.DragonAPI.ModInteract.ItemHandlers.ThaumItemHelper;
import Reika.DragonAPI.ModInteract.ItemHandlers.TwilightForestHandler;
import Reika.DragonAPI.ModList;
import Reika.DragonAPI.ModRegistry.ModOreList;
import Reika.DragonAPI.ModRegistry.ModWoodList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.IFluidBlock;

public final class ReikaBlockHelper
extends DragonAPICore {
    private static final BlockMap<ItemStack> silkTouchDrops = new BlockMap();

    public static boolean matchMaterialsLoosely(Material m1, Material m2) {
        if (m1 == m2) {
            return true;
        }
        if (m1 == Material.field_151588_w && m2 == Material.field_151598_x) {
            return true;
        }
        if (m2 == Material.field_151588_w && m1 == Material.field_151598_x) {
            return true;
        }
        if (m1 == Material.field_151597_y && m2 == Material.field_151596_z) {
            return true;
        }
        if (m2 == Material.field_151597_y && m1 == Material.field_151596_z) {
            return true;
        }
        return m1.func_151565_r() == MapColor.field_151669_i && m2.func_151565_r() == MapColor.field_151669_i;
    }

    public static boolean isWood(IBlockAccess world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        if (b instanceof BlockLog) {
            return true;
        }
        int meta = world.func_72805_g(x, y, z);
        if (ReikaTreeHelper.getTree(b, meta) != null) {
            return true;
        }
        return ModWoodList.getModWood(b, meta) != null;
    }

    public static boolean isLeaf(IBlockAccess world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        if (b instanceof BlockLeavesBase) {
            return true;
        }
        int meta = world.func_72805_g(x, y, z);
        if (ReikaTreeHelper.getTreeFromLeaf(b, meta) != null) {
            return true;
        }
        return ModWoodList.getModWoodFromLeaf(b, meta) != null;
    }

    public static boolean isWood(Block b, int meta) {
        if (b instanceof BlockLog) {
            return true;
        }
        if (ReikaTreeHelper.getTree(b, meta) != null) {
            return true;
        }
        return ModWoodList.getModWood(b, meta) != null;
    }

    public static boolean isLeaf(Block b, int meta) {
        if (b instanceof BlockLeavesBase) {
            return true;
        }
        if (ReikaTreeHelper.getTreeFromLeaf(b, meta) != null) {
            return true;
        }
        return ModWoodList.getModWoodFromLeaf(b, meta) != null;
    }

    public static boolean alwaysDropsSelf(Block ID) {
        int k = 0;
        for (int i = 0; i < 16; ++i) {
            if (Item.func_150898_a((Block)ID) == ID.func_149650_a(i, rand, k)) continue;
            return false;
        }
        return true;
    }

    public static boolean neverDropsSelf(Block ID) {
        boolean hasID = false;
        boolean hasMeta = false;
        for (int k = 0; k <= 20 && !hasID; ++k) {
            for (int i = 0; i < 16 && !hasID; ++i) {
                if (Item.func_150898_a((Block)ID) != ID.func_149650_a(i, rand, k)) continue;
                hasID = true;
            }
        }
        hasMeta = true;
        return hasID && hasMeta;
    }

    public static boolean isOre(ItemStack is) {
        if (is == null) {
            return false;
        }
        if (Block.func_149634_a((Item)is.func_77973_b()) instanceof SpecialOreBlock) {
            return true;
        }
        if (ReikaOreHelper.isVanillaOre(is)) {
            return true;
        }
        if (ModOreList.isModOre(is)) {
            return true;
        }
        return ReikaOreHelper.getEntryByOreDict(is) != null;
    }

    public static boolean isOre(Block id, int meta) {
        if (id == Blocks.field_150350_a) {
            return false;
        }
        if (id == Blocks.field_150439_ay) {
            return true;
        }
        if (id instanceof SpecialOreBlock) {
            return true;
        }
        if (ReikaOreHelper.isVanillaOre(id)) {
            return true;
        }
        if (ModOreList.isModOre(id, meta)) {
            return true;
        }
        if (Item.func_150898_a((Block)id) == null) {
            return false;
        }
        if (id instanceof BlockTieredResource && id.func_149688_o() == Material.field_151576_e) {
            return true;
        }
        return ReikaOreHelper.getEntryByOreDict(new ItemStack(id, 1, meta)) != null;
    }

    public static ItemStack getWorldBlockAsItemStack(World world, int x, int y, int z) {
        return new ItemStack(world.func_147439_a(x, y, z), 1, world.func_72805_g(x, y, z));
    }

    public static Block getSilverfishImitatedBlock(int meta) {
        switch (meta) {
            case 0: {
                return Blocks.field_150348_b;
            }
            case 1: {
                return Blocks.field_150347_e;
            }
            case 2: {
                return Blocks.field_150417_aV;
            }
        }
        return Blocks.field_150350_a;
    }

    public static boolean isCollideable(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        if (b == Blocks.field_150350_a) {
            return false;
        }
        return b.func_149668_a(world, x, y, z) != null && !BlockProperties.isNonSolid(b);
    }

    public static boolean isDirtType(Block id, int meta) {
        if (id == Blocks.field_150346_d) {
            return true;
        }
        if (id == Blocks.field_150349_c) {
            return true;
        }
        if (id == Blocks.field_150351_n) {
            return false;
        }
        return false;
    }

    public static boolean isLiquid(Block b) {
        if (b == Blocks.field_150350_a) {
            return false;
        }
        Material mat = b.func_149688_o();
        if (mat == Material.field_151587_i || mat == Material.field_151586_h) {
            return true;
        }
        return b instanceof BlockLiquid || b instanceof BlockFluidBase || b instanceof IFluidBlock;
    }

    public static boolean isPortalBlock(World world, int x, int y, int z) {
        Block id = world.func_147439_a(x, y, z);
        if (id == Blocks.field_150427_aO) {
            return true;
        }
        if (id == Blocks.field_150384_bq) {
            return true;
        }
        if (ModList.MYSTCRAFT.isLoaded() && id == MystCraftHandler.getInstance().portalID) {
            return true;
        }
        return ModList.TWILIGHT.isLoaded() && id == TwilightForestHandler.BlockEntry.PORTAL.getBlock();
    }

    public static boolean isStairBlock(Block id) {
        if (id == Blocks.field_150446_ar) {
            return true;
        }
        if (id == Blocks.field_150390_bg) {
            return true;
        }
        if (id == Blocks.field_150389_bf) {
            return true;
        }
        if (id == Blocks.field_150372_bz) {
            return true;
        }
        if (id == Blocks.field_150476_ad) {
            return true;
        }
        if (id == Blocks.field_150387_bl) {
            return true;
        }
        if (id == Blocks.field_150485_bF) {
            return true;
        }
        if (id == Blocks.field_150487_bG) {
            return true;
        }
        if (id == Blocks.field_150481_bH) {
            return true;
        }
        return id == Blocks.field_150370_cb;
    }

    public static ItemStack getSilkTouch(World world, int x, int y, int z, Block id, int meta, EntityPlayer ep, boolean dropFluids) {
        if (id == Blocks.field_150350_a || id == Blocks.field_150326_M || id == Blocks.field_150332_K || id == Blocks.field_150480_ab) {
            return null;
        }
        if (id == Blocks.field_150427_aO || id == Blocks.field_150384_bq) {
            return null;
        }
        if ((id instanceof BlockDoor || id instanceof BlockBed) && meta >= 8) {
            return null;
        }
        ItemStack get = silkTouchDrops.get(id, meta);
        if (get != null) {
            return get;
        }
        if (Item.func_150898_a((Block)id) == null) {
            DragonAPICore.logError("Something tried to silktouch null-item block " + id.func_149732_F());
            return null;
        }
        if (!(!ReikaBlockHelper.isLiquid(id) || dropFluids && ReikaWorldHelper.isLiquidSourceBlock(world, x, y, z))) {
            return null;
        }
        if (ModList.THAUMCRAFT.isLoaded() && id == ThaumItemHelper.BlockEntry.NODE.getBlock()) {
            return null;
        }
        if (id instanceof BlockTieredResource) {
            BlockTieredResource b = (BlockTieredResource)id;
            if (ep != null && b.isPlayerSufficientTier((IBlockAccess)world, x, y, z, ep)) {
                return ReikaItemHelper.collateItemList(b.getHarvestResources(world, x, y, z, 0, ep)).get(0);
            }
            Collection<ItemStack> li = b.getNoHarvestResources(world, x, y, z, 0, ep);
            return li.isEmpty() ? null : new ArrayList<ItemStack>(li).get(0);
        }
        return new ItemStack(id, 1, ReikaBlockHelper.getSilkTouchMetaDropped(id, meta));
    }

    private static int getSilkTouchMetaDropped(Block id, int meta) {
        if (id == Blocks.field_150478_aa) {
            return 0;
        }
        if (id == Blocks.field_150429_aA || id == Blocks.field_150437_az) {
            return 0;
        }
        if (id == Blocks.field_150362_t || id == Blocks.field_150364_r || id == Blocks.field_150361_u || id == Blocks.field_150363_s) {
            return meta & 3;
        }
        if (id == Blocks.field_150345_g) {
            return meta & 3;
        }
        if (id == Blocks.field_150395_bd) {
            return 0;
        }
        if (id == Blocks.field_150392_bi) {
            return 0;
        }
        if (id == Blocks.field_150320_F || id == Blocks.field_150331_J) {
            return 0;
        }
        if (ReikaBlockHelper.isStairBlock(id)) {
            return 0;
        }
        ModWoodList wood = ModWoodList.getModWood(id, meta);
        if (wood != null) {
            return wood.getLogMetadatas().get(0);
        }
        wood = ModWoodList.getModWoodFromLeaf(id, meta);
        if (wood != null) {
            return wood.getLeafMetadatas().get(0);
        }
        return meta;
    }

    private static void addSilkTouchDrop(Block b, Block drop) {
        ReikaBlockHelper.addSilkTouchDrop(b, new ItemStack(drop));
    }

    private static void addSilkTouchDrop(Block b, Item drop) {
        ReikaBlockHelper.addSilkTouchDrop(b, new ItemStack(drop));
    }

    private static void addSilkTouchDrop(Block b, ItemStack drop) {
        silkTouchDrops.put(b, drop);
    }

    public static boolean isUnbreakable(World world, int x, int y, int z, Block id, int meta, EntityPlayer ep) {
        if (id.func_149712_f(world, x, y, z) < 0.0f || ep != null && id.func_149737_a(ep, world, x, y, z) < 0.0f) {
            return true;
        }
        return id instanceof SemiUnbreakable && ((SemiUnbreakable)id).isUnbreakable(world, x, y, z, meta);
    }

    public static boolean isFacade(Block b) {
        String n = b.getClass().getName().toLowerCase(Locale.ENGLISH);
        if (n.contains("facade")) {
            return true;
        }
        if (n.contains("conduitbundle")) {
            return true;
        }
        if (n.contains("cover")) {
            return true;
        }
        if (n.contains("multipart")) {
            return true;
        }
        return n.contains("cablebus");
    }

    public static int getSignMetadataToConnectToWall(World world, int x, int y, int z, int meta) {
        ForgeDirection dir = ReikaBlockHelper.getWallSignDirection(meta);
        if (dir == ForgeDirection.UNKNOWN) {
            return meta;
        }
        int dx = x + dir.offsetX;
        int dz = z + dir.offsetZ;
        Block b = world.func_147439_a(dx, y, dz);
        if (b.func_149662_c() || b.isSideSolid((IBlockAccess)world, dx, y, dz, dir.getOpposite())) {
            return meta;
        }
        for (int i = 2; i < 6; ++i) {
            ForgeDirection dir2 = ReikaBlockHelper.getWallSignDirection(i);
            if (dir == ForgeDirection.UNKNOWN) {
                return meta;
            }
            int ddx = x + dir2.offsetX;
            int ddz = z + dir2.offsetZ;
            Block b2 = world.func_147439_a(ddx, y, ddz);
            if (!b2.func_149662_c() && !b2.isSideSolid((IBlockAccess)world, ddx, y, ddz, dir2.getOpposite())) continue;
            return i;
        }
        return meta;
    }

    public static ForgeDirection getWallSignDirection(int meta) {
        switch (meta) {
            case 2: {
                return ForgeDirection.SOUTH;
            }
            case 3: {
                return ForgeDirection.NORTH;
            }
            case 4: {
                return ForgeDirection.EAST;
            }
            case 5: {
                return ForgeDirection.WEST;
            }
        }
        return ForgeDirection.UNKNOWN;
    }

    public static boolean renderLiquidSide(IBlockAccess iba, int x, int y, int z, int side, Block b) {
        Block at = iba.func_147439_a(x, y, z);
        int meta = iba.func_72805_g(x, y, z);
        if (at.func_149688_o() == b.func_149688_o()) {
            return false;
        }
        if (at instanceof Submergeable) {
            return false;
        }
        if (side == 1) {
            return true;
        }
        return ReikaBlockHelper.genericShouldSideBeRendered(iba, x, y, z, side, b);
    }

    public static boolean genericShouldSideBeRendered(IBlockAccess iba, int x, int y, int z, int side, Block b) {
        if (side == 0 && b.func_149665_z() > 0.0) {
            return true;
        }
        if (side == 1 && b.func_149669_A() < 1.0) {
            return true;
        }
        if (side == 2 && b.func_149706_B() > 0.0) {
            return true;
        }
        if (side == 3 && b.func_149693_C() < 1.0) {
            return true;
        }
        if (side == 4 && b.func_149704_x() > 0.0) {
            return true;
        }
        if (side == 5 && b.func_149753_y() < 1.0) {
            return true;
        }
        return !iba.func_147439_a(x, y, z).func_149662_c();
    }

    public static boolean isGroundType(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        if (b == Blocks.field_150346_d || b == Blocks.field_150349_c || b == Blocks.field_150348_b || b == Blocks.field_150354_m || b == Blocks.field_150322_A || b == Blocks.field_150435_aG || b == Blocks.field_150351_n || b == Blocks.field_150431_aC) {
            return true;
        }
        Material mat = b.func_149688_o();
        return mat == Material.field_151578_c || b.isReplaceableOreGen(world, x, y, z, Blocks.field_150348_b);
    }

    public static boolean isNaturalStone(World world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        if (b == Blocks.field_150348_b || b == Blocks.field_150322_A || b == Blocks.field_150357_h) {
            return true;
        }
        if (b.isReplaceableOreGen(world, x, y, z, Blocks.field_150348_b)) {
            return true;
        }
        int meta = world.func_72805_g(x, y, z);
        if (ReikaBlockHelper.isOre(b, meta)) {
            return true;
        }
        return ModList.CHISEL.isLoaded() && ChiselBlockHandler.isWorldgenBlock(b, meta);
    }

    public static void extendPiston(World world, int x, int y, int z) {
        BlockPistonBase b = (BlockPistonBase)world.func_147439_a(x, y, z);
        int dir = BlockPistonBase.func_150076_b((int)world.func_72805_g(x, y, z));
        if (dir != 7) {
            ReikaObfuscationHelper.invoke("tryExtend", b, world, x, y, z, dir);
            world.func_72921_c(x, y, z, dir | 8, 2);
            world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "tile.piston.out", 0.5f, world.field_73012_v.nextFloat() * 0.25f + 0.6f);
        }
    }

    static {
        ReikaBlockHelper.addSilkTouchDrop(Blocks.field_150439_ay, Blocks.field_150450_ax);
        ReikaBlockHelper.addSilkTouchDrop((Block)Blocks.field_150488_af, Items.field_151137_ax);
        ReikaBlockHelper.addSilkTouchDrop(Blocks.field_150374_bv, Blocks.field_150379_bu);
        ReikaBlockHelper.addSilkTouchDrop((Block)Blocks.field_150413_aR, Items.field_151107_aW);
        ReikaBlockHelper.addSilkTouchDrop((Block)Blocks.field_150416_aS, Items.field_151107_aW);
        ReikaBlockHelper.addSilkTouchDrop((Block)Blocks.field_150441_bU, Items.field_151132_bS);
        ReikaBlockHelper.addSilkTouchDrop((Block)Blocks.field_150455_bV, Items.field_151132_bS);
        ReikaBlockHelper.addSilkTouchDrop(Blocks.field_150393_bb, Items.field_151080_bb);
        ReikaBlockHelper.addSilkTouchDrop(Blocks.field_150394_bc, Items.field_151081_bc);
        ReikaBlockHelper.addSilkTouchDrop(Blocks.field_150464_aj, Items.field_151015_O);
        ReikaBlockHelper.addSilkTouchDrop(Blocks.field_150459_bM, Items.field_151172_bF);
        ReikaBlockHelper.addSilkTouchDrop(Blocks.field_150469_bN, Items.field_151174_bG);
        ReikaBlockHelper.addSilkTouchDrop(Blocks.field_150388_bm, Items.field_151075_bm);
        ReikaBlockHelper.addSilkTouchDrop(Blocks.field_150324_C, Items.field_151104_aV);
        ReikaBlockHelper.addSilkTouchDrop(Blocks.field_150382_bo, Items.field_151067_bt);
        ReikaBlockHelper.addSilkTouchDrop((Block)Blocks.field_150383_bp, Items.field_151066_bu);
        ReikaBlockHelper.addSilkTouchDrop(Blocks.field_150457_bL, Items.field_151162_bE);
        ReikaBlockHelper.addSilkTouchDrop(Blocks.field_150473_bD, Items.field_151007_F);
        ReikaBlockHelper.addSilkTouchDrop(Blocks.field_150472_an, Items.field_151155_ap);
        ReikaBlockHelper.addSilkTouchDrop(Blocks.field_150444_as, Items.field_151155_ap);
        ReikaBlockHelper.addSilkTouchDrop(Blocks.field_150466_ao, Items.field_151135_aq);
        ReikaBlockHelper.addSilkTouchDrop(Blocks.field_150454_av, Items.field_151139_aw);
        ReikaBlockHelper.addSilkTouchDrop(Blocks.field_150436_aH, Items.field_151120_aE);
    }
}

