/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Libraries;

import Reika.DragonAPI.DragonAPICore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;

public final class ReikaPotionHelper
extends DragonAPICore {
    public static final int SPLASH_BIT = 16384;
    public static final int EXTENDED_BIT = 64;
    public static final int BOOST_BIT = 32;
    public static final int WATER_META = 0;
    public static final int AWKWARD_META = 16;
    public static final int POTION_BIT = 8192;
    private static final ArrayList<Integer> badPotions = new ArrayList();
    private static HashMap<Potion, Integer> potionDamageValues = new HashMap();
    public static final Comparator effectSorter = new PotionEffectSorter();

    public static int getPotionID(int dmg) {
        Iterator potioneffects;
        List effects = Items.field_151068_bn.func_77834_f(dmg);
        if (effects != null && !effects.isEmpty() && (potioneffects = effects.iterator()).hasNext()) {
            PotionEffect effect = (PotionEffect)potioneffects.next();
            return effect.func_76456_a();
        }
        return -1;
    }

    public static boolean isBadEffect(Potion pot) {
        return badPotions.contains(pot.field_76415_H);
    }

    public static boolean isSplashPotion(int dmg) {
        return (dmg & 0x4000) != 0;
    }

    public static boolean isBoosted(int dmg) {
        return (dmg & 0x20) != 0;
    }

    public static boolean isExtended(int dmg) {
        return (dmg & 0x40) != 0;
    }

    public static boolean isActualPotion(int dmg) {
        return (dmg & 0x2000) != 0;
    }

    public static void loadBadPotions() {
        for (int i = 0; i < Potion.field_76425_a.length; ++i) {
            Potion p = Potion.field_76425_a[i];
            if (p == null || !p.field_76418_K) continue;
            badPotions.add(p.field_76415_H);
        }
    }

    public static Map<Potion, Integer> getPotionValues() {
        return Collections.unmodifiableMap(potionDamageValues);
    }

    public static ArrayList<ItemStack> getBasePotionItems() {
        ArrayList<ItemStack> li = new ArrayList<ItemStack>();
        for (int meta : potionDamageValues.values()) {
            li.add(new ItemStack((Item)Items.field_151068_bn, 1, meta));
        }
        return li;
    }

    public static ItemStack getPotionItem(Potion potion, boolean extended, boolean levelII, boolean splash) {
        int dmg = ReikaPotionHelper.getPotionDamageValue(potion);
        if (extended) {
            dmg += 64;
        }
        if (levelII) {
            dmg += 32;
        }
        if (splash) {
            dmg += 16384;
        }
        ItemStack is = new ItemStack((Item)Items.field_151068_bn, 1, dmg);
        return is;
    }

    public static int getPotionDamageValue(Potion potion) {
        return potionDamageValues.containsKey(potion) ? potionDamageValues.get(potion) : 0;
    }

    public static void clearBadPotions(EntityLivingBase player) {
        ReikaPotionHelper.clearBadPotions(player, null);
    }

    public static void clearBadPotions(EntityLivingBase player, Set<Integer> ignore) {
        for (int id : badPotions) {
            if (ignore != null && ignore.contains(id)) continue;
            player.func_82170_o(id);
        }
    }

    static {
        potionDamageValues.put(Potion.field_76428_l, 8193);
        potionDamageValues.put(Potion.field_76424_c, 8194);
        potionDamageValues.put(Potion.field_76426_n, 8227);
        potionDamageValues.put(Potion.field_76436_u, 8196);
        potionDamageValues.put(Potion.field_76432_h, 8261);
        potionDamageValues.put(Potion.field_76439_r, 8230);
        potionDamageValues.put(Potion.field_76437_t, 8232);
        potionDamageValues.put(Potion.field_76420_g, 8201);
        potionDamageValues.put(Potion.field_76421_d, 8234);
        potionDamageValues.put(Potion.field_76433_i, 8268);
        potionDamageValues.put(Potion.field_76427_o, 8237);
        potionDamageValues.put(Potion.field_76441_p, 8238);
    }

    private static class PotionEffectSorter
    implements Comparator<PotionEffect> {
        private PotionEffectSorter() {
        }

        @Override
        public int compare(PotionEffect o1, PotionEffect o2) {
            return this.getFlags(o1) - this.getFlags(o2);
        }

        private int getFlags(PotionEffect o) {
            int flags = 0;
            flags += o.func_76456_a() * 10000000;
            flags += o.func_76459_b() * 100;
            return flags += o.func_76458_c();
        }
    }
}

