/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Worldgen;

import Reika.DragonAPI.DragonAPICore;
import Reika.DragonAPI.Instantiable.Data.Immutable.BlockKey;
import Reika.DragonAPI.Libraries.ReikaAABBHelper;
import Reika.DragonAPI.Libraries.World.ReikaBlockHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import cpw.mods.fml.common.registry.VillagerRegistry;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;

public class VillageBuilding
implements VillagerRegistry.IVillageCreationHandler {
    public final Class buildingClass;
    public final float weight;
    private final Constructor<VillagePiece> constructor;
    public final int xSize;
    public final int ySize;
    public final int zSize;

    public VillageBuilding(Class<? extends VillagePiece> c, float w, String n, int x, int y, int z) {
        this.buildingClass = c;
        this.weight = w;
        try {
            this.constructor = c.getConstructor(StructureVillagePieces.Start.class, Integer.TYPE, Random.class, StructureBoundingBox.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("You must specify an appropriate constructor!", e);
        }
        MapGenStructureIO.func_143031_a((Class)this.buildingClass, (String)n);
        this.xSize = x;
        this.ySize = y;
        this.zSize = z;
    }

    public StructureVillagePieces.PieceWeight getVillagePieceWeight(Random random, int i) {
        int c = MathHelper.func_76136_a((Random)random, (int)(0 + i), (int)(1 + i));
        return new StructureVillagePieces.PieceWeight(this.buildingClass, (int)this.weight, c);
    }

    public final Class<?> getComponentClass() {
        return this.buildingClass;
    }

    public final Object buildComponent(StructureVillagePieces.PieceWeight villagePiece, StructureVillagePieces.Start startPiece, List pieces, Random random, int p1, int p2, int p3, int p4, int p5) {
        return this.buildComponent(startPiece, pieces, random, p1, p2, p3, p4, p5);
    }

    private VillagePiece buildComponent(StructureVillagePieces.Start startPiece, List pieces, Random random, int par3, int par4, int par5, int par6, int par7) {
        StructureBoundingBox var8 = StructureBoundingBox.func_78889_a((int)par3, (int)par4, (int)par5, (int)0, (int)0, (int)0, (int)this.xSize, (int)this.ySize, (int)this.zSize, (int)par6);
        return !this.canVillageGoDeeper(var8) || StructureComponent.func_74883_a((List)pieces, (StructureBoundingBox)var8) != null ? null : this.createInstance(startPiece, par7, random, var8, par6);
    }

    private VillagePiece createInstance(StructureVillagePieces.Start start, int par7, Random random, StructureBoundingBox var8, int par6) {
        try {
            return this.constructor.newInstance(start, par7, random, var8, par6, this.xSize, this.ySize, this.zSize);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean canVillageGoDeeper(StructureBoundingBox var8) {
        return var8 != null && var8.field_78895_b > 10;
    }

    public static class PerVillageStructureEntry
    extends StructureEntry {
        public final int perVillageChance;

        public PerVillageStructureEntry(Class<? extends VillagePiece> c, float w, String s, int x, int y, int z, int p) {
            super(c, w, s, x, y, z);
            this.perVillageChance = p;
        }

        @Override
        public VillageBuilding build() {
            return new PerVillageBuilding(this.structureClass, this.weight, this.identifier, this.xSize, this.ySize, this.zSize, this.perVillageChance);
        }
    }

    public static class StructureEntry {
        public final Class structureClass;
        public final String identifier;
        public final float weight;
        public final int xSize;
        public final int ySize;
        public final int zSize;

        public StructureEntry(Class<? extends VillagePiece> c, float w, String s, int x, int y, int z) {
            this.structureClass = c;
            this.weight = w;
            this.identifier = s;
            this.xSize = x;
            this.ySize = y;
            this.zSize = z;
        }

        public VillageBuilding build() {
            return new VillageBuilding(this.structureClass, this.weight, this.identifier, this.xSize, this.ySize, this.zSize);
        }
    }

    public static abstract class VillagePiece
    extends StructureVillagePieces.Village {
        private int xSize;
        private int ySize;
        private int zSize;
        private int averageGroundLevel = -1;
        private StructureBoundingBox structureBox;
        private static final BlockKey BASIC_SUPPORT = new BlockKey(Blocks.field_150347_e);
        protected StructureVillagePieces.Start villageCore;
        private long villageHash;

        public VillagePiece() {
        }

        protected VillagePiece(StructureVillagePieces.Start start, int par2, Random rand, StructureBoundingBox bb, int par5, int x, int y, int z) {
            super(start, par2);
            this.field_74885_f = par5;
            this.field_74887_e = bb;
            this.villageCore = start;
            if (this.villageCore != null) {
                this.villageHash = ChunkCoordIntPair.func_77272_a((int)start.func_74874_b().func_78881_e(), (int)start.func_74874_b().func_78891_g());
            }
            this.xSize = x;
            this.ySize = y;
            this.zSize = z;
            this.initSizes();
        }

        public final NBTTagCompound func_143010_b() {
            NBTTagCompound ret = super.func_143010_b();
            ret.func_74772_a("vposhash", this.villageHash);
            return ret;
        }

        public final void func_143009_a(World world, NBTTagCompound tag) {
            super.func_143009_a(world, tag);
            this.xSize = tag.func_74762_e("sizeX");
            this.ySize = tag.func_74762_e("sizeY");
            this.zSize = tag.func_74762_e("sizeZ");
            this.initSizes();
            this.villageHash = tag.func_74763_f("vposhash");
        }

        private void initSizes() {
            StructureBoundingBox box = this.field_74887_e;
            if (box == null) {
                return;
            }
            this.xSize = Math.max(this.xSize, box.field_78893_d - box.field_78897_a + 1);
            this.ySize = Math.max(this.ySize, box.field_78894_e - box.field_78895_b + 1);
            this.zSize = Math.max(this.zSize, box.field_78892_f - box.field_78896_c + 1);
        }

        public final boolean func_74875_a(World world, Random rand, StructureBoundingBox box) {
            this.structureBox = box;
            this.initSizes();
            if (this.averageGroundLevel < 0) {
                this.averageGroundLevel = this.func_74889_b(world, box);
                if (this.averageGroundLevel < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78894_e + this.ySize - 1, 0);
            }
            return this.generate(world, rand);
        }

        public final int hashCode() {
            return this.structureBox.func_151535_h().hashCode() ^ ((Object)((Object)this)).getClass().hashCode();
        }

        public boolean equals(Object o) {
            return o.getClass() == ((Object)((Object)this)).getClass() && ((VillagePiece)((Object)o)).structureBox.func_151535_h().equals((Object)this.structureBox.func_151535_h());
        }

        protected final void clearDroppedItems(World world) {
            AxisAlignedBB box = ReikaAABBHelper.structureToAABB(this.field_74887_e).func_72314_b(2.0, 2.0, 2.0);
            List li = world.func_72872_a(EntityItem.class, box);
            for (EntityItem ei : li) {
                ei.func_70106_y();
            }
        }

        protected abstract boolean generate(World var1, Random var2);

        protected final void placeBlockAtCurrentPosition(World world, int i, int j, int k, Block b) {
            this.placeBlockAtCurrentPosition(world, i, j, k, b, 0);
        }

        protected final void placeBlockAtCurrentPosition(World world, int i, int j, int k, Block b, int meta) {
            this.placeBlockAtCurrentPosition(world, i, j, k, b, meta, BASIC_SUPPORT);
        }

        protected final void placeBlockAtCurrentPosition(World world, int i, int j, int k, Block b, int meta, BlockKey support) {
            int i1 = this.func_74865_a(i, k);
            int j1 = this.func_74862_a(j);
            int k1 = this.func_74873_b(i, k);
            if (b == Blocks.field_150444_as) {
                meta = ReikaBlockHelper.getSignMetadataToConnectToWall(world, i1, j1, k1, meta);
            }
            this.tryPlaceBlock(world, i1, j1, k1, b, meta, 3, support);
        }

        private void tryPlaceBlock(World world, int x, int y, int z, Block b, int meta, int flags) {
            this.tryPlaceBlock(world, x, y, z, b, meta, flags, BASIC_SUPPORT);
        }

        private void tryPlaceBlock(World world, int x, int y, int z, Block b, int meta, int flags, BlockKey support) {
            Block b2 = world.func_147439_a(x, y, z);
            int meta2 = world.func_72805_g(x, y, z);
            if (b2 != b || meta2 != meta) {
                world.func_147465_d(x, y, z, b, meta, flags);
            }
            if (b.func_149688_o().func_76220_a() && support != null && y == this.field_74887_e.field_78895_b) {
                for (int dy = y - 1; dy > 0 && ReikaWorldHelper.softBlocks((IBlockAccess)world, x, dy, z) && world.func_147439_a(x, dy, z) != b; --dy) {
                    world.func_147465_d(x, dy, z, support.blockID, support.metadata, 3);
                }
            }
        }

        protected final void placeBlockAtFixedPosition(World world, int i, int j, int k, Block b) {
            this.placeBlockAtFixedPosition(world, i, j, k, b, 0);
        }

        protected final Block getBlockAtFixedPosition(World world, int i, int j, int k) {
            return world.func_147439_a(i + this.field_74887_e.field_78897_a, j + this.field_74887_e.field_78895_b, k + this.field_74887_e.field_78896_c);
        }

        protected final int getMetaAtFixedPosition(World world, int i, int j, int k) {
            return world.func_72805_g(i + this.field_74887_e.field_78897_a, j + this.field_74887_e.field_78895_b, k + this.field_74887_e.field_78896_c);
        }

        protected final void placeBlockAtFixedPosition(World world, int i, int j, int k, Block b, int meta) {
            this.placeBlockAtFixedPosition(world, i, j, k, b, meta, BASIC_SUPPORT);
        }

        protected final void placeBlockAtFixedPosition(World world, int i, int j, int k, Block b, int meta, BlockKey support) {
            this.tryPlaceBlock(world, i + this.field_74887_e.field_78897_a, j + this.field_74887_e.field_78895_b, k + this.field_74887_e.field_78896_c, b, meta, 3, support);
        }

        protected final void placeBlockAtFixedPosition(World world, int i, int j, int k, BlockKey bk) {
            this.placeBlockAtFixedPosition(world, i, j, k, bk.blockID, Math.max(0, bk.metadata));
        }

        protected final TileEntity placeTileEntityAtFixedPosition(World world, int i, int j, int k, Block b, int meta) {
            this.tryPlaceBlock(world, i + this.field_74887_e.field_78897_a, j + this.field_74887_e.field_78895_b, k + this.field_74887_e.field_78896_c, b, meta, 3);
            return world.func_147438_o(i + this.field_74887_e.field_78897_a, j + this.field_74887_e.field_78895_b, k + this.field_74887_e.field_78896_c);
        }

        protected final TileEntity generateTileEntity(World world, int i, int j, int k, Block b, int meta) {
            this.placeBlockAtCurrentPosition(world, i, j, k, b, meta);
            int x = this.func_74865_a(i, k);
            int y = this.func_74862_a(j);
            int z = this.func_74873_b(i, k);
            return world.func_147438_o(x, y, z);
        }

        protected void clearVolume(World world) {
            this.clearVolume(world, 0, 0, 0, this.xSize, this.ySize, this.zSize);
        }

        protected void clearVolume(World world, int x1, int y1, int z1, int x2, int y2, int z2) {
            for (int i = x1; i < x2; ++i) {
                for (int k = z1; k < z2; ++k) {
                    for (int j = y1; j < y2; ++j) {
                        this.placeBlockAtFixedPosition(world, i, j, k, Blocks.field_150350_a);
                    }
                }
            }
        }

        public int countIntersectingBlocks(World world) {
            int c = 0;
            for (int i = 0; i < this.xSize; ++i) {
                for (int k = 0; k < this.zSize; ++k) {
                    for (int j = 0; j < this.ySize; ++j) {
                        Block b = this.getBlockAtFixedPosition(world, i, j, k);
                        if (ReikaWorldHelper.softBlocks(b)) continue;
                        ++c;
                    }
                }
            }
            return c;
        }

        public int getVolume() {
            return this.xSize * this.ySize * this.zSize;
        }

        public void rise(World world) {
            boolean flag = false;
            if (this.xSize <= 0 || this.zSize <= 0) {
                DragonAPICore.logError("Tried to raise a structure that had a zero size!");
                Thread.dumpStack();
                return;
            }
            do {
                int c = 0;
                int t = 0;
                for (int i = 0; i < this.xSize; ++i) {
                    for (int k = 0; k < this.zSize; ++k) {
                        Block b = this.getBlockAtFixedPosition(world, i, 1, k);
                        if (b == Blocks.field_150348_b || b == Blocks.field_150346_d || b == Blocks.field_150349_c || b == Blocks.field_150351_n || b == Blocks.field_150354_m || b == Blocks.field_150322_A || b == Blocks.field_150405_ch || b == Blocks.field_150406_ce || ReikaBlockHelper.isLiquid(b)) {
                            ++c;
                        }
                        ++t;
                    }
                }
                boolean bl = flag = c >= t / 4;
                if (this.field_74887_e.field_78894_e >= 255) {
                    flag = false;
                }
                if (!flag) continue;
                this.field_74887_e.func_78886_a(0, 1, 0);
            } while (flag);
        }
    }

    public static final class PerVillageWeight
    extends StructureVillagePieces.PieceWeight {
        private final int chancePerVillage;

        public PerVillageWeight(Class c, int weight, int limit, int ch) {
            super(c, weight, limit);
            this.chancePerVillage = ch;
        }

        public boolean canGenerate(MapGenVillage.Start s) {
            return this.hash(s) % (long)this.chancePerVillage == 0L;
        }

        private long hash(MapGenVillage.Start s) {
            return ChunkCoordIntPair.func_77272_a((int)s.func_143019_e(), (int)s.func_143018_f());
        }
    }

    public static class PerVillageBuilding
    extends VillageBuilding {
        public final int perVillage;

        public PerVillageBuilding(Class<? extends VillagePiece> c, float w, String n, int x, int y, int z, int p) {
            super(c, w, n, x, y, z);
            this.perVillage = p;
        }

        @Override
        public StructureVillagePieces.PieceWeight getVillagePieceWeight(Random random, int i) {
            int c = MathHelper.func_76136_a((Random)random, (int)(0 + i), (int)(1 + i));
            return new PerVillageWeight(this.buildingClass, Math.max(1, Math.round(this.weight)), c, this.perVillage);
        }
    }
}

