/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Rendering;

import Reika.DragonAPI.Instantiable.Rendering.ColorBlendList;
import Reika.DragonAPI.Libraries.IO.ReikaColorAPI;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import java.awt.Color;
import java.util.Random;

public class ColorVariance {
    private static final Random rand = new Random();
    public final int rootColor;
    public final float hueRoot;
    public final float satRoot;
    public final float lumRoot;
    public final float hueVariation;
    public final float satVariation;
    public final float lumVariation;
    public int alphaRoot = 255;
    public int alphaVariation = 0;
    public float whiteVariation = 0.0f;

    public ColorVariance(int c, float var) {
        this(c, var, var, var);
    }

    public ColorVariance(int c, float hue, float sat, float lum) {
        this.rootColor = c;
        float[] hsb = Color.RGBtoHSB(ReikaColorAPI.getRed(c), ReikaColorAPI.getGreen(c), ReikaColorAPI.getBlue(c), null);
        this.hueRoot = hsb[0];
        this.satRoot = hsb[1];
        this.lumRoot = hsb[2];
        if (hue > 1.0f) {
            hue /= 360.0f;
        }
        if (sat > 1.0f) {
            sat /= 256.0f;
        }
        if (lum > 1.0f) {
            lum /= 256.0f;
        }
        this.hueVariation = hue;
        this.satVariation = sat;
        this.lumVariation = lum;
    }

    public int[] generateColors(int n) {
        int[] ret = new int[n];
        for (int i = 0; i < n; ++i) {
            int c = this.rootColor;
            float h = this.getHue();
            float s = this.getSat();
            float b = this.getLum();
            int a = this.getAlpha();
            int c2 = Color.HSBtoRGB(h, s, b);
            if (this.whiteVariation > 0.0f) {
                c2 = ReikaColorAPI.mixColors(0xFFFFFF, c2, rand.nextFloat() * this.whiteVariation);
            }
            ret[i] = c2 = c2 & 0xFFFFFF | a << 24;
        }
        return ret;
    }

    private float getHue() {
        return this.hueVariation > 0.0f ? Math.min(1.0f, (float)ReikaRandomHelper.getRandomPlusMinus(this.hueRoot, this.hueVariation)) : this.hueRoot;
    }

    private float getSat() {
        return this.satVariation > 0.0f ? Math.min(1.0f, (float)ReikaRandomHelper.getRandomPlusMinus(this.satRoot, this.satVariation)) : this.satRoot;
    }

    private float getLum() {
        return this.lumVariation > 0.0f ? Math.min(1.0f, (float)ReikaRandomHelper.getRandomPlusMinus(this.lumRoot, this.lumVariation)) : this.lumRoot;
    }

    private int getAlpha() {
        return this.alphaVariation > 0 ? Math.min(255, ReikaRandomHelper.getRandomPlusMinus(this.alphaRoot, this.alphaVariation)) : this.alphaRoot;
    }

    public ColorBlendList getBlends(int n, float speed) {
        int[] dat = this.generateColors(n);
        ColorBlendList cbl = new ColorBlendList(speed);
        for (int i = 0; i < n; ++i) {
            cbl.addAll(dat[i]);
        }
        return cbl;
    }

    public String toString() {
        return String.format("%s = {%d,%.1f,%.1f,%.1f} > [%d,%.1f,%.1f,%.1f] / %.3f", Integer.toHexString(this.rootColor), this.alphaRoot, Float.valueOf(this.hueRoot * 360.0f), Float.valueOf(this.satRoot * 256.0f), Float.valueOf(this.lumRoot * 256.0f), this.alphaVariation, Float.valueOf(this.hueVariation * 360.0f), Float.valueOf(this.satVariation * 256.0f), Float.valueOf(this.lumVariation * 256.0f), Float.valueOf(this.whiteVariation));
    }
}

