/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.ModInteract;

import Reika.DragonAPI.ASM.APIStripper;
import Reika.DragonAPI.Exception.MisuseException;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridNotification;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkPowerIdleChange;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import java.util.EnumSet;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

@APIStripper.Strippable(value={"appeng.api.networking.IGridBlock"})
public class BasicAEInterface
implements IGridBlock {
    private final TileEntity tile;
    private final ItemStack item;
    private double powerCost = 1.0;

    public BasicAEInterface(TileEntity te, ItemStack is) {
        this(te, is, 1.0);
    }

    public BasicAEInterface(TileEntity te, ItemStack is, double basePower) {
        if (!(te instanceof IGridHost)) {
            throw new MisuseException("You cannot use a non-AE-gridHost block!");
        }
        this.tile = te;
        this.item = is;
        this.powerCost = basePower;
    }

    public void setPowerCost(double val) {
        IGrid g;
        IGridNode ig;
        if (val != this.powerCost && (ig = ((IGridHost)this.tile).getGridNode(ForgeDirection.UNKNOWN)) != null && (g = ig.getGrid()) != null) {
            this.powerCost = val;
            g.postEvent(new MENetworkPowerIdleChange(ig));
        }
    }

    @Override
    public double getIdlePowerUsage() {
        return this.powerCost;
    }

    @Override
    public EnumSet<GridFlags> getFlags() {
        return EnumSet.of(GridFlags.REQUIRE_CHANNEL);
    }

    @Override
    public boolean isWorldAccessible() {
        return true;
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this.tile);
    }

    @Override
    public AEColor getGridColor() {
        return AEColor.Transparent;
    }

    @Override
    public void onGridNotification(GridNotification notification) {
    }

    @Override
    public void setNetworkStatus(IGrid grid, int channelsInUse) {
    }

    @Override
    public EnumSet<ForgeDirection> getConnectableSides() {
        return EnumSet.allOf(ForgeDirection.class);
    }

    @Override
    public IGridHost getMachine() {
        return (IGridHost)this.tile;
    }

    @Override
    public void gridChanged() {
    }

    @Override
    public ItemStack getMachineRepresentation() {
        return this.item;
    }
}

