/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Math;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.util.MathHelper;

public class SimplexNoiseGenerator {
    private static final double STRETCH_CONSTANT = (1.0 / Math.sqrt(3.0) - 1.0) / 2.0;
    private static final double SQUISH_CONSTANT = (Math.sqrt(3.0) - 1.0) / 2.0;
    private static final double NORM_CONSTANT = 47.0;
    protected final int[] perm = new int[256];
    protected double inputFactor = 1.0;
    protected final Collection<Octave> octaves = new ArrayList<Octave>();
    protected double maxRange = 1.0;
    public boolean clampEdge = false;
    public final long seed;
    private static int[] gradients2D = new int[]{5, 2, 2, 5, -5, 2, -2, 5, 5, -2, 2, -5, -5, -2, -2, -5};

    public SimplexNoiseGenerator(long seed) {
        int i;
        int[] source = new int[256];
        for (i = 0; i < 256; ++i) {
            source[i] = i;
        }
        seed = seed * 6364136223846793005L + 1442695040888963407L;
        seed = seed * 6364136223846793005L + 1442695040888963407L;
        seed = seed * 6364136223846793005L + 1442695040888963407L;
        for (i = 255; i >= 0; --i) {
            int r = (int)(((seed = seed * 6364136223846793005L + 1442695040888963407L) + 31L) % (long)(i + 1));
            if (r < 0) {
                r += i + 1;
            }
            this.perm[i] = source[r];
            source[r] = source[i];
        }
        this.seed = seed;
    }

    public SimplexNoiseGenerator setFrequency(double f) {
        this.inputFactor = f;
        return this;
    }

    public SimplexNoiseGenerator addOctave(double relativeFrequency, double relativeAmplitude) {
        return this.addOctave(relativeFrequency, relativeAmplitude, 0.0);
    }

    public SimplexNoiseGenerator addOctave(double relativeFrequency, double relativeAmplitude, double phaseShift) {
        this.octaves.add(new Octave(relativeFrequency, relativeAmplitude, phaseShift));
        this.maxRange += relativeAmplitude;
        return this;
    }

    public double getValue(double x, double z) {
        double val = this.calcValue(x *= this.inputFactor, z *= this.inputFactor, 1.0, 1.0);
        if (!this.octaves.isEmpty()) {
            for (Octave o : this.octaves) {
                val += this.calcValue(x + o.phaseShift, z + o.phaseShift, o.frequency, o.amplitude);
            }
            val = this.clampEdge ? MathHelper.func_151237_a((double)val, (double)-1.0, (double)1.0) : (val /= this.maxRange);
        }
        return val;
    }

    private double calcValue(double x, double z, double f, double a) {
        double attn_ext;
        double dz_ext;
        double dx_ext;
        int zsv_ext;
        int xsv_ext;
        double dins;
        double dz2;
        double dx2;
        double attn2;
        if (f != 1.0 && f > 0.0) {
            x *= f;
            z *= f;
        }
        double stretchOffset = (x + z) * STRETCH_CONSTANT;
        double xs = x + stretchOffset;
        double zs = z + stretchOffset;
        int xsb = MathHelper.func_76128_c((double)xs);
        int zsb = MathHelper.func_76128_c((double)zs);
        double squishOffset = (double)(xsb + zsb) * SQUISH_CONSTANT;
        double xb = (double)xsb + squishOffset;
        double zb = (double)zsb + squishOffset;
        double xins = xs - (double)xsb;
        double zins = zs - (double)zsb;
        double inSum = xins + zins;
        double dx0 = x - xb;
        double dz0 = z - zb;
        double value = 0.0;
        double dx1 = dx0 - 1.0 - SQUISH_CONSTANT;
        double dz1 = dz0 - 0.0 - SQUISH_CONSTANT;
        double attn1 = 2.0 - dx1 * dx1 - dz1 * dz1;
        if (attn1 > 0.0) {
            attn1 *= attn1;
            value += attn1 * attn1 * this.extrapolate(xsb + 1, zsb + 0, dx1, dz1);
        }
        if ((attn2 = 2.0 - (dx2 = dx0 - 0.0 - SQUISH_CONSTANT) * dx2 - (dz2 = dz0 - 1.0 - SQUISH_CONSTANT) * dz2) > 0.0) {
            attn2 *= attn2;
            value += attn2 * attn2 * this.extrapolate(xsb + 0, zsb + 1, dx2, dz2);
        }
        if (inSum <= 1.0) {
            dins = 1.0 - inSum;
            if (dins > xins || dins > zins) {
                if (xins > zins) {
                    xsv_ext = xsb + 1;
                    zsv_ext = zsb - 1;
                    dx_ext = dx0 - 1.0;
                    dz_ext = dz0 + 1.0;
                } else {
                    xsv_ext = xsb - 1;
                    zsv_ext = zsb + 1;
                    dx_ext = dx0 + 1.0;
                    dz_ext = dz0 - 1.0;
                }
            } else {
                xsv_ext = xsb + 1;
                zsv_ext = zsb + 1;
                dx_ext = dx0 - 1.0 - 2.0 * SQUISH_CONSTANT;
                dz_ext = dz0 - 1.0 - 2.0 * SQUISH_CONSTANT;
            }
        } else {
            dins = 2.0 - inSum;
            if (dins < xins || dins < zins) {
                if (xins > zins) {
                    xsv_ext = xsb + 2;
                    zsv_ext = zsb + 0;
                    dx_ext = dx0 - 2.0 - 2.0 * SQUISH_CONSTANT;
                    dz_ext = dz0 + 0.0 - 2.0 * SQUISH_CONSTANT;
                } else {
                    xsv_ext = xsb + 0;
                    zsv_ext = zsb + 2;
                    dx_ext = dx0 + 0.0 - 2.0 * SQUISH_CONSTANT;
                    dz_ext = dz0 - 2.0 - 2.0 * SQUISH_CONSTANT;
                }
            } else {
                dx_ext = dx0;
                dz_ext = dz0;
                xsv_ext = xsb;
                zsv_ext = zsb;
            }
            ++xsb;
            ++zsb;
            dx0 = dx0 - 1.0 - 2.0 * SQUISH_CONSTANT;
            dz0 = dz0 - 1.0 - 2.0 * SQUISH_CONSTANT;
        }
        double attn0 = 2.0 - dx0 * dx0 - dz0 * dz0;
        if (attn0 > 0.0) {
            attn0 *= attn0;
            value += attn0 * attn0 * this.extrapolate(xsb, zsb, dx0, dz0);
        }
        if ((attn_ext = 2.0 - dx_ext * dx_ext - dz_ext * dz_ext) > 0.0) {
            attn_ext *= attn_ext;
            value += attn_ext * attn_ext * this.extrapolate(xsv_ext, zsv_ext, dx_ext, dz_ext);
        }
        return a * value / 47.0;
    }

    private double extrapolate(int xsb, int zsb, double dx, double dz) {
        int index = this.perm[this.perm[xsb & 0xFF] + zsb & 0xFF] & 0xE;
        return (double)gradients2D[index] * dx + (double)gradients2D[index + 1] * dz;
    }

    protected static class Octave {
        protected final double frequency;
        protected final double amplitude;
        protected final double phaseShift;

        private Octave(double f, double a, double p) {
            this.amplitude = a;
            this.frequency = f;
            this.phaseShift = p;
        }
    }
}

