/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.Math;

import Reika.DragonAPI.Libraries.Java.ReikaArrayHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;

public class MovingAverage {
    private final double[] data;

    public MovingAverage(int dataPoints) {
        this.data = new double[dataPoints];
    }

    public MovingAverage addValue(double val) {
        ReikaArrayHelper.cycleArray(this.data, val);
        return this;
    }

    public double getAverage() {
        double avg = 0.0;
        for (int i = 0; i < this.data.length; ++i) {
            avg += this.data[i];
        }
        return avg / (double)this.data.length;
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("size", this.data.length);
        NBTTagList li = new NBTTagList();
        for (double d : this.data) {
            li.func_74742_a((NBTBase)new NBTTagDouble(d));
        }
        tag.func_74782_a("data", (NBTBase)li);
    }

    public static MovingAverage readFromNBT(NBTTagCompound tag) {
        int size = tag.func_74762_e("size");
        MovingAverage mv = new MovingAverage(size);
        NBTTagList li = tag.func_150295_c("data", ReikaNBTHelper.NBTTypes.DOUBLE.ID);
        for (int i = 0; i < li.func_74745_c(); ++i) {
            mv.data[i] = ((NBTTagDouble)li.field_74747_a.get(i)).func_150286_g();
        }
        return mv;
    }
}

