/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable;

import Reika.DragonAPI.Exception.MisuseException;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemReq {
    public final Item itemID;
    public final int metadata;
    public final float chanceToUse;
    private int numberNeeded;
    private NBTTagCompound nbt;

    public ItemReq(Item id, int meta, float chance) {
        this.itemID = id;
        this.metadata = meta;
        if (chance > 1.0f) {
            chance = 1.0f;
        }
        this.chanceToUse = chance;
        this.numberNeeded = -1;
    }

    private ItemReq(Item id, float chance) {
        this(id, 0, chance);
    }

    public ItemReq(Block b, float chance) {
        this(b, 0, chance);
    }

    public ItemReq(Block b, int meta, float chance) {
        this(Item.func_150898_a((Block)b), meta, chance);
    }

    public ItemReq(Item id, int meta, int number) {
        if (number < 1) {
            throw new MisuseException("You must specify a valid number of items required!");
        }
        this.itemID = id;
        this.metadata = meta;
        this.chanceToUse = -1.0f;
        this.numberNeeded = number;
    }

    public boolean alwaysConsume() {
        return this.numberNeeded != -1 || this.chanceToUse == 1.0f;
    }

    public void setNBTTag(NBTTagCompound tag) {
        this.nbt = tag;
    }

    public int getNumberNeeded() {
        return this.numberNeeded;
    }

    public void use() {
        if (this.numberNeeded > 0) {
            --this.numberNeeded;
        }
    }

    public boolean callAndConsume() {
        int chance;
        Random r;
        if (this.numberNeeded > 0) {
            --this.numberNeeded;
        }
        return (r = new Random()).nextInt(chance = (int)(1.0f / this.chanceToUse)) <= 0;
    }

    public ItemStack asItemStack() {
        if (this.numberNeeded != -1) {
            return new ItemStack(this.itemID, this.numberNeeded, this.metadata);
        }
        if (this.alwaysConsume()) {
            return new ItemStack(this.itemID, 1, this.metadata);
        }
        return new ItemStack(this.itemID, 1, this.metadata);
    }
}

