/*
 * Decompiled with CFR 0.152.
 */
package Reika.DragonAPI.Instantiable.IO;

import Reika.DragonAPI.DragonAPIInit;
import Reika.DragonAPI.IO.DirectResourceManager;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.util.ResourceLocation;

public class CustomMusic
implements ISound {
    public final float volume;
    public final float pitch;
    public final String path;
    private final ResourceLocation res;
    private boolean repeat = false;
    private float posX;
    private float posY;
    private float posZ;

    public CustomMusic(String path) {
        this(path, 1.0f, 1.0f);
    }

    public CustomMusic(String path, float vol, float p) {
        this.path = path;
        this.res = DirectResourceManager.getResource(path);
        this.volume = vol;
        this.pitch = p;
    }

    public CustomMusic setRepeating() {
        this.repeat = true;
        return this;
    }

    public ResourceLocation func_147650_b() {
        return this.res;
    }

    public boolean func_147657_c() {
        return this.repeat;
    }

    public int func_147652_d() {
        return 0;
    }

    public float func_147653_e() {
        return this.volume;
    }

    public float func_147655_f() {
        return this.pitch;
    }

    public float func_147649_g() {
        return this.posX;
    }

    public float func_147654_h() {
        return this.posY;
    }

    public float func_147651_i() {
        return this.posZ;
    }

    public ISound.AttenuationType func_147656_j() {
        return ISound.AttenuationType.NONE;
    }

    public void play(SoundHandler sh) {
        EntityClientPlayerMP ep = Minecraft.func_71410_x().field_71439_g;
        this.posX = (float)ep.field_70165_t;
        this.posY = (float)ep.field_70163_u;
        this.posZ = (float)ep.field_70161_v;
        sh.func_147682_a((ISound)this);
    }

    public void stream(MusicFinishedCallback call) {
        MusicStreamer t = new MusicStreamer(call);
        t.start();
    }

    public boolean resourceExists() {
        return DragonAPIInit.class.getClassLoader().getResourceAsStream(this.path) != null;
    }

    private class MusicStreamer
    extends Thread {
        private final MusicFinishedCallback call;

        public MusicStreamer(MusicFinishedCallback c) {
            this.call = c;
        }

        @Override
        public void run() {
            AudioInputStream audioInputStream = this.verifyInputStream();
            if (audioInputStream == null) {
                return;
            }
            AudioFormat format = audioInputStream.getFormat();
            SourceDataLine audioLine = this.openInputStream(format);
            if (audioLine != null) {
                audioLine.start();
                this.playInputStream(audioInputStream, audioLine);
            }
            this.call.onFinishedMusicTrack();
        }

        private AudioInputStream verifyInputStream() {
            AudioInputStream audioInputStream = null;
            try {
                InputStream in = DirectResourceManager.getInstance().func_110536_a(CustomMusic.this.res).func_110527_b();
                audioInputStream = AudioSystem.getAudioInputStream(in);
            }
            catch (UnsupportedAudioFileException e) {
                e.printStackTrace();
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
            return audioInputStream;
        }

        private SourceDataLine openInputStream(AudioFormat format) {
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
            SourceDataLine audioLine = null;
            try {
                audioLine = (SourceDataLine)AudioSystem.getLine(info);
                audioLine.open(format);
            }
            catch (LineUnavailableException e) {
                e.printStackTrace();
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            return audioLine;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void playInputStream(AudioInputStream audioInputStream, SourceDataLine audioLine) {
            int externalBufferSize = (int)audioInputStream.getFrameLength() * 4;
            int nBytesRead = 0;
            byte[] abData = new byte[externalBufferSize];
            try {
                while (nBytesRead != -1) {
                    nBytesRead = audioInputStream.read(abData, 0, abData.length);
                    if (nBytesRead < 0) continue;
                    audioLine.write(abData, 0, nBytesRead);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            finally {
                audioLine.drain();
                audioLine.close();
            }
        }
    }

    public static interface MusicFinishedCallback {
        public void onFinishedMusicTrack();
    }
}

